/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.OseeApiBase;
import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsPerformance;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.SystemProperties;
import org.eclipse.osee.orcs.core.ds.DataModule;
import org.eclipse.osee.orcs.core.ds.OrcsDataStore;
import org.eclipse.osee.orcs.core.internal.KeyValueOpsImpl;
import org.eclipse.osee.orcs.core.internal.OrcsAdminImpl;
import org.eclipse.osee.orcs.core.internal.OrcsBranchImpl;
import org.eclipse.osee.orcs.core.internal.OrcsPerformanceImpl;
import org.eclipse.osee.orcs.core.internal.access.AccessControlServiceImpl;
import org.eclipse.osee.orcs.core.internal.access.UserServiceImpl;
import org.eclipse.osee.orcs.core.internal.applicability.OrcsApplicabilityOps;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilderFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.graph.impl.GraphFactoryImpl;
import org.eclipse.osee.orcs.core.internal.indexer.IndexerModule;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.proxy.impl.ExternalArtifactManagerImpl;
import org.eclipse.osee.orcs.core.internal.relation.RelationFactory;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;
import org.eclipse.osee.orcs.core.internal.relation.RelationManagerFactory;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeLoaderImpl;
import org.eclipse.osee.orcs.core.internal.search.QueryModule;
import org.eclipse.osee.orcs.core.internal.session.OrcsSessionImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TransactionFactoryImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TxCallableFactory;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataLoaderImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;
import org.eclipse.osee.orcs.core.internal.types.impl.OrcsTypesImpl;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.QueryIndexer;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class OrcsApiImpl
extends OseeApiBase
implements OrcsApi {
    private Log logger;
    private OrcsDataStore dataStore;
    private ExecutorAdmin executorAdmin;
    private SystemProperties properties;
    private QueryModule queryModule;
    private IndexerModule indexerModule;
    private OrcsSession systemSession;
    private DataModule module;
    private TxDataManager txDataManager;
    private TxCallableFactory txCallableFactory;
    private OrcsApplicabilityOps applicability;
    private UserService userService;
    private ActivityLog activityLog;
    private OrcsTypes orcsTypes;
    AccessControlServiceImpl accessControlService;
    ExternalArtifactManager proxyManager;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setOrcsDataStore(OrcsDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void setSystemProperties(SystemProperties properties) {
        this.properties = properties;
    }

    public void setActivityLog(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void start() {
        this.systemSession = this.createSession();
        this.module = this.dataStore.createDataModule(this.tokenService());
        this.orcsTypes = new OrcsTypesImpl(this.getSession(), this.dataStore.getTypesDataStore());
        AttributeFactory attributeFactory = new AttributeFactory(this.module.getDataFactory(), this.tokenService());
        ArtifactFactory artifactFactory = new ArtifactFactory(this.module.getDataFactory(), attributeFactory);
        RelationFactory relationFactory = new RelationFactory(this.module.getDataFactory());
        final GraphFactoryImpl graphFactory = new GraphFactoryImpl();
        GraphBuilderFactory graphBuilderFactory = new GraphBuilderFactory(this.logger, artifactFactory, attributeFactory, relationFactory);
        QueryModule.QueryModuleProvider queryModuleProvider = new QueryModule.QueryModuleProvider(){

            @Override
            public QueryFactory getQueryFactory(OrcsSession session) {
                return OrcsApiImpl.this.queryModule.createQueryFactory(session);
            }
        };
        RelationNodeLoaderImpl nodeLoader = new RelationNodeLoaderImpl(this.module.getDataLoaderFactory(), graphBuilderFactory);
        RelationManager relationManager = RelationManagerFactory.createRelationManager(this.logger, this.tokenService(), relationFactory, nodeLoader, queryModuleProvider);
        GraphProvider graphProvider = new GraphProvider(){

            @Override
            public GraphData getGraph(OrcsSession session, BranchId branch, TransactionId transactionId) {
                return graphFactory.createGraph(session, branch, transactionId);
            }
        };
        this.proxyManager = new ExternalArtifactManagerImpl(relationManager, this.tokenService());
        TxDataLoaderImpl.TransactionProvider txProvider = new TxDataLoaderImpl.TransactionProvider(){

            @Override
            public TransactionId getHeadTransaction(OrcsSession session, BranchId branch) {
                QueryFactory queryFactory = OrcsApiImpl.this.queryModule.createQueryFactory(session);
                return (TransactionId)((TransactionQuery)queryFactory.transactionQuery().andIsHead(branch)).getResults().getExactlyOne();
            }
        };
        TxDataLoaderImpl txDataLoader = new TxDataLoaderImpl(this.module.getDataLoaderFactory(), graphFactory, graphBuilderFactory, graphProvider, txProvider);
        this.txDataManager = new TxDataManager(this.proxyManager, artifactFactory, relationManager, this.module.getDataFactory(), this.module.getDataFactory(), txDataLoader);
        this.txCallableFactory = new TxCallableFactory(this.logger, this.module.getTxDataStore(), this.txDataManager);
        this.queryModule = new QueryModule(this, this.logger, this.module.getQueryEngine(), graphBuilderFactory, graphProvider, this.tokenService(), this.proxyManager);
        this.indexerModule = new IndexerModule(this.logger, this.properties, this.executorAdmin, this.dataStore.getQueryEngineIndexer());
        this.indexerModule.start(this.getSystemSession(), this.tokenService());
        this.applicability = new OrcsApplicabilityOps(this, this.logger);
        this.userService = new UserServiceImpl(this);
        this.accessControlService = new AccessControlServiceImpl(this);
        this.accessControlService.bindUserService(this.userService);
    }

    public void stop() {
        if (this.indexerModule != null) {
            this.indexerModule.stop();
        }
        this.queryModule = null;
        this.txDataManager = null;
        this.txCallableFactory = null;
        this.module = null;
        this.systemSession = null;
    }

    public QueryFactory getQueryFactory() {
        OrcsSession session = this.getSession();
        return this.queryModule.createQueryFactory(session);
    }

    public OrcsBranch getBranchOps() {
        OrcsSession session = this.getSession();
        QueryFactory queryFactory = this.getQueryFactory();
        return new OrcsBranchImpl(this, this.logger, session, this.module.getBranchDataStore(), queryFactory);
    }

    public KeyValueOps getKeyValueOps() {
        return new KeyValueOpsImpl(this.module.getKeyValueStore());
    }

    public TransactionFactory getTransactionFactory() {
        OrcsSession session = this.getSession();
        return new TransactionFactoryImpl(session, this.txDataManager, this.txCallableFactory, this, this.getBranchOps(), this.getKeyValueOps(), this.module.getTxDataStore());
    }

    public OrcsAdmin getAdminOps() {
        OrcsSession session = this.getSession();
        return new OrcsAdminImpl(this, this.logger, session, this.module.getDataStoreAdmin());
    }

    public OrcsPerformance getOrcsPerformance() {
        OrcsSession session = this.getSession();
        return new OrcsPerformanceImpl(this.logger, session, this.indexerModule);
    }

    public QueryIndexer getQueryIndexer() {
        OrcsSession session = this.getSession();
        return this.indexerModule.createQueryIndexer(session, this.tokenService());
    }

    private OrcsSession getSystemSession() {
        return this.systemSession;
    }

    private OrcsSession getSession() {
        String sessionId = GUID.create();
        return new OrcsSessionImpl(sessionId);
    }

    public OrcsTypes getOrcsTypes() {
        return this.orcsTypes;
    }

    private OrcsSession createSession() {
        String sessionId = GUID.create();
        return new OrcsSessionImpl(sessionId);
    }

    public SystemProperties getSystemProperties() {
        return this.properties;
    }

    public OrcsApplicability getApplicabilityOps() {
        return this.applicability;
    }

    public UserService userService() {
        return this.userService;
    }

    public JdbcService getJdbcService() {
        return this.dataStore.getJdbcService();
    }

    public ActivityLog getActivityLog() {
        return this.activityLog;
    }

    public IAccessControlService getAccessControlService() {
        return this.accessControlService;
    }
}

