/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchChildOf;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class BranchChildOfSqlHandler
extends SqlHandler<CriteriaBranchChildOf> {
    private CriteriaBranchChildOf criteria;
    private String cteAlias;
    private String brAlias;

    @Override
    public void setData(CriteriaBranchChildOf criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        this.cteAlias = writer.startRecursiveCommonTableExpression("chof", "(child_id, branch_level)");
        writer.write("SELECT anch_br1.branch_id, 0 as branch_level FROM osee_branch anch_br1, osee_branch anch_br2\n");
        writer.write(" WHERE anch_br1.parent_branch_id = anch_br2.branch_id AND ");
        writer.writeEqualsParameter("anch_br2", "branch_id", this.criteria.getParent());
        writer.writeCteRecursiveUnion();
        writer.write(" SELECT branch_id, branch_level + 1 FROM " + this.cteAlias + ", osee_branch br");
        writer.write(" WHERE child_id = br.parent_branch_id");
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        writer.addTable(this.cteAlias);
        this.brAlias = writer.getMainTableAlias(OseeDb.BRANCH_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeEquals(this.cteAlias, "child_id", this.brAlias, "branch_id");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_CHILD_OF.ordinal();
    }
}

