/*********************************************************************
 * Copyright (c) 2013 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.account.admin.internal.validator;

import org.eclipse.osee.account.admin.AccountField;
import org.eclipse.osee.framework.jdk.core.type.Named;

/**
 * @author Roberto E. Escobar
 */
public interface FieldValidator extends Named {

   AccountField getFieldType();

   boolean isValid(String value);

   void validate(String value);

   int getPriority();

}