/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.data;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.orcs.core.ds.OrcsVersionedObjectImpl;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.VersionData;

public class RelationDataImpl
extends OrcsVersionedObjectImpl<RelationTypeToken>
implements RelationData {
    private ArtifactId artIdA = ArtifactId.SENTINEL;
    private ArtifactId artIdB = ArtifactId.SENTINEL;
    private String rationale = "";
    private boolean useBackingData = false;

    public RelationDataImpl(VersionData version) {
        super(version);
    }

    public void setRelationId(int relationId) {
        this.setLocalId(relationId);
    }

    public void setArtIdA(ArtifactId artIdA) {
        this.artIdA = artIdA;
    }

    public void setArtIdB(ArtifactId artIdB) {
        this.artIdB = artIdB;
    }

    public void setRationale(String rationale) {
        this.rationale = rationale;
    }

    public int getRelationId() {
        return this.getLocalId();
    }

    public int getArtIdA() {
        return this.artIdA.getId().intValue();
    }

    public int getArtIdB() {
        return this.artIdB.getId().intValue();
    }

    public String getRationale() {
        return this.rationale;
    }

    public ArtifactId getArtIdOn(RelationSide side) {
        return RelationSide.SIDE_A == side ? this.getArtifactIdA() : this.getArtifactIdB();
    }

    public String toString() {
        return "RelationData [artIdA=" + this.artIdA + ", artIdB=" + this.artIdB + ", rationale=" + this.rationale + " " + super.toString() + "]";
    }

    public boolean isExistingVersionUsed() {
        return this.useBackingData;
    }

    public void setUseBackingData(boolean useBackingData) {
        this.useBackingData = useBackingData;
    }

    public ArtifactId getArtifactIdA() {
        return this.artIdA;
    }

    public ArtifactId getArtifactIdB() {
        return this.artIdB;
    }

    public Long getId() {
        return this.getLocalId().longValue();
    }
}

