/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spec.ClientImpl;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.grants.refresh.RefreshTokenGrant;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.OAuth2Flows;

public class OAuth2Transport {
    private final JaxRsApi jaxRsApi;

    public OAuth2Transport(JaxRsApi jaxRsApi) {
        this.jaxRsApi = jaxRsApi;
    }

    public ClientAccessToken sendAuthorizationCodeGrant(OAuth2Flows.OwnerCredentials owner, Consumer client, String sessionCookie, String tokenUri, String authCode, String redirectUri, Map<String, String> extraParams) {
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant();
        grant.setCode(authCode);
        grant.setRedirectUri(redirectUri);
        boolean setAuthorizationHeader = false;
        WebClient webClient = this.newWebClient(owner, tokenUri, sessionCookie);
        return OAuthClientUtils.getAccessToken((WebClient)webClient, (Consumer)client, (AccessTokenGrant)grant, extraParams, (boolean)setAuthorizationHeader);
    }

    public ClientAccessToken sendRefreshToken(OAuth2Flows.OwnerCredentials owner, Consumer client, String tokenUri, String refreshToken, String scope, Map<String, String> extraParams) {
        RefreshTokenGrant refreshGrant = new RefreshTokenGrant(refreshToken, scope);
        WebClient webClient = this.newWebClient(owner, tokenUri);
        boolean setAuthorizationHeader = false;
        return OAuthClientUtils.getAccessToken((WebClient)webClient, (Consumer)client, (AccessTokenGrant)refreshGrant, extraParams, (boolean)setAuthorizationHeader);
    }

    public Response sendAuthorizationCodeRequest(OAuth2Flows.OwnerCredentials owner, URI authorizationURI) {
        Response response;
        try {
            response = this.newTargetBuilder(owner, authorizationURI).accept(new String[]{"application/json"}).get();
        }
        catch (WebApplicationException ex) {
            response = ex.getResponse();
        }
        return response;
    }

    public Response sendAccessConfirmation(OAuth2Flows.OwnerCredentials owner, String sessionCookie, String confirmUri, Form form) {
        return this.newTargetBuilder(owner, confirmUri, sessionCookie).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.form((Form)form));
    }

    public AccessTokenValidation sendTokenValidationRequest(OAuth2Flows.OwnerCredentials owner, Consumer client, String sessionCookie, String tokenValidationUri, Form form) {
        return (AccessTokenValidation)this.newTargetBuilder(owner, tokenValidationUri, sessionCookie).accept(new String[]{"application/json"}).post(Entity.form((Form)form), AccessTokenValidation.class);
    }

    private WebClient newWebClient(OAuth2Flows.OwnerCredentials credentials, String uri) {
        return this.newWebClient(credentials, uri, null);
    }

    private Invocation.Builder newTargetBuilder(OAuth2Flows.OwnerCredentials credentials, String uri) {
        return this.newTargetBuilder(credentials, uri, null);
    }

    private Invocation.Builder newTargetBuilder(OAuth2Flows.OwnerCredentials credentials, URI uri) {
        return this.newTargetBuilder(credentials, uri.toASCIIString());
    }

    private WebClient newWebClient(OAuth2Flows.OwnerCredentials credentials, String url, String sessionCookie) {
        WebTarget target = Strings.isValid((String)sessionCookie) ? this.jaxRsApi.newTargetUrl(url) : this.jaxRsApi.newTargetUrlPasswd(url, credentials.getUsername(), credentials.getPassword());
        WebClient webClient = null;
        if (target instanceof ClientImpl.WebTargetImpl) {
            webClient = ((ClientImpl.WebTargetImpl)target).getWebClient();
        }
        if (webClient != null && Strings.isValid((String)sessionCookie)) {
            webClient.header("Cookie", new Object[]{sessionCookie});
        }
        return webClient;
    }

    private Invocation.Builder newTargetBuilder(OAuth2Flows.OwnerCredentials credentials, String url, String sessionCookie) {
        if (Strings.isValid((String)sessionCookie)) {
            return this.jaxRsApi.newTargetUrl(url).request().header("Cookie", (Object)sessionCookie);
        }
        return this.jaxRsApi.newTargetUrlPasswd(url, credentials.getUsername(), credentials.getPassword()).request();
    }
}

