/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.internal.branch.BranchDataFactory;
import org.eclipse.osee.orcs.core.internal.branch.CommitBranchCallable;
import org.eclipse.osee.orcs.core.internal.branch.PurgeBranchCallable;
import org.eclipse.osee.orcs.data.ArchiveOperation;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsBranchImpl
implements OrcsBranch {
    private final OrcsApi orcsApi;
    private final Log logger;
    private final OrcsSession session;
    private final BranchDataStore branchStore;
    private final BranchDataFactory branchDataFactory;
    private final OrcsTokenService tokenService;
    private final QueryFactory queryFactory;

    public OrcsBranchImpl(OrcsApi orcsApi, Log logger, OrcsSession session, BranchDataStore branchStore, QueryFactory queryFactory) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.session = session;
        this.branchStore = branchStore;
        this.branchDataFactory = new BranchDataFactory(queryFactory);
        this.tokenService = orcsApi.tokenService();
        this.queryFactory = queryFactory;
    }

    public XResultData createBranchValidation(CreateBranchData branchData) {
        return this.branchStore.createBranchValidation(branchData);
    }

    public Branch createBranch(CreateBranchData branchData) {
        Conditions.checkNotNull((Object)branchData, (String)"branchData");
        Conditions.checkNotNull((Object)branchData.getBranch(), (String)"branchUuid");
        Conditions.checkNotNull((Object)branchData.getName(), (String)"branchName");
        Conditions.checkNotNull((Object)branchData.getBranchType(), (String)"branchType");
        TransactionToken txData = null;
        txData = branchData.getParentBranch().isValid() ? (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branchData.getParentBranch())).getTokens().getExactlyOne() : branchData.getFromTransaction();
        Conditions.checkNotNull((Object)txData, (String)"sourceTransaction");
        branchData.setFromTransaction(txData);
        if (branchData.isTxCopyBranchType()) {
            TransactionQuery txQuery = this.queryFactory.transactionQuery();
            TransactionToken givenTx = branchData.getFromTransaction();
            Conditions.checkNotNull((Object)givenTx, (String)"Transaction used for copy");
            branchData.setSavedTransaction((TransactionId)givenTx);
            TransactionToken priorTx = (TransactionToken)((TransactionQuery)txQuery.andIsPriorTx(givenTx)).getResults().getExactlyOne();
            branchData.setFromTransaction(priorTx);
            this.branchStore.createBranchCopyTx(branchData);
        } else {
            this.branchStore.createBranch(branchData);
        }
        return (Branch)((BranchQuery)this.queryFactory.branchQuery().andId(branchData.getBranch())).getResults().getExactlyOne();
    }

    public BranchToken createTopLevelBranch(BranchToken branch, ArtifactId account) {
        return this.createTopLevelBranch(new CreateBranchData(branch), ArtifactId.SENTINEL, account);
    }

    private BranchToken createTopLevelBranch(CreateBranchData createData, ArtifactId associatedArtifact, ArtifactId account) {
        createData.setBranchType(BranchType.BASELINE);
        BranchToken parentBranch = CoreBranches.SYSTEM_ROOT;
        TransactionToken parentTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead((BranchId)parentBranch)).getTokens().getExactlyOne();
        String creationComment = String.format("New Branch from %s (%s)", parentBranch, parentTx.getId());
        createData.setCreationComment(creationComment);
        createData.setAuthor(account);
        createData.setAssociatedArtifact(associatedArtifact);
        createData.setFromTransaction(parentTx);
        createData.setParentBranch((BranchId)parentBranch);
        createData.setTxCopyBranchType(false);
        return this.createBranch(createData);
    }

    public Callable<Void> archiveUnarchiveBranch(BranchId branch, ArchiveOperation archiveOp) {
        return this.branchStore.archiveUnArchiveBranch(this.session, branch, archiveOp);
    }

    public Callable<Void> deleteBranch(BranchId branch) {
        return this.branchStore.deleteBranch(this.session, branch);
    }

    public Callable<List<BranchId>> purgeBranch(BranchId branch, boolean recurse) {
        return new PurgeBranchCallable(this.logger, this.session, this.branchStore, branch, recurse, this.queryFactory);
    }

    public Callable<TransactionToken> commitBranch(ArtifactId committer, BranchId source, BranchId destination) {
        return new CommitBranchCallable(this.logger, this.session, this.branchStore, this.queryFactory, committer, source, destination, this.tokenService);
    }

    public List<ChangeItem> compareBranch(TransactionToken sourceTx, TransactionToken destinationTx) {
        return this.branchStore.compareBranch(this.session, this.tokenService, sourceTx, destinationTx, this.queryFactory);
    }

    public List<ChangeItem> compareBranch(BranchId branch) {
        TransactionId baseTransaction = ((Branch)((BranchQuery)this.queryFactory.branchQuery().andId(branch)).getResults().getExactlyOne()).getBaselineTx();
        TransactionToken fromTx = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andTxId(baseTransaction)).getResults().getExactlyOne();
        TransactionToken toTx = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andIsHead(branch)).getResults().getExactlyOne();
        return this.branchStore.compareBranch(this.session, this.tokenService, fromTx, toTx, this.queryFactory);
    }

    public void setBranchPermission(ArtifactId subject, BranchId branch, PermissionEnum permission) {
        this.branchStore.setBranchPermission(subject, branch, permission);
    }

    public Callable<Void> changeBranchState(BranchId branch, BranchState branchState) {
        return this.branchStore.changeBranchState(this.session, branch, branchState);
    }

    public Callable<Void> changeBranchType(BranchId branch, BranchType branchType) {
        return this.branchStore.changeBranchType(this.session, branch, branchType);
    }

    public Callable<Void> changeBranchName(BranchId branch, String branchName) {
        return this.branchStore.changeBranchName(this.session, branch, branchName);
    }

    public Callable<Void> associateBranchToArtifact(BranchId branch, ArtifactId associatedArtifact) {
        Conditions.checkNotNull((Object)associatedArtifact, (String)"associatedArtifact");
        return this.branchStore.changeBranchAssociatedArt(this.session, branch, associatedArtifact);
    }

    public Callable<Void> unassociateBranch(BranchId branch) {
        return this.branchStore.changeBranchAssociatedArt(this.session, branch, ArtifactId.SENTINEL);
    }

    public Callable<URI> exportBranch(List<? extends BranchId> branches, PropertyStore options, String exportName) {
        return this.branchStore.exportBranch(this.session, branches, options, exportName);
    }

    public Callable<URI> importBranch(URI fileToImport, List<? extends BranchId> branches, PropertyStore options) {
        return this.branchStore.importBranch(this.session, fileToImport, branches, options);
    }

    public Callable<URI> checkBranchExchangeIntegrity(URI fileToCheck) {
        return this.branchStore.checkBranchExchangeIntegrity(this.session, fileToCheck);
    }

    public Branch createBaselineBranch(BranchToken branch, ArtifactId author, BranchToken parent, ArtifactId associatedArtifact) {
        CreateBranchData branchData = this.branchDataFactory.createBaselineBranchData(branch, author, parent, associatedArtifact);
        Branch newBranch = this.createBranch(branchData);
        this.setBranchPermission(author, (BranchId)newBranch, PermissionEnum.FULLACCESS);
        return newBranch;
    }

    public Branch createWorkingBranch(BranchToken branch, ArtifactId author, BranchToken parent, ArtifactId associatedArtifact) {
        CreateBranchData branchData = this.branchDataFactory.createWorkingBranchData(branch, author, parent, associatedArtifact);
        return this.createBranch(branchData);
    }

    public Branch createCopyTxBranch(BranchToken branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact) {
        CreateBranchData branchData = this.branchDataFactory.createCopyTxBranchData(branch, author, fromTransaction, associatedArtifact);
        return this.createBranch(branchData);
    }

    public Branch createPortBranch(BranchToken branch, ArtifactId author, TransactionId fromTransaction, ArtifactId associatedArtifact) {
        CreateBranchData branchData = this.branchDataFactory.createPortBranchData(branch, author, fromTransaction, associatedArtifact);
        return this.createBranch(branchData);
    }

    public void addMissingApplicabilityFromParentBranch(BranchId branch) {
        this.branchStore.addMissingApplicabilityFromParentBranch(branch);
    }

    public BranchToken createProgramBranch(BranchToken branch, UserId account) {
        BranchToken newBranch = this.createTopLevelBranch(branch, (ArtifactId)account);
        this.setBranchPermission((ArtifactId)account, (BranchId)branch, PermissionEnum.FULLACCESS);
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)branch, account, "Create Program Hierarchy");
        tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SystemRequirementsFolder);
        tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SubSystemRequirementsFolder);
        tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SoftwareRequirementsFolder);
        tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.HardwareRequirementsFolder);
        tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.InterfaceMessagesFolder);
        tx.createArtifact((ArtifactId)CoreArtifactTokens.InterfaceMessagesFolder, CoreArtifactTokens.InterfacePlatformTypesFolder);
        String[] stringArray = new String[]{"Verification Tests", "Validation Tests", "Integration Tests", "Applicability Tests"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTypes.Folder, name);
            tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.GitRepoFolder);
            ++n2;
        }
        tx.createArtifact(CoreArtifactTokens.CustomerReqFolder);
        tx.commit();
        return newBranch;
    }

    public XResultData setBranchCategory(BranchId branch, BranchCategoryToken category) {
        XResultData result = new XResultData();
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "Set Branch Category");
        tx.createBranchCategory(branch, category);
        tx.commit();
        return result;
    }

    public XResultData deleteBranchCategory(BranchId branch, BranchCategoryToken category) {
        XResultData result = new XResultData();
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "Delete Branch Category");
        tx.deleteBranchCategory(branch, category);
        tx.commit();
        return result;
    }
}

