/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetOptionHandler;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.WidgetOptionHandler;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristic;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class WidgetDefinition
extends LayoutItem {
    private final AttributeTypeToken attributeType;
    private final ComputedCharacteristicToken<?> computedCharacteristic;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final RelationTypeSide relationTypeSide;
    private final WidgetOptionHandler options = new WidgetOptionHandler(new WidgetOption[0]);
    private String toolTip;
    private String description;
    private int height;
    private String xWidgetName;
    private String defaultValue;
    private Double min;
    private Double max;

    public WidgetDefinition(String name) {
        this(name, "", new WidgetOption[0]);
    }

    public WidgetDefinition(String name, AttributeTypeToken attributeType, String xWidgetName, WidgetOption ... widgetOptions) {
        this(name, RelationTypeSide.SENTINEL, attributeType, ComputedCharacteristicToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(String name, String xWidgetName, WidgetOption ... widgetOptions) {
        this(name, RelationTypeSide.SENTINEL, (AttributeTypeToken)AttributeTypeToken.SENTINEL, ComputedCharacteristicToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(String name, RelationTypeSide relationTypeSide, String xWidgetName, WidgetOption ... widgetOptions) {
        this(name, relationTypeSide, (AttributeTypeToken)AttributeTypeToken.SENTINEL, ComputedCharacteristicToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(String name, RelationTypeSide relationTypeSide, AttributeTypeToken attributeType, ComputedCharacteristic<?> computedCharacteristic, String xWidgetName, WidgetOption ... widgetOptions) {
        super(name);
        this.relationTypeSide = relationTypeSide;
        Conditions.assertNotNull((Object)attributeType, (String)"attribute type can not be null for WidgetDefinition [%s]", (Object[])new Object[]{name});
        this.attributeType = attributeType;
        this.computedCharacteristic = computedCharacteristic;
        this.xWidgetName = xWidgetName;
        WidgetOption[] widgetOptionArray = widgetOptions;
        int n = widgetOptions.length;
        int n2 = 0;
        while (n2 < n) {
            WidgetOption opt = widgetOptionArray[n2];
            this.options.add(opt);
            ++n2;
        }
    }

    public WidgetDefinition(AttributeTypeToken attrType, String xWidgetName, WidgetOption ... widgetOptions) {
        this(attrType.getUnqualifiedName(), RelationTypeSide.SENTINEL, attrType, ComputedCharacteristicToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(ComputedCharacteristic<?> computedCharacteristic, String xWidgetName, WidgetOption ... widgetOptions) {
        this(computedCharacteristic.getName(), RelationTypeSide.SENTINEL, (AttributeTypeToken)AttributeTypeToken.SENTINEL, computedCharacteristic, xWidgetName, widgetOptions);
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public boolean is(WidgetOption widgetOption) {
        return this.options.contains(widgetOption);
    }

    public void set(WidgetOption widgetOption) {
        this.options.add(widgetOption);
    }

    public String getXWidgetName() {
        return this.xWidgetName;
    }

    public void setXWidgetName(String xWidgetName) {
        this.xWidgetName = xWidgetName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String toString() {
        return String.format("[%s][%s]", this.getName(), this.getAttributeType().isValid() ? this.getAttributeType().toStringWithId() : "");
    }

    public IAtsWidgetOptionHandler getOptions() {
        return this.options;
    }

    public void setConstraint(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    public ComputedCharacteristicToken<?> getComputedCharacteristic() {
        return this.computedCharacteristic;
    }

    public RelationTypeSide getRelationTypeSide() {
        return this.relationTypeSide;
    }

    public void addParameter(String key, Object obj) {
        this.parameters.put(key, obj);
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

