/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.rest.importing.parsers.BlockAttr;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class BlockAttrText
extends BlockAttr {
    private static final String BLOCK_ATTR_REGEX = "^[^:]+:\\s*(.*)";

    public BlockAttrText(String typeRegex, String contentRegex, String attrTypeName, AttributeTypeToken type) {
        super(typeRegex, contentRegex, attrTypeName, type);
    }

    @Override
    public Boolean fillContent(String content) {
        Boolean match = false;
        Conditions.assertNotNullOrEmpty((String)content, (String)"null content in add content to block", (Object[])new Object[0]);
        String strippedContent = content.replaceAll("<[^>]+>", "");
        Matcher matcher = this.typeRegex.matcher(strippedContent);
        if (matcher.find()) {
            Matcher valueMatcher = Pattern.compile(BLOCK_ATTR_REGEX).matcher(content.replaceAll("<[^>]+>", ""));
            if (valueMatcher.find()) {
                String objectText = valueMatcher.group(1);
                if (Strings.isValid((String)objectText)) {
                    Matcher contentMatcher = this.contentRegex.matcher(content);
                    if (contentMatcher.find()) {
                        String paragraph = contentMatcher.group(1);
                        String text = contentMatcher.group(3);
                        this.data = String.valueOf(paragraph) + text.replaceFirst("<w:r><w:t> :  ", "<w:r><w:t>");
                    }
                } else {
                    this.data = "";
                }
            }
            match = true;
        }
        return match;
    }
}

