/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.structure.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.enums.token.AgileChangeTypeAttributeType;
import org.eclipse.osee.ats.api.data.enums.token.PriorityAttributeType;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.CommentArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.CustomizedTeamWorkFlowArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TeamWorkFlowArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifactsContainer;
import org.eclipse.osee.icteam.common.clientserver.util.CommentItem;
import org.eclipse.osee.icteam.common.clientserver.util.CommentType;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.mail.notifier.ICTeamMailNotifier;
import org.eclipse.osee.icteam.web.mail.notifier.ICTeamNotifyType;
import org.eclipse.osee.icteam.web.rest.data.write.CustomizedTeamWorkFlowArtifactLoader;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.InterfaceAdapter;
import org.eclipse.osee.icteam.web.rest.layer.util.UserUtility;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

@Path(value="tasks")
public class TeamWorkflowResource
extends AbstractConfigResource {
    public TeamWorkflowResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.TeamWorkflow, atsApi, orcsApi);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="tasksforuserAndSprint")
    public String getTeamWorkflowForCurrentUserAndSprint(String currentUser) throws OseeCoreException {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
        TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(currentUser, TransferableArtifact.class);
        if (artifact == null) {
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            JSONSerializer serializer = new JSONSerializer();
            String json = serializer.deepSerialize((Object)container);
            return json;
        }
        String sprintGuid = artifact.getParentGuid();
        String userGuid = artifact.getUuid();
        List filterList = artifact.getAttributes("filter");
        if (filterList == null || filterList.size() == 0) {
            filterList.add("Working");
        }
        TransferableArtifactsContainer container = new TransferableArtifactsContainer();
        ArrayList<TransferableArtifact> artifacts = new ArrayList<TransferableArtifact>();
        ArtifactReadable sprintArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(sprintGuid, (BranchId)CoreBranches.COMMON, orcsApi);
        ResultSet tasks = null;
        for (String filter : filterList) {
            block18: {
                QueryBuilder query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).and((AttributeTypeId)AtsAttributeTypes.CurrentStateType, filter, QueryOption.EXACT_MATCH_OPTIONS).andRelatedTo(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, (ArtifactId)sprintArtifact);
                if (filter.equals("Working")) {
                    if (userGuid != null && userGuid.length() > 0) {
                        ArtifactReadable userArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(userGuid, (BranchId)CoreBranches.COMMON, orcsApi);
                        query = query.and((AttributeTypeId)AtsAttributeTypes.CurrentState, userArtifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserId), new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY});
                    }
                    try {
                        tasks = query.getResults();
                    }
                    catch (OseeCoreException e) {
                        e.printStackTrace();
                    }
                } else if (filter.equals("Completed") || filter.equals("Cancelled")) {
                    try {
                        ArrayList<ArtifactReadable> listCompCan = new ArrayList<ArtifactReadable>();
                        ResultSet tempList = query.getResults();
                        if (userGuid != null && userGuid.length() > 0) {
                            ArtifactReadable userArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(userGuid, (BranchId)CoreBranches.COMMON, orcsApi);
                            String userId = userArtifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserId);
                            for (ArtifactReadable artifactReadable : tempList) {
                                Object completedByUserID;
                                ResultSet attributes;
                                if (filter.equals("Completed")) {
                                    attributes = artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CompletedBy);
                                    if (attributes == null || attributes.size() <= 0) continue;
                                    for (AttributeReadable attributeReadable : attributes) {
                                        completedByUserID = (String)attributeReadable.getValue();
                                        if (!((String)completedByUserID).equals(userId)) continue;
                                        listCompCan.add(artifactReadable);
                                    }
                                    continue;
                                }
                                if (!filter.equals("Cancelled") || (attributes = artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.CancelledBy)) == null || attributes.size() <= 0) continue;
                                for (AttributeReadable attributeReadable : attributes) {
                                    completedByUserID = (String)attributeReadable.getValue();
                                    if (!((String)completedByUserID).equals(userId)) continue;
                                    listCompCan.add(artifactReadable);
                                }
                            }
                            tasks = ResultSets.newResultSet(listCompCan);
                            break block18;
                        }
                        tasks = tempList;
                    }
                    catch (OseeCoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ArtifactReadable mileStoneArtifact = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)sprintArtifact).getResults().getExactlyOne();
            ArtifactReadable projectArtifact = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andRelatedTo(AtsRelationTypes.ProjectToVersion_Version, (ArtifactId)mileStoneArtifact).getResults().getExactlyOne();
            List<ITransferableArtifact> usersFromTeam = this.getTeamUsers(projectArtifact);
            if (tasks == null || tasks.size() <= 0) continue;
            for (ArtifactReadable task : tasks) {
                IAtsWorkItem workItem = OseeCoreData.getAtsServer().getWorkItemService().getWorkItem((ArtifactToken)task);
                List toStates = workItem.getStateDefinition().getToStates();
                ArrayList<String> states = new ArrayList<String>();
                for (Object element : toStates) {
                    IAtsStateDefinition iAtsStateDefinition = (IAtsStateDefinition)element;
                    states.add(iAtsStateDefinition.getName());
                }
                String shortname = ((AttributeReadable)((ArtifactReadable)task.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne()).getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString();
                String workPackage = ((AttributeReadable)task.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString();
                String taskId = String.valueOf(shortname) + "-" + workPackage;
                TransferableArtifact ar = new TransferableArtifact();
                TranferableArtifactLoader.copyBasicTaskInfoToTransferableArtifact(task, ar);
                ar.putAttributes("states", states);
                ar.putRelations("AssigneeForCombo", usersFromTeam);
                ar.putAttributes("TaskId", Arrays.asList(taskId));
                artifacts.add(ar);
            }
        }
        container.addAll(artifacts);
        String json = gson.toJson((Object)container);
        return json;
    }

    private List<ITransferableArtifact> getTeamUsers(ArtifactReadable projectArtifact) {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        ResultSet teams = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andRelatedTo(AtsRelationTypes.ProjectToTeamDefinition_Project, (ArtifactId)projectArtifact).getResults();
        ArrayList<ArtifactReadable> userArtifactList = new ArrayList<ArtifactReadable>();
        if (teams != null && teams.size() > 0) {
            for (ArtifactReadable team : teams) {
                ResultSet artifacts = team.getRelated(AtsRelationTypes.TeamLead_Lead);
                for (ArtifactReadable userArtifact : artifacts) {
                    userArtifactList.add(userArtifact);
                }
                ResultSet related = team.getRelated(AtsRelationTypes.TeamMember_Member);
                for (ArtifactReadable userArtifact : related) {
                    userArtifactList.add(userArtifact);
                }
            }
        }
        ArrayList<ITransferableArtifact> assigneeList = new ArrayList<ITransferableArtifact>();
        for (ArtifactReadable user : userArtifactList) {
            TransferableArtifact userTemp = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(user, (ITransferableArtifact)userTemp);
            userTemp.putAttributes(CoreAttributeTypes.UserId.toString(), Arrays.asList(((AttributeReadable)user.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne()).toString()));
            assigneeList.add((ITransferableArtifact)userTemp);
        }
        return assigneeList;
    }

    private List<ArtifactReadable> getTeamworkFlowArtifacts(ArtifactReadable projectArtifact) {
        ArrayList<ArtifactReadable> artifactReadables = new ArrayList<ArtifactReadable>();
        try {
            ResultSet teamWorkflowArtifacts = projectArtifact.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_TeamWorkflow);
            for (ArtifactReadable artifactReadable : teamWorkflowArtifacts) {
                artifactReadables.add(artifactReadable);
            }
            return artifactReadables;
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateTeamWorkFlow(ITransferableArtifact artifact) {
        List relatedComponents;
        List relatedAgileTask;
        List relatedSuperCeded;
        List relatedSuperCedes;
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        TransactionFactory txFactory = orcsApi.getTransactionFactory();
        TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Update Team Artifact");
        String guid = artifact.getUuid();
        ArtifactReadable teamwfartifact = CommonUtil.getArtifactFromIdExcludingDeleted(guid, (BranchId)CoreBranches.COMMON, orcsApi);
        Date estimatedDate = null;
        String createdUserId = "";
        ArrayList<String> assignees = new ArrayList<String>();
        boolean sendMailToAssignee = false;
        String changes = "";
        Map attributes = artifact.getAttributes();
        Set entrySet = attributes.entrySet();
        LinkedHashMap<String, Pair> linkedHashMap = new LinkedHashMap<String, Pair>();
        String timeSpent = "";
        String estimatedTime = "";
        String currentDate = CommonUtil.getCurrentDate();
        for (Map.Entry entry : entrySet) {
            String type = (String)entry.getKey();
            String[] split = type.split(";");
            List value = (List)entry.getValue();
            for (String string : value) {
                if (split.length == 2 && split[1].equals("Date")) {
                    if (string.equals("NIL")) {
                        tx.deleteSoleAttribute((ArtifactId)teamwfartifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"));
                        continue;
                    }
                    Date date = CommonUtil.getDate(string);
                    if (date == null) continue;
                    tx.setSoleAttributeValue((ArtifactId)teamwfartifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), (Object)date);
                    if (Long.parseLong(AtsAttributeTypes.EstimatedCompletionDate.getId().toString()) != Long.parseLong(split[0])) continue;
                    estimatedDate = date;
                    continue;
                }
                if (split.length == 2 && split[1].equals("Project")) {
                    this.updateProjectAttributes(teamwfartifact, tx, split[0], string);
                    continue;
                }
                if (split[0].matches(".*[1-9].*")) {
                    if (Long.parseLong(AtsAttributeTypes.CurrentState.getId().toString()) == Long.parseLong(split[0]) && !string.contains("Cancelled") && !string.contains("Completed")) {
                        String estdate;
                        AttributeReadable estDate;
                        List<ITransferableArtifact> assignees2 = CommonUtil.getAssignees(string);
                        ArrayList<String> users = new ArrayList<String>();
                        for (ITransferableArtifact transferableArtifact : assignees2) {
                            users.add((String)transferableArtifact.getAttributes(CoreAttributeTypes.UserId.toString()).get(0));
                        }
                        assignees.addAll(users);
                        String createdBy = teamwfartifact.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CreatedBy);
                        if (createdBy != null) {
                            createdUserId = createdBy;
                        }
                        if (estimatedDate == null && (estDate = (AttributeReadable)teamwfartifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.EstimatedCompletionDate).getAtMostOneOrNull()) != null && estDate.getValue() != null && (estdate = estDate.getValue().toString()) != null) {
                            Date date;
                            estimatedDate = date = CommonUtil.getDate(estdate);
                        }
                        sendMailToAssignee = true;
                    }
                    Long.parseLong(AtsAttributeTypes.Rank.getId().toString());
                    Long.parseLong(split[0]);
                    if (split[0].equalsIgnoreCase("1152921504606847192")) {
                        if (string.contains("Completed") && !((AttributeReadable)teamwfartifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentStateType).getExactlyOne()).toString().equalsIgnoreCase("Completed")) {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault());
                            Date completedDate = null;
                            try {
                                completedDate = simpleDateFormat.parse(currentDate);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            tx.setSoleAttributeValue((ArtifactId)teamwfartifact, (AttributeTypeToken)AtsAttributeTypes.CompletedDate, (Object)completedDate);
                            tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, "Completed");
                        }
                        if (string.contains("Cancelled")) {
                            tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, "Cancelled");
                        }
                        if (string.contains("InProgress")) {
                            tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, "Working");
                        }
                        tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), string);
                        continue;
                    }
                    if (string.trim().length() > 0) {
                        tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), string);
                    }
                    if (split[0].equalsIgnoreCase("1152921504606847212")) {
                        timeSpent = string;
                    }
                    if (!split[0].equalsIgnoreCase("1152921504606847182")) continue;
                    estimatedTime = string;
                    continue;
                }
                if (split[0].equalsIgnoreCase("tag.Information")) {
                    tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AtsAttributeTypes.Information, string);
                    continue;
                }
                if (!split[0].equalsIgnoreCase("req.Condition")) continue;
                tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AtsAttributeTypes.Condition, string);
            }
        }
        if (!estimatedTime.isEmpty()) {
            String existingBurndownData = teamwfartifact.getAttributeValuesAsString((AttributeTypeToken)AtsAttributeTypes.BurnDownData);
            Gson gson = new Gson();
            LinkedHashMap existingLinkedHashMap = (LinkedHashMap)gson.fromJson(existingBurndownData, LinkedHashMap.class);
            Pair pair = new Pair((Object)estimatedTime, (Object)timeSpent);
            linkedHashMap.putAll(existingLinkedHashMap);
            linkedHashMap.put(currentDate, pair);
            JSONSerializer jsonSerializer = new JSONSerializer();
            Iterator burnDownData = jsonSerializer.deepSerialize(linkedHashMap);
            tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AtsAttributeTypes.BurnDownData, (String)((Object)burnDownData));
        }
        if (artifact.getAttributes("Product_Backlog") != null) {
            tx.unrelateFromAll(AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow, (ArtifactId)teamwfartifact);
            try {
                tx.commit();
            }
            catch (OseeCoreException e) {
                e.printStackTrace();
            }
        } else {
            List list = artifact.getRelatedArtifacts(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version.toString());
            if (list != null && list.size() > 0) {
                ArrayList<ArtifactReadable> updatedReleases = new ArrayList<ArtifactReadable>();
                tx.unrelateFromAll(AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow, (ArtifactId)teamwfartifact);
                try {
                    tx.commit();
                }
                catch (OseeCoreException e) {
                    e.printStackTrace();
                }
                ArtifactReadable wfArtifact = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(guid).getResults().getExactlyOne();
                HashSet relatedVersions = new HashSet();
                relatedVersions.addAll(list);
                if (!updatedReleases.isEmpty() || !relatedVersions.isEmpty()) {
                    if (!relatedVersions.isEmpty()) {
                        for (ITransferableArtifact transferableArtifact : relatedVersions) {
                            ArtifactReadable releaseArtifact = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(transferableArtifact.getUuid()).getResults().getExactlyOne();
                            if (updatedReleases.contains(releaseArtifact)) continue;
                            updatedReleases.add(releaseArtifact);
                        }
                    }
                    for (ArtifactReadable artifactReadable : updatedReleases) {
                        tx.relate((ArtifactId)wfArtifact, (RelationTypeToken)AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, (ArtifactId)artifactReadable);
                    }
                }
            }
        }
        if ((relatedSuperCedes = artifact.getRelatedArtifacts(CoreRelationTypes.Supercedes_Supercedes.toString())) != null) {
            for (ITransferableArtifact transferableArtifact : relatedSuperCedes) {
                ArtifactReadable tmWfArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(transferableArtifact.getUuid(), (BranchId)CoreBranches.COMMON, orcsApi);
                tx.relate((ArtifactId)tmWfArtifact, (RelationTypeToken)CoreRelationTypes.Supercedes_Supercedes, (ArtifactId)teamwfartifact);
            }
        }
        if ((relatedSuperCeded = artifact.getRelatedArtifacts(CoreRelationTypes.Supercedes_SupercededBy.toString())) != null) {
            for (ITransferableArtifact transferableArtifact : relatedSuperCeded) {
                ArtifactReadable tmWfArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(transferableArtifact.getUuid(), (BranchId)CoreBranches.COMMON, orcsApi);
                tx.relate((ArtifactId)teamwfartifact, (RelationTypeToken)CoreRelationTypes.Supercedes_SupercededBy, (ArtifactId)tmWfArtifact);
            }
        }
        if ((relatedAgileTask = artifact.getRelatedArtifacts("agileTaskLink")) != null) {
            for (ITransferableArtifact transferableArtifact : relatedAgileTask) {
                ArtifactReadable tmWfArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(transferableArtifact.getUuid(), (BranchId)CoreBranches.COMMON, orcsApi);
                tx.relate((ArtifactId)tmWfArtifact, (RelationTypeToken)AtsRelationTypes.AgileTaskLink_TeamWorkflowA, (ArtifactId)teamwfartifact);
            }
        }
        if ((relatedComponents = artifact.getRelatedArtifacts(AtsRelationTypes.ActionableItemWorkFlow_ActionableItem.toString())) != null) {
            tx.unrelateFromAll(AtsRelationTypes.ActionableItemWorkFlow_TeamWorkflow, (ArtifactId)teamwfartifact);
            for (ITransferableArtifact transferableArtifact : relatedComponents) {
                ArtifactReadable tmWfArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(transferableArtifact.getUuid(), (BranchId)CoreBranches.COMMON, orcsApi);
                tx.relate((ArtifactId)tmWfArtifact, (RelationTypeToken)AtsRelationTypes.ActionableItemWorkFlow_ActionableItem, (ArtifactId)teamwfartifact);
            }
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        teamwfartifact = CommonUtil.getArtifactFromIdExcludingDeleted(teamwfartifact.getIdString(), (BranchId)CoreBranches.COMMON, orcsApi);
        String url = (String)artifact.getAttributes("URLInfo").get(0);
        String projectGuid = ((ArtifactReadable)teamwfartifact.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne()).getGuid();
        String rapLink = String.valueOf(url) + "/icteam-web/#/dashboard/" + projectGuid + "/" + teamwfartifact.getGuid();
        if (sendMailToAssignee) {
            changes = String.valueOf(changes) + "\n" + String.format("You have been set as assignee to the task \"%s\"", teamwfartifact.getName());
            TeamWorkflowResource.sendMail(orcsApi, createdUserId, assignees, teamwfartifact, estimatedDate, ICTeamNotifyType.Updated, changes, rapLink);
        }
    }

    private void updateProjectAttributes(ArtifactReadable teamwfartifact, TransactionBuilder tx, String attrGuid, String value) {
        ArtifactReadable activeProject = (ArtifactReadable)teamwfartifact.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getAtMostOneOrNull();
        tx.setSoleAttributeFromString((ArtifactId)activeProject, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(attrGuid), (String)"Attribute"), value);
    }

    public static void sendMail(OrcsApi orcsApi, String createdUserId, List<String> assignees, ArtifactReadable teamwfartifact, Date estimatedDate, ICTeamNotifyType notify, String changes, String link) {
        ArrayList<String> mailIds = new ArrayList<String>();
        String createdUserMailId = TeamWorkflowResource.getMailIdByUserId(orcsApi, createdUserId);
        if (createdUserMailId != null) {
            mailIds.add(createdUserMailId);
        }
        for (String assignee : assignees) {
            String assigneeMailId;
            if (assignee.length() <= 0 || (assigneeMailId = TeamWorkflowResource.getMailIdByUserId(orcsApi, assignee)) == null) continue;
            mailIds.add(assigneeMailId);
        }
        ICTeamMailNotifier.notify(orcsApi, teamwfartifact, assignees, mailIds, changes, link, notify);
    }

    public static ArtifactId createNewTask(TransactionBuilder tx, TransferableArtifact artifact, OrcsApi orcsApi, Date estimatedDate, String notify, String createdUserId, List<String> assignees, String productBacklog) {
        List relatedComponents;
        String artName = "";
        if (artifact.getName() == null) {
            List artNameList = artifact.getAttributes(CoreAttributeTypes.Name.getId().toString());
            if (artNameList != null && !artNameList.isEmpty()) {
                artName = (String)artNameList.get(0);
            }
        } else {
            artName = artifact.getName();
        }
        ArtifactToken childArtifact = tx.createArtifact(AtsArtifactTypes.TeamWorkflow, artName);
        ArtifactToken childAction = tx.createArtifact(AtsArtifactTypes.Action, artName);
        tx.setSoleAttributeFromString((ArtifactId)childAction, (AttributeTypeToken)AtsAttributeTypes.Description, "des");
        tx.setSoleAttributeFromString((ArtifactId)childAction, (AttributeTypeToken)AtsAttributeTypes.ChangeType, "Problem");
        tx.setSoleAttributeFromString((ArtifactId)childAction, (AttributeTypeToken)AtsAttributeTypes.Priority, "2");
        Map attributes = artifact.getAttributes();
        Set entrySet = attributes.entrySet();
        for (Map.Entry entry : entrySet) {
            String type = (String)entry.getKey();
            String[] split = type.split(";");
            List value = (List)entry.getValue();
            LinkedHashMap<String, Pair> linkedHashMap = new LinkedHashMap<String, Pair>();
            for (String string : value) {
                if (split.length == 2 && split[1].equals("Date")) {
                    Date date = CommonUtil.getDate(string);
                    Pair pair = new Pair((Object)"0", (Object)"0");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    if (date != null) {
                        String formattedDate = simpleDateFormat.format(date);
                        linkedHashMap.put(formattedDate, pair);
                    }
                    JSONSerializer jsonSerializer = new JSONSerializer();
                    String burnDownData = jsonSerializer.deepSerialize(linkedHashMap);
                    tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.BurnDownData, burnDownData);
                    tx.setSoleAttributeValue((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), (Object)date);
                    tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinition, "WorkDef_ICTeam");
                    if (Long.parseLong(AtsAttributeTypes.EstimatedCompletionDate.getId().toString()) != Long.parseLong(split[0])) continue;
                    estimatedDate = date;
                    continue;
                }
                if (split[0].equals("raplink") || split[0].equals("Product_Backlog") || split[0].equals("ArtifactGuid") || split[0].equals("ArtifactBranchGuid") || split[0].equals("CreateTaskFromLinkGuid")) continue;
                tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(split[0]), (String)"Attribute"), string);
                if (Long.parseLong(AtsAttributeTypes.CurrentState.getId().toString()) == Long.parseLong(split[0])) {
                    notify = string.substring(0, string.indexOf(";"));
                    String assigneesStr = string.substring(string.indexOf("<") + 1, string.lastIndexOf(">"));
                    String[] _assignees = assigneesStr != null && !assigneesStr.isEmpty() ? assigneesStr.split("><") : new String[]{};
                    assignees.addAll(Arrays.asList(_assignees));
                    continue;
                }
                if (Long.parseLong(AtsAttributeTypes.CreatedBy.getId().toString()) != Long.parseLong(split[0])) continue;
                createdUserId = string;
            }
        }
        String uuid = AtsRelationTypes.ProjectToTeamWorkFlow_Project.getGuid().toString();
        String type = AtsRelationTypes.ProjectToTeamWorkFlow_Project.getRelationType().toString();
        String side = AtsRelationTypes.ProjectToTeamWorkFlow_Project.getSide().toString();
        String key = "RelationTypeSide - uuid=[" + uuid + "] type=[" + type + "] side=[" + side + "]";
        List projArtifactList = artifact.getRelatedArtifacts(key);
        if (projArtifactList != null && !projArtifactList.isEmpty()) {
            ITransferableArtifact projArt = (ITransferableArtifact)projArtifactList.get(0);
            String projectGUID = projArt.getUuid();
            ResultSet listCommon = orcsApi.getQueryFactory().fromBranch(BranchId.valueOf((String)projArt.getBranchGuid())).andUuid(Long.valueOf(projectGUID).longValue()).getResults();
            ArtifactReadable project = (ArtifactReadable)listCommon.getOneOrNull();
            String taskIDCountForProject = project.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.TaskCountForProject);
            if (taskIDCountForProject != null) {
                int taskCount = Integer.parseInt(taskIDCountForProject);
                String taskCountAttr = TeamWorkflowResource.setAndVerifyRange(++taskCount);
                tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(AtsAttributeTypes.WorkPackage.getId().toString()), (String)"Attribute"), taskCountAttr);
                if (project.getArtifactType().equals(AtsArtifactTypes.AgileProject)) {
                    tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(AtsAttributeTypes.Rank.getId().toString()), (String)"Attribute"), taskCountAttr);
                }
                orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.WorkDefinition}).getResults();
                tx.setSoleAttributeFromString((ArtifactId)project, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)AtsAttributeTypes.TaskCountForProject.getId(), (String)"Attribute"), String.valueOf(taskCount));
            }
        }
        if (productBacklog == null) {
            String uuid1 = AtsRelationTypes.TeamWorkflowTargetedForVersion_Version.getGuid().toString();
            String type1 = AtsRelationTypes.TeamWorkflowTargetedForVersion_Version.getRelationType().toString();
            String side1 = AtsRelationTypes.TeamWorkflowTargetedForVersion_Version.getSide().toString();
            String key1 = "RelationTypeSide - uuid=[" + uuid1 + "] type=[" + type1 + "] side=[" + (String)side1 + "]";
            List relatedVersions = artifact.getRelatedArtifacts(key1);
            if (relatedVersions != null) {
                for (ITransferableArtifact transferableArtifact : relatedVersions) {
                    ArtifactReadable tmWfArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(transferableArtifact.getUuid(), (BranchId)CoreBranches.COMMON, orcsApi);
                    tx.relate((ArtifactId)childArtifact, (RelationTypeToken)AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, (ArtifactId)tmWfArtifact);
                }
            }
        }
        if ((relatedComponents = artifact.getRelatedArtifacts(AtsRelationTypes.ActionableItemWorkFlow_ActionableItem.toString())) != null) {
            for (ITransferableArtifact transferableArtifact : relatedComponents) {
                ArtifactReadable projectArt = CommonUtil.getArtifactFromIdExcludingDeleted(transferableArtifact.getUuid(), (BranchId)CoreBranches.COMMON, orcsApi);
                tx.relate((ArtifactId)projectArt, (RelationTypeToken)AtsRelationTypes.ActionableItemWorkFlow_ActionableItem, (ArtifactId)childArtifact);
            }
        }
        String uuid2 = AtsRelationTypes.ProjectToTeamWorkFlow_Project.getGuid().toString();
        String type2 = AtsRelationTypes.ProjectToTeamWorkFlow_Project.getRelationType().toString();
        String side2 = AtsRelationTypes.ProjectToTeamWorkFlow_Project.getSide().toString();
        String key2 = "RelationTypeSide - uuid=[" + uuid2 + "] type=[" + type2 + "] side=[" + side2 + "]";
        List relatedproject = artifact.getRelatedArtifacts(key2);
        if (relatedproject != null) {
            for (ITransferableArtifact transferableArtifact : relatedproject) {
                ArtifactReadable tmWfArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(transferableArtifact.getUuid(), (BranchId)CoreBranches.COMMON, orcsApi);
                tx.relate((ArtifactId)tmWfArtifact, (RelationTypeToken)AtsRelationTypes.ProjectToTeamWorkFlow_Project, (ArtifactId)childArtifact);
            }
        }
        tx.relate((ArtifactId)childAction, (RelationTypeToken)AtsRelationTypes.ActionToWorkflow_TeamWorkflow, (ArtifactId)childArtifact);
        return childArtifact;
    }

    private static String getMailIdByUserId(OrcsApi orcsApi, String userId) {
        try {
            ArtifactReadable artifactReadable = UserUtility.getUserById(orcsApi, userId);
            ResultSet attrList = artifactReadable.getAttributes();
            for (AttributeReadable attributeReadable : attrList) {
                if (!attributeReadable.getValue().toString().contains("@")) continue;
                return attributeReadable.getValue().toString();
            }
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    @Path(value="nextStates")
    public String getNextStates(String str) throws OseeCoreException {
        Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
        TransferableArtifact transferableArtifact = (TransferableArtifact)gson.fromJson(str, TransferableArtifact.class);
        String guid = transferableArtifact.getUuid();
        ArrayList<String> states = this.getNextStateList(guid);
        TransferableArtifact artifact = new TransferableArtifact();
        artifact.putAttributes("states", states);
        TransferableArtifactsContainer conTemp = new TransferableArtifactsContainer();
        conTemp.setArtifactList(Arrays.asList(artifact));
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.deepSerialize((Object)conTemp);
        return json;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="transitionWeb")
    public String transitionStateWeb(String str) throws OseeCoreException {
        ResultSet resultSet;
        ResultSet teams;
        Object assigneeMailId;
        String userId;
        List assignee;
        String rapLink;
        String project;
        String completeChanges;
        String createdBy;
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
        TransferableArtifact transferableArtifact = (TransferableArtifact)gson.fromJson(str, TransferableArtifact.class);
        String url = (String)transferableArtifact.getAttributes("URLInfo").get(0);
        String guid = transferableArtifact.getUuid();
        ResultSet rootArtifact = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(guid).longValue()).getResults();
        boolean isCommit = false;
        ArtifactReadable parentArtifact = (ArtifactReadable)rootArtifact.getExactlyOne();
        TransactionFactory txFactory1 = orcsApi.getTransactionFactory();
        TransactionBuilder tx1 = txFactory1.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, transferableArtifact.getCurrentLoggedInUser()).getId()), "Update Task Status");
        AttributeReadable currentStateR = (AttributeReadable)parentArtifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentState).getAtMostOneOrNull();
        String currentStateStr = (String)currentStateR.getValue();
        String[] split = currentStateStr.split(";");
        String currentState = split[0];
        List<Object> assignees = new ArrayList<TransferableArtifact>();
        if (!currentState.equals("Completed") && !currentState.equals("Cancelled")) {
            assignees = CommonUtil.getBasicAssigneesInfo(currentStateStr);
        }
        if (currentState.equals("Completed")) {
            assignees.add(CommonUtil.getBasicCompletedByUser(parentArtifact));
        }
        if (currentState.equals("Cancelled")) {
            assignees.add(CommonUtil.getBasicCancelledBy(parentArtifact));
        }
        String toState = (String)transferableArtifact.getAttributes("toState").get(0);
        Conditions.checkNotNull((Object)toState, (String)"toState");
        String reason = (String)transferableArtifact.getAttributes("reason").get(0);
        Conditions.checkNotNull((Object)reason, (String)"reason");
        String asUserId = (String)transferableArtifact.getAttributes("asUserId").get(0);
        Conditions.checkNotNull((Object)asUserId, (String)"asUserId");
        List toStateUsers = transferableArtifact.getAttributes("toStateUserId");
        Conditions.checkNotNull((Object)toStateUsers, (String)"toStateUserId");
        String projectGuid = transferableArtifact.getParentGuid();
        Conditions.checkNotNull((Object)projectGuid, (String)"projectGuid");
        ArrayList<AtsUser> assigneesList = new ArrayList<AtsUser>();
        for (String userId2 : toStateUsers) {
            AtsUser toStateUser = AtsCoreUsers.getAtsCoreUserByUserId((String)userId2);
            if (toStateUser == null) continue;
            assigneesList.add(toStateUser);
        }
        ArtifactReadable projectArtifact = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(projectGuid).longValue()).getResults().getAtMostOneOrNull();
        String cancelComment = "";
        List cancelCommentAttr = transferableArtifact.getAttributes(AtsAttributeTypes.StateNotes.getId().toString());
        if (cancelCommentAttr != null && cancelCommentAttr.size() > 0) {
            cancelComment = (String)cancelCommentAttr.get(0);
        }
        List attributes = transferableArtifact.getAttributes("isAdmin");
        String admin = "false";
        if (!attributes.isEmpty()) {
            admin = (String)transferableArtifact.getAttributes("isAdmin").get(0);
        }
        ArtifactReadable action = null;
        action = guid.matches("[0-9]+") ? (ArtifactReadable)OseeCoreData.getAtsServer().getQueryService().getArtifact(Long.valueOf(guid)) : (ArtifactReadable)OseeCoreData.getAtsServer().getQueryService().getArtifactByGuid(guid);
        if (toState.equalsIgnoreCase("Completed") && !((AttributeReadable)parentArtifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentStateType).getExactlyOne()).toString().equalsIgnoreCase("Completed")) {
            tx1.setSoleAttributeFromString((ArtifactId)parentArtifact, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, "Completed");
            isCommit = true;
        }
        if (toState.equalsIgnoreCase("Cancelled") && !((AttributeReadable)parentArtifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentStateType).getExactlyOne()).toString().equalsIgnoreCase("Cancelled")) {
            tx1.setSoleAttributeFromString((ArtifactId)parentArtifact, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, "Cancelled");
            isCommit = true;
        }
        if (toState.equalsIgnoreCase("InProgress") && !((AttributeReadable)parentArtifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentStateType).getExactlyOne()).toString().equalsIgnoreCase("Working")) {
            tx1.setSoleAttributeFromString((ArtifactId)parentArtifact, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, "Working");
            isCommit = true;
        }
        if (isCommit) {
            tx1.commit();
        }
        CustomizedTeamWorkFlowArtifact transArtifact = new CustomizedTeamWorkFlowArtifact();
        CustomizedTeamWorkFlowArtifactLoader.copyArtifactReadbleToTransferableArtifactWithoutRelation(action, transArtifact);
        IAtsWorkItem workItem = OseeCoreData.getAtsServer().getWorkItemService().getWorkItem((ArtifactToken)action);
        AtsUser asAtsUser = OseeCoreData.getAtsServer().getUserService().getUserByUserId(asUserId);
        IAtsChangeSet changes = OseeCoreData.getAtsServer().getStoreService().createAtsChangeSet("transition Action", asAtsUser);
        TransitionHelper helper = null;
        helper = admin.equals("true") ? new TransitionHelper("Transition " + guid, Collections.singleton(workItem), toState, assigneesList, reason, changes, (AtsApi)OseeCoreData.getAtsServer(), new TransitionOption[]{TransitionOption.OverrideWorkingBranchCheck}) : new TransitionHelper("Transition " + guid, Collections.singleton(workItem), toState, assigneesList, reason, changes, (AtsApi)OseeCoreData.getAtsServer(), new TransitionOption[]{TransitionOption.None});
        helper.setTransitionUser(asAtsUser);
        TransitionManager mgr = new TransitionManager((ITransitionHelper)helper);
        TransitionResults results = mgr.handleAll();
        TransferableArtifact artifact = new TransferableArtifact();
        if (!results.isEmpty() || changes.isEmpty()) {
            String nextStates = this.getNextStates(str);
            JSONDeserializer deserializer1 = new JSONDeserializer();
            TransferableArtifactsContainer transCont = (TransferableArtifactsContainer)deserializer1.deserialize(nextStates);
            ITransferableArtifact transferableArtifact2 = (ITransferableArtifact)transCont.getArtifactList().get(0);
            transferableArtifact2.putAttributes("status", Arrays.asList("failed"));
            transferableArtifact2.putAttributes("message", Arrays.asList(results.toString()));
            String json = gson.toJson((Object)transCont);
            return json;
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
        action = guid.matches("[0-9]+") ? (ArtifactReadable)OseeCoreData.getAtsServer().getQueryService().getArtifact(Long.valueOf(guid)) : (ArtifactReadable)OseeCoreData.getAtsServer().getQueryService().getArtifactByGuid(guid);
        ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{action}).getResults();
        ArtifactReadable exactlyOne = (ArtifactReadable)result.getExactlyOne();
        CustomizedTeamWorkFlowArtifactLoader.copyArtifactReadbleToTransferableArtifactWithoutRelation(exactlyOne, transArtifact);
        if (toState.equals("Completed") || toState.equals("Cancelled")) {
            if (toState.equals("Completed") && !assignees.isEmpty()) {
                String completeChanges2 = String.format("Task \"%s\" completed by %s on %s", transArtifact.getName(), ICTeamMailNotifier.getUserNameByUserId(asUserId), DateUtil.getMMDDYY((Date)new Date()));
                String cfr_ignored_0 = (String)transferableArtifact.getAttributes("raplink").get(0);
                transArtifact.getGuid();
                transArtifact.getArtifactType();
                String project2 = ((ArtifactReadable)action.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne()).getGuid();
                String rapLink2 = String.valueOf(url) + "/icteam-web/#/dashboard/" + project2 + "/" + transArtifact.getGuid();
                ArrayList<String> assigneeMailIds2 = new ArrayList<String>();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ITransferableArtifact iTransferableArtifact : assignees) {
                    String userId3 = (String)iTransferableArtifact.getAttributes(CoreAttributeTypes.UserId.getName()).get(0);
                    String assigneeMailId2 = TeamWorkflowResource.getMailIdByUserId(orcsApi, userId3);
                    if (assigneeMailId2 == null) continue;
                    assigneeMailIds2.add(assigneeMailId2);
                    arrayList.add(userId3);
                }
                ICTeamMailNotifier.notify(orcsApi, exactlyOne, arrayList, assigneeMailIds2, completeChanges2, rapLink2, ICTeamNotifyType.Completed);
            }
            if (toState.equals("Cancelled") && !assignees.isEmpty()) {
                createdBy = exactlyOne.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CreatedBy);
                if (createdBy != null) {
                }
                completeChanges = String.format("Task \"%s\" cancelled by %s due to reason: %s on %s", transArtifact.getName(), ICTeamMailNotifier.getUserNameByUserId(asUserId), reason, DateUtil.getMMDDYY((Date)new Date()));
                project = ((ArtifactReadable)action.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne()).getGuid();
                rapLink = String.valueOf(url) + "/icteam-web/#/dashboard/" + project + "/" + transArtifact.getGuid();
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                assignee = transArtifact.getAssignee();
                for (ITransferableArtifact transferableArtifact2 : assignee) {
                    userId = (String)transferableArtifact2.getAttributes(CoreAttributeTypes.UserId.getName()).get(0);
                    assigneeMailId = TeamWorkflowResource.getMailIdByUserId(orcsApi, userId);
                    if (assigneeMailId == null) continue;
                    arrayList.add((String)assigneeMailId);
                    arrayList2.add(userId);
                }
                ICTeamMailNotifier.notify(orcsApi, exactlyOne, arrayList2, arrayList, completeChanges, rapLink, ICTeamNotifyType.Cancelled);
            }
        }
        if (!(toState.equals("Cancelled") || toState.equals("Completed") || assignees.isEmpty())) {
            createdBy = exactlyOne.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CreatedBy);
            if (createdBy != null) {
            }
            completeChanges = String.format("Task \"%s\" state changed by %s  on %s", transArtifact.getName(), ICTeamMailNotifier.getUserNameByUserId(asUserId), DateUtil.getMMDDYY((Date)new Date()));
            project = ((ArtifactReadable)action.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne()).getGuid();
            rapLink = String.valueOf(url) + "/icteam-web/#/dashboard/" + project + "/" + transArtifact.getGuid();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            assignee = transArtifact.getAssignee();
            for (ITransferableArtifact transferableArtifact2 : assignee) {
                userId = (String)transferableArtifact2.getAttributes(CoreAttributeTypes.UserId.getName()).get(0);
                assigneeMailId = TeamWorkflowResource.getMailIdByUserId(orcsApi, userId);
                if (assigneeMailId == null) continue;
                arrayList.add((String)assigneeMailId);
                arrayList3.add(userId);
            }
            ICTeamMailNotifier.notify(orcsApi, exactlyOne, arrayList3, arrayList, completeChanges, rapLink, ICTeamNotifyType.Updated);
        }
        ArtifactReadable exactlyOne1 = null;
        exactlyOne1 = guid.matches("[0-9]+") ? (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(guid).longValue()).getResults().getExactlyOne() : (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(guid).getResults().getExactlyOne();
        if (cancelComment != null && cancelComment.length() > 0) {
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Update Team Artifact");
            tx.setSoleAttributeFromString((ArtifactId)exactlyOne1, (AttributeTypeToken)AtsAttributeTypes.StateNotes, cancelComment);
            tx.commit();
        }
        ArrayList<String> userIdStringList = new ArrayList<String>();
        ArrayList<ArtifactReadable> userArtifactList = new ArrayList<ArtifactReadable>();
        if (projectArtifact != null) {
            ResultSet teams1;
            AttributeReadable currentStateR1 = (AttributeReadable)exactlyOne1.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentState).getAtMostOneOrNull();
            String string = (String)currentStateR1.getValue();
            String[] stringArray = string.split(";");
            String currentState1 = stringArray[0];
            AttributeReadable currentStateType = (AttributeReadable)exactlyOne1.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentStateType).getAtMostOneOrNull();
            String cfr_ignored_1 = (String)currentStateType.getValue();
            teams = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andRelatedTo(AtsRelationTypes.ProjectToTeamDefinition_Project, (ArtifactId)projectArtifact).getResults();
            if (teams != null && teams.size() > 0) {
                for (ArtifactReadable team : teams) {
                    ResultSet artifacts = team.getRelated(AtsRelationTypes.TeamLead_Lead);
                    Iterator iterator = artifacts.iterator();
                    while (iterator.hasNext()) {
                        ArtifactReadable userArtifact = (ArtifactReadable)iterator.next();
                        Iterator userId5 = (AttributeReadable)userArtifact.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getAtMostOneOrNull();
                        userIdStringList.add((String)userId5.getValue());
                        userArtifactList.add(userArtifact);
                    }
                    ResultSet related = team.getRelated(AtsRelationTypes.TeamMember_Member);
                    for (ArtifactReadable artifactReadable : related) {
                        AttributeReadable userId4 = (AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getAtMostOneOrNull();
                        userIdStringList.add((String)userId4.getValue());
                        userArtifactList.add(artifactReadable);
                    }
                }
            }
            if ((teams1 = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andRelatedTo(AtsRelationTypes.ProjectToTeamDefinition_Project, (ArtifactId)projectArtifact).getResults()) != null && teams1.size() > 0) {
                for (ArtifactReadable team : teams1) {
                    ResultSet artifacts = team.getRelated(AtsRelationTypes.TeamLead_Lead);
                    for (ArtifactReadable artifactReadable : artifacts) {
                        AttributeReadable userId2 = (AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getAtMostOneOrNull();
                        userIdStringList.add((String)userId2.getValue());
                        userArtifactList.add(artifactReadable);
                    }
                    ResultSet resultSet2 = team.getRelated(AtsRelationTypes.TeamMember_Member);
                    for (ArtifactReadable userArtifact : resultSet2) {
                        AttributeReadable userId6 = (AttributeReadable)userArtifact.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getAtMostOneOrNull();
                        userIdStringList.add((String)userId6.getValue());
                        userArtifactList.add(userArtifact);
                    }
                }
            }
            if (userIdStringList.size() > 0) {
                Object[] objectArray;
                TransactionFactory txFactory = orcsApi.getTransactionFactory();
                TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Update Team Artifact");
                String userString = "";
                for (ITransferableArtifact iTransferableArtifact : assignees) {
                    userIdStringList.add(iTransferableArtifact.getUserId().toString());
                    userString = String.valueOf(userString) + "<" + iTransferableArtifact.getUserId().toString() + ">";
                }
                Object[] objectArray2 = objectArray = userIdStringList.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object s = objectArray2[n2];
                    if (userIdStringList.indexOf(s) != userIdStringList.lastIndexOf(s)) {
                        userIdStringList.remove(userIdStringList.lastIndexOf(s));
                    }
                    ++n2;
                }
                if (!string.equalsIgnoreCase(currentState1 = String.valueOf(currentState1) + ";" + userString + ";;")) {
                    tx.setSoleAttributeFromString((ArtifactId)exactlyOne1, (AttributeTypeToken)AtsAttributeTypes.CurrentState, currentState1);
                    tx.commit();
                }
            }
        }
        exactlyOne1 = guid.matches("[0-9]+") ? (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(guid).longValue()).getResults().getExactlyOne() : (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(guid).getResults().getExactlyOne();
        ArrayList<Object> assigneeList = new ArrayList<Object>();
        for (ArtifactReadable artifactReadable : userArtifactList) {
            TransferableArtifact userTemp = new TransferableArtifact();
            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)userTemp);
            userTemp.putAttributes(CoreAttributeTypes.UserId.toString(), Arrays.asList(((AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne()).toString()));
            assigneeList.add(userTemp);
        }
        for (ITransferableArtifact iTransferableArtifact : assignees) {
            assigneeList.add(iTransferableArtifact);
        }
        teams = resultSet = assigneeList.toArray();
        int currentStateType = ((Object[])teams).length;
        int userTemp = 0;
        while (userTemp < currentStateType) {
            ResultSet resultSet3 = teams[userTemp];
            if (assigneeList.indexOf(resultSet3) != assigneeList.lastIndexOf(resultSet3)) {
                assigneeList.remove(assigneeList.lastIndexOf(resultSet3));
            }
            ++userTemp;
        }
        TransferableArtifact transferableArtifact2 = new TransferableArtifact();
        transferableArtifact2.setArtifactType("State");
        ArrayList<String> states = this.getNextStateList(guid);
        transferableArtifact2.putAttributes("states", states);
        assigneeList.add(transferableArtifact2);
        TransferableArtifactsContainer conTemp = new TransferableArtifactsContainer();
        conTemp.setArtifactList(assigneeList);
        String json = gson.toJson((Object)conTemp);
        return json;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="updateCommentForTWWeb")
    public String updateCommentforTeamWorkFlow(String json) {
        try {
            String isResponse;
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Update TeamWorkflow Comment Artifact");
            String guid = artifact.getUuid();
            ResultSet commentArtifact = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(guid).getResults();
            String uuid = ((ArtifactReadable)commentArtifact.getExactlyOne()).getIdString();
            ArtifactReadable teamwfartifact = CommonUtil.getArtifactFromIdExcludingDeleted(uuid, (BranchId)CoreBranches.COMMON, orcsApi);
            List userIDList = artifact.getAttributes("userID");
            String[] split = ((String)userIDList.get(0)).split(";");
            List commentList = artifact.getAttributes("comment");
            List currentState = artifact.getAttributes("currentState");
            CommentItem noteItem = new CommentItem(CommentType.Comment.name(), (String)currentState.get(0), String.valueOf(new Date().getTime()), split[0], (String)commentList.get(0));
            String xml = "";
            ResultSet attributes = teamwfartifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.StateNotes);
            if (attributes != null && attributes.size() > 0) {
                AttributeReadable exactlyOne = (AttributeReadable)attributes.getExactlyOne();
                String value = (String)exactlyOne.getValue();
                List fromXml = CommentItem.fromXml((String)value, (String)"");
                fromXml.add(noteItem);
                xml = CommentItem.toXml((List)fromXml);
            } else {
                xml = CommentItem.toXml(Arrays.asList(noteItem));
            }
            if (xml != null && xml.length() > 0) {
                tx.setSoleAttributeFromString((ArtifactId)teamwfartifact, (AttributeTypeToken)AtsAttributeTypes.StateNotes, xml);
                tx.commit();
            }
            teamwfartifact = CommonUtil.getArtifactFromIdExcludingDeleted(uuid, (BranchId)CoreBranches.COMMON, orcsApi);
            new ArrayList();
            CustomizedTeamWorkFlowArtifact ar = new CustomizedTeamWorkFlowArtifact();
            List attributes2 = artifact.getAttributes("isResponse");
            if (attributes2 != null && attributes2.size() > 0 && (isResponse = (String)attributes2.get(0)).equals("true")) {
                ArrayList<CommentArtifact> listComment = new ArrayList<CommentArtifact>();
                ResultSet commentAttributes = teamwfartifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.StateNotes);
                if (commentAttributes != null && commentAttributes.size() > 0) {
                    for (AttributeReadable comment : commentAttributes) {
                        String commentStr = (String)comment.getValue();
                        List fromXml = CommentItem.fromXml((String)commentStr, (String)"");
                        for (CommentItem commentItem : fromXml) {
                            CommentArtifact arti = new CommentArtifact();
                            arti.setMsg(commentItem.getMsg());
                            arti.setDate(commentItem.getDate());
                            ArtifactReadable userFromGivenUserId = CommonUtil.getUserFromGivenUserId(commentItem.getUser());
                            AttributeReadable exactlyOne = (AttributeReadable)userFromGivenUserId.getAttributes((AttributeTypeToken)CoreAttributeTypes.Name).getExactlyOne();
                            arti.setUser((String)exactlyOne.getValue());
                            listComment.add(arti);
                        }
                    }
                    ar.setCommentArtifactList(listComment);
                }
            }
            json = gson.toJson((Object)ar);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="taskupdateweb")
    public String updateTeamWfWeb(String json) {
        String json1 = null;
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            this.updateTeamWorkFlow((ITransferableArtifact)artifact);
            CustomizedTeamWorkFlowArtifact teamWorkFlowArtifact = this.getUpdatedTeamWorkFlowForWeb(artifact);
            List attributes = artifact.getAttributes("toState");
            if (attributes != null && attributes.size() > 0) {
                String toState = (String)attributes.get(0);
                String currentState = teamWorkFlowArtifact.getCurrentState();
                if (!currentState.equals(toState)) {
                    this.transitionStateWeb(json);
                    ArrayList<String> nextStateList = this.getNextStateList(artifact.getUuid());
                    teamWorkFlowArtifact.putAttributes("states", nextStateList);
                }
            }
            json1 = gson.toJson((Object)teamWorkFlowArtifact);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json1;
    }

    private CustomizedTeamWorkFlowArtifact getUpdatedTeamWorkFlowForWeb(TransferableArtifact artifact) {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        ResultSet result = null;
        result = artifact.getUuid().matches("[0-9]+") ? orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(artifact.getUuid()).longValue()).getResults() : orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andGuid(artifact.getUuid()).getResults();
        ArtifactReadable exactlyOne = (ArtifactReadable)result.getExactlyOne();
        new ArrayList();
        CustomizedTeamWorkFlowArtifact ar = new CustomizedTeamWorkFlowArtifact();
        ar.setName(exactlyOne.getName());
        CustomizedTeamWorkFlowArtifactLoader.copyArtifactReadbleToTransferableArtifactWithoutRelation(exactlyOne, ar);
        return ar;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getTaskDetailsWeb")
    public String getTaskDetailsByGuidWeb(String task) {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
        TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(task, TransferableArtifact.class);
        String guid = artifact.getUuid();
        ArtifactReadable teamwfartifact = CommonUtil.getArtifactFromIdExcludingDeleted(guid, (BranchId)CoreBranches.COMMON, orcsApi);
        ArrayList<TransferableArtifact> arTempListVersion = new ArrayList<TransferableArtifact>();
        ArrayList<TransferableArtifact> arTempListCompoennts = new ArrayList<TransferableArtifact>();
        String json = "";
        if (teamwfartifact != null) {
            ArtifactReadable projectArtifact = (ArtifactReadable)teamwfartifact.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne();
            AttributeReadable shortname = (AttributeReadable)projectArtifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne();
            shortname.getValue();
            ArtifactReadable teamartifact = (ArtifactReadable)projectArtifact.getRelated(AtsRelationTypes.ProjectToTeamDefinition_TeamDefinition).getExactlyOne();
            if (teamartifact != null) {
                ResultSet relatedMileStones = teamartifact.getRelated(AtsRelationTypes.TeamDefinitionToVersion_Version);
                for (ArtifactReadable mileStone : relatedMileStones) {
                    Iterator relatedSprints = mileStone.getRelated(CoreRelationTypes.DefaultHierarchical_Child);
                    if (relatedSprints == null || relatedSprints.size() <= 0) continue;
                    Iterator iterator = relatedSprints.iterator();
                    while (iterator.hasNext()) {
                        ArtifactReadable artifactReadable2 = (ArtifactReadable)iterator.next();
                        ResultSet releasedAttribute = artifactReadable2.getAttributes((AttributeTypeToken)AtsAttributeTypes.Released);
                        if (releasedAttribute == null || releasedAttribute.size() <= 0) continue;
                        for (AttributeReadable attributeReadable : releasedAttribute) {
                            boolean releasedAttributeString = (Boolean)attributeReadable.getValue();
                            if (releasedAttributeString) continue;
                            TransferableArtifact ar = new TransferableArtifact();
                            TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable2, (ITransferableArtifact)ar);
                            String displayName = String.valueOf(mileStone.getName()) + "-->" + artifactReadable2.getName();
                            ar.putAttributes("displayName", Arrays.asList(displayName));
                            arTempListVersion.add(ar);
                        }
                    }
                }
                ResultSet relatedPackages = teamartifact.getRelated(AtsRelationTypes.TeamActionableItem_ActionableItem);
                if (relatedPackages != null && relatedPackages.size() > 0) {
                    for (ArtifactReadable artifactReadable : relatedPackages) {
                        TransferableArtifact arTemp1 = new TransferableArtifact();
                        TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)arTemp1);
                        arTempListCompoennts.add(arTemp1);
                    }
                }
            }
            ArrayList<CommentArtifact> listComment = new ArrayList<CommentArtifact>();
            ResultSet commentAttributes = teamwfartifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.StateNotes);
            if (commentAttributes != null && commentAttributes.size() > 0) {
                for (AttributeReadable comment : commentAttributes) {
                    String commentStr = (String)comment.getValue();
                    List fromXml = CommentItem.fromXml((String)commentStr, (String)"");
                    for (CommentItem commentItem : fromXml) {
                        CommentArtifact arti = new CommentArtifact();
                        arti.setMsg(commentItem.getMsg());
                        arti.setDate(commentItem.getDate());
                        ArtifactReadable userFromGivenUserId = CommonUtil.getUserFromGivenUserId(commentItem.getUser());
                        AttributeReadable exactlyOne = (AttributeReadable)userFromGivenUserId.getAttributes((AttributeTypeToken)CoreAttributeTypes.Name).getExactlyOne();
                        arti.setUser((String)exactlyOne.getValue());
                        listComment.add(arti);
                    }
                }
            }
            ArrayList changeTypeList = new ArrayList();
            ArrayList priorityTypeList = new ArrayList();
            HashSet<String> valuesAsOrderedStringSetChangeType = new HashSet<String>();
            for (AgileChangeTypeAttributeType.AgileChangeTypeEnum changeTypeEnum : AtsAttributeTypes.AgileChangeType.getEnumValues()) {
                valuesAsOrderedStringSetChangeType.add(changeTypeEnum.getName());
            }
            changeTypeList.addAll(valuesAsOrderedStringSetChangeType);
            HashSet<String> valuesAsOrderedStringSetPriority = new HashSet<String>();
            Collection enumValues2 = AtsAttributeTypes.Priority.getEnumValues();
            for (PriorityAttributeType.PriorityEnum changeTypeEnum : enumValues2) {
                valuesAsOrderedStringSetPriority.add(changeTypeEnum.getName());
            }
            priorityTypeList.addAll(valuesAsOrderedStringSetPriority);
            ArrayList<String> nextStateList = this.getNextStateList(guid);
            CustomizedTeamWorkFlowArtifact ar = new CustomizedTeamWorkFlowArtifact();
            ar.putAttributes("ChangeTypeList", changeTypeList);
            ar.putAttributes("priorityList", priorityTypeList);
            ar.putAttributes("states", nextStateList);
            ar.setCommentArtifactList(listComment);
            ar.setListVersionsDropDown(arTempListVersion);
            ar.setListCompoenntsDropDown(arTempListCompoennts);
            ar.putAttributes(AtsAttributeTypes.Shortname.toString(), Arrays.asList(shortname.toString()));
            ar.putAttributes("WorkPackage", Arrays.asList(((AttributeReadable)teamwfartifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString()));
            ArrayList<TransferableArtifact> listReview = new ArrayList<TransferableArtifact>();
            ResultSet relatedReview = teamwfartifact.getRelated(AtsRelationTypes.TeamWorkflowToReview_Review);
            if (relatedReview != null && relatedReview.size() > 0) {
                for (ArtifactReadable artifactReadable : relatedReview) {
                    TransferableArtifact arReview = new TransferableArtifact();
                    TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)arReview);
                    listReview.add(arReview);
                }
            }
            ar.putRelations(AtsRelationTypes.TeamWorkflowToReview_Review.getName(), listReview);
            ResultSet taginformationAttributes = teamwfartifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.Information);
            if (taginformationAttributes != null && taginformationAttributes.size() > 0) {
                AttributeReadable exactlyOne = (AttributeReadable)taginformationAttributes.getExactlyOne();
                String string = exactlyOne.getValue().toString();
                ar.putAttributes(AtsAttributeTypes.Information.getName(), Arrays.asList(string));
            } else {
                ar.putAttributes(AtsAttributeTypes.Information.getName(), Arrays.asList(""));
            }
            ResultSet reqConditionAttributes = teamwfartifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.Condition);
            if (reqConditionAttributes != null && reqConditionAttributes.size() > 0) {
                AttributeReadable exactlyOne = (AttributeReadable)reqConditionAttributes.getExactlyOne();
                String string = exactlyOne.getValue().toString();
                ar.putAttributes(AtsAttributeTypes.Condition.getName(), Arrays.asList(string));
            } else {
                ar.putAttributes(AtsAttributeTypes.Condition.getName(), Arrays.asList(""));
            }
            CustomizedTeamWorkFlowArtifactLoader.copyArtifactReadbleToTransferableArtifactWithoutRelation(teamwfartifact, ar);
            json = gson.toJson((Object)ar);
        }
        return json;
    }

    private ArrayList<String> getNextStateList(String uuid) {
        ArtifactReadable action = null;
        action = uuid.matches("[0-9]+") ? (ArtifactReadable)OseeCoreData.getAtsServer().getQueryService().getArtifact(Long.valueOf(uuid)) : (ArtifactReadable)OseeCoreData.getAtsServer().getQueryService().getArtifactByGuid(uuid);
        IAtsWorkItem workItem = OseeCoreData.getAtsServer().getWorkItemService().getWorkItem((ArtifactToken)action);
        List toStates = workItem.getStateDefinition().getToStates();
        ArrayList<String> states = new ArrayList<String>();
        for (Object element : toStates) {
            IAtsStateDefinition iAtsStateDefinition = (IAtsStateDefinition)element;
            states.add(iAtsStateDefinition.getName());
        }
        return states;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="tasksforBackLog")
    public String getTeamWorkflowForProjectBackLog(String json) throws OseeCoreException {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
        TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
        String guid = artifact.getUuid();
        ArtifactReadable projectArtifact = CommonUtil.getArtifactFromIdExcludingDeleted(guid, (BranchId)CoreBranches.COMMON, orcsApi);
        String shortName = ((AttributeReadable)projectArtifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString();
        TransferableArtifactsContainer container = new TransferableArtifactsContainer();
        List<ArtifactReadable> teamworkFlowArtifacts = this.getTeamworkFlowArtifacts(projectArtifact);
        ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
        if (teamworkFlowArtifacts != null) {
            for (ArtifactReadable artifactReadable : teamworkFlowArtifacts) {
                ResultSet relatedSprints = artifactReadable.getRelated(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version);
                if (relatedSprints.size() != 0) continue;
                String workPackageId = ((AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString();
                String taskId = String.valueOf(shortName) + "-" + workPackageId;
                TransferableArtifact ar = new TransferableArtifact();
                ArrayList<String> states = this.getNextStateList(artifactReadable.getGuid());
                TranferableArtifactLoader.copyBasicTaskInfoToTransferableArtifact(artifactReadable, ar);
                ar.putAttributes("states", states);
                ar.putAttributes("TaskId", Arrays.asList(taskId));
                List<ITransferableArtifact> usersFromGroupWeb = this.getAssigneesForCombo(projectArtifact.getIdString(), ar.getUuid());
                ar.putRelations("AssigneeForCombo", usersFromGroupWeb);
                listTras.add(ar);
            }
            container.addAll(listTras);
        }
        JSONSerializer serializer = new JSONSerializer();
        json = serializer.deepSerialize((Object)container);
        return json;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="taskforGuidsWeb")
    public String getTeamWorkFlowFromGuidWeb(String task) throws OseeCoreException {
        OrcsApi orcsApi = OseeCoreData.getOrcsApi();
        Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
        TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(task, TransferableArtifact.class);
        ArtifactReadable teamwfartifact = CommonUtil.getArtifactFromIdExcludingDeleted(artifact.guid, (BranchId)CoreBranches.COMMON, orcsApi);
        ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
        if (teamwfartifact != null) {
            TransferableArtifact ar = new TransferableArtifact();
            ar.setBranchGuid(teamwfartifact.getBranch().getId());
            TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(teamwfartifact, (ITransferableArtifact)ar);
            listTras.add(ar);
        }
        String json = "";
        TransferableArtifactsContainer container = new TransferableArtifactsContainer();
        container.addAll(listTras);
        JSONSerializer serializer = new JSONSerializer();
        json = serializer.deepSerialize((Object)container);
        System.out.println(json);
        return json;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="createTask")
    public String createTask(String json) {
        String json1 = "";
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String url = artifact.geturlinfo();
            List attributes = artifact.getAttributes("Product_Backlog");
            String productBacklog = null;
            if (attributes != null && attributes.size() > 0 && !attributes.isEmpty()) {
                productBacklog = (String)attributes.get(0);
            }
            List workspaceArtifact = artifact.getAttributes("ArtifactGuid");
            String artifactGuid = null;
            if (workspaceArtifact != null && workspaceArtifact.size() > 0 && !workspaceArtifact.isEmpty()) {
                artifactGuid = (String)workspaceArtifact.get(0);
            }
            List workspaceBranch = artifact.getAttributes("ArtifactBranchGuid");
            String artifactBranchGuid = null;
            if (workspaceBranch != null && workspaceBranch.size() > 0 && !workspaceBranch.isEmpty()) {
                artifactBranchGuid = (String)workspaceBranch.get(0);
            }
            List linkTaskInTaskPage = artifact.getAttributes("CreateTaskFromLinkGuid");
            String linkTaskGuid = null;
            if (linkTaskInTaskPage != null && linkTaskInTaskPage.size() > 0 && !linkTaskInTaskPage.isEmpty()) {
                linkTaskGuid = (String)linkTaskInTaskPage.get(0);
            }
            ArtifactId childArtifact = null;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Add New task");
            new TransferableArtifactsContainer();
            Date estimatedDate = null;
            String notify = "";
            String createdUserId = (String)artifact.getAttributesOrElse(AtsAttributeTypes.CreatedBy.getId().toString()).get(0);
            ArrayList<String> assignees = new ArrayList<String>();
            ArrayList<String> listTemp = new ArrayList<String>();
            listTemp.add(new Date().toString());
            artifact.putAttributes(String.valueOf(AtsAttributeTypes.EstimatedCompletionDate.getId().toString()) + ";Date", listTemp);
            ArrayList<String> listTemp1 = new ArrayList<String>();
            listTemp1.add(new Date().toString());
            artifact.putAttributes(String.valueOf(AtsAttributeTypes.CreatedDate.getId().toString()) + ";Date", listTemp1);
            childArtifact = TeamWorkflowResource.createNewTask(tx, artifact, orcsApi, estimatedDate, notify, createdUserId, assignees, productBacklog);
            childArtifact.getUuid();
            tx.setSoleAttributeFromString(childArtifact, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, "Working");
            tx.setSoleAttributeFromString(childArtifact, (AttributeTypeToken)AtsAttributeTypes.Information, "");
            tx.setSoleAttributeFromString(childArtifact, (AttributeTypeToken)AtsAttributeTypes.Condition, "");
            tx.commit();
            if (artifactBranchGuid != null) {
                BranchToken branchNew = (BranchToken)orcsApi.getQueryFactory().branchQuery().getResultsAsId().getList().get(Integer.valueOf(artifactBranchGuid));
                TransactionBuilder workspaceTx = txFactory.createTransaction((BranchId)branchNew, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Create Task from Artifact");
                ArtifactReadable wokrspaceArtifactReadableList = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)branchNew).andGuid(artifactGuid).getResults().getExactlyOne();
                ResultSet attributes2 = wokrspaceArtifactReadableList.getAttributes((AttributeTypeToken)AtsAttributeTypes.GUID);
                String taskGuid = ";";
                if (attributes2.size() > 0 && !attributes2.isEmpty()) {
                    taskGuid = String.valueOf(((AttributeReadable)attributes2.getExactlyOne()).getValue().toString()) + taskGuid;
                    taskGuid = String.valueOf(taskGuid) + childArtifact.getId();
                    workspaceTx.setSoleAttributeFromString((ArtifactId)wokrspaceArtifactReadableList, (AttributeTypeToken)AtsAttributeTypes.GUID, taskGuid);
                } else {
                    workspaceTx.setSoleAttributeFromString((ArtifactId)wokrspaceArtifactReadableList, (AttributeTypeToken)AtsAttributeTypes.GUID, childArtifact.getIdString());
                }
                workspaceTx.commit();
            }
            if (linkTaskGuid != null) {
                ResultSet taskOneList = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andGuid(linkTaskGuid).getResults();
                ArtifactReadable taskOne = (ArtifactReadable)taskOneList.getExactlyOne();
                ResultSet taskTwoList = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andUuid(childArtifact.getId().longValue()).getResults();
                ArtifactReadable taskTwo = (ArtifactReadable)taskTwoList.getExactlyOne();
                ArtifactReadable currentUser = CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser());
                UserId userId = UserId.valueOf((Long)currentUser.getId());
                TransactionBuilder linkTaskTx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, userId, "Link Tasks From Task Page");
                linkTaskTx.relate((ArtifactId)taskOne, (RelationTypeToken)AtsRelationTypes.TaskLink_From, (ArtifactId)taskTwo);
                linkTaskTx.commit();
            }
            new ArrayList();
            ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{childArtifact}).getResults();
            ArtifactReadable readableArtifact = (ArtifactReadable)result.getExactlyOne();
            CustomizedTeamWorkFlowArtifact ar = new CustomizedTeamWorkFlowArtifact();
            CustomizedTeamWorkFlowArtifactLoader.copyArtifactReadbleToTransferableArtifactWithoutRelation(readableArtifact, ar);
            String projectGuid = ((ArtifactReadable)readableArtifact.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne()).getGuid();
            System.out.println(projectGuid);
            String changes = String.format("New Task \"%s\" is created by %s on %s", readableArtifact.getName(), ICTeamMailNotifier.getUserNameByUserId(createdUserId), DateUtil.getMMDDYY((Date)new Date()));
            String guid = readableArtifact.getGuid();
            String rapLink = String.valueOf(url) + "/icteam-web/#/dashboard/" + projectGuid + "/" + guid;
            System.out.println(rapLink);
            TeamWorkflowResource.sendMail(orcsApi, createdUserId, assignees, readableArtifact, estimatedDate, ICTeamNotifyType.Created, changes, rapLink);
            json1 = gson.toJson((Object)ar);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json1;
    }

    public List<ITransferableArtifact> getAssigneesForCombo(String projectGuid, String guid) {
        try {
            ResultSet teams1;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            ArtifactReadable teamWFArtifact = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(guid).longValue()).getResults().getExactlyOne();
            ArtifactReadable projectArtifact = (ArtifactReadable)orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andUuid(Long.valueOf(projectGuid).longValue()).getResults().getExactlyOne();
            AttributeReadable currentStateR = (AttributeReadable)teamWFArtifact.getAttributes((AttributeTypeToken)AtsAttributeTypes.CurrentState).getAtMostOneOrNull();
            String currentStateStr = (String)currentStateR.getValue();
            String[] split = currentStateStr.split(";");
            String currentState = split[0];
            List<Object> assignees = new ArrayList<TransferableArtifact>();
            if (!currentState.equals("Completed") && !currentState.equals("Cancelled")) {
                assignees = CommonUtil.getBasicAssigneesInfo(currentStateStr);
            }
            if (currentState.equals("Completed")) {
                assignees.add(CommonUtil.getBasicCompletedByUser(teamWFArtifact));
            }
            if (currentState.equals("Cancelled")) {
                assignees.add(CommonUtil.getBasicCancelledBy(teamWFArtifact));
            }
            ArrayList<ArtifactReadable> userArtifactList = new ArrayList<ArtifactReadable>();
            ResultSet teams = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andRelatedTo(AtsRelationTypes.ProjectToTeamDefinition_Project, (ArtifactId)projectArtifact).getResults();
            if (teams != null && teams.size() > 0) {
                for (ArtifactReadable team : teams) {
                    ResultSet resultSet = team.getRelated(AtsRelationTypes.TeamLead_Lead);
                    for (ArtifactReadable userArtifact : resultSet) {
                        userArtifactList.add(userArtifact);
                    }
                    ResultSet related = team.getRelated(AtsRelationTypes.TeamMember_Member);
                    for (ArtifactReadable userArtifact : related) {
                        userArtifactList.add(userArtifact);
                    }
                }
            }
            if ((teams1 = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition}).andRelatedTo(AtsRelationTypes.ProjectToTeamDefinition_Project, (ArtifactId)projectArtifact).getResults()) != null && teams1.size() > 0) {
                for (ArtifactReadable team : teams1) {
                    Iterator<Object> artifacts = team.getRelated(AtsRelationTypes.TeamLead_Lead);
                    Iterator iterator = artifacts.iterator();
                    while (iterator.hasNext()) {
                        ArtifactReadable userArtifact;
                        userArtifact = (ArtifactReadable)iterator.next();
                        userArtifactList.add(userArtifact);
                    }
                    ResultSet related = team.getRelated(AtsRelationTypes.TeamMember_Member);
                    for (ArtifactReadable userArtifact : related) {
                        userArtifactList.add(userArtifact);
                    }
                }
            }
            ArrayList<ITransferableArtifact> assigneeList = new ArrayList<ITransferableArtifact>();
            for (ArtifactReadable artifactReadable : userArtifactList) {
                TransferableArtifact userTemp = new TransferableArtifact();
                TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(artifactReadable, (ITransferableArtifact)userTemp);
                userTemp.putAttributes(CoreAttributeTypes.UserId.toString(), Arrays.asList(((AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)CoreAttributeTypes.UserId).getExactlyOne()).toString()));
                assigneeList.add((ITransferableArtifact)userTemp);
            }
            for (ITransferableArtifact iTransferableArtifact : assignees) {
                assigneeList.add(iTransferableArtifact);
            }
            Object[] objectArray = assigneeList.toArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray2[n2];
                if (assigneeList.indexOf(s) != assigneeList.lastIndexOf(s)) {
                    assigneeList.remove(assigneeList.lastIndexOf(s));
                }
                ++n2;
            }
            return assigneeList;
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="linkTasks")
    public String linkTasks(String json) {
        String json1 = null;
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String taskGuid = artifact.getUuid();
            ArrayList<TransferableArtifact> artifacts = new ArrayList<TransferableArtifact>();
            List idList = artifact.getAttributes("TaskId");
            List nameList = artifact.getAttributes("TaskName");
            ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andUuid(Long.valueOf(taskGuid).longValue()).getResults();
            ArtifactReadable taskOne = (ArtifactReadable)result.getExactlyOne();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Link Tasks");
            QueryBuilder query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow});
            ResultSet results = query.getResults();
            for (ArtifactReadable artifactReadable : results) {
                if (artifactReadable.getGuid() == taskGuid) continue;
                TransferableArtifact trans = new TransferableArtifact();
                ResultSet related = artifactReadable.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project);
                if (related.size() <= 0 || related.isEmpty()) continue;
                ArtifactReadable project = (ArtifactReadable)related.getExactlyOne();
                ResultSet attributes = artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage);
                if (attributes.size() <= 0 || attributes.isEmpty()) continue;
                String taskId = ((AttributeReadable)attributes.getExactlyOne()).toString();
                taskId = String.valueOf(((AttributeReadable)project.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString()) + "-" + taskId;
                String taskName = artifactReadable.getName();
                if (((String)idList.get(0)).toString().equalsIgnoreCase(taskId) && ((String)nameList.get(0)).toString().equalsIgnoreCase(taskName)) {
                    tx.relate((ArtifactId)taskOne, (RelationTypeToken)AtsRelationTypes.TaskLink_From, (ArtifactId)artifactReadable);
                }
                artifacts.add(trans);
            }
            tx.commit();
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            container.addAll(artifacts);
            json1 = gson.toJson((Object)container);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json1;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="taskInfoForLinking")
    public String getTaskInfoForLinking(String json) {
        String json1 = null;
        try {
            Object[] st;
            String[] splited;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String taskGuid = artifact.getUuid();
            ArrayList<TransferableArtifact> artifacts = new ArrayList<TransferableArtifact>();
            List filterList = artifact.getAttributes("filter");
            List projectFilterList = artifact.getAttributes("project");
            boolean addTask = true;
            String projectFilter = "";
            String typeFilter = "";
            for (String filter : projectFilterList) {
                splited = filter.split("\\s+");
                projectFilter = splited.length > 1 ? (filter = splited[1]) : filter;
            }
            for (String filter : filterList) {
                splited = filter.split("\\s+");
                typeFilter = splited.length > 1 ? (filter = splited[1]) : filter;
            }
            ResultSet projectReadable = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.AgileProject}).andNameEquals(projectFilter).getResults();
            ResultSet taskList = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andRelatedTo(AtsRelationTypes.ProjectToTeamWorkFlow_Project, (ArtifactId)projectReadable.getExactlyOne()).getResults();
            for (ArtifactReadable artifactReadable : taskList) {
                String taskName;
                String taskId;
                if (artifactReadable.getGuid().equals(taskGuid)) continue;
                addTask = true;
                if (!typeFilter.equalsIgnoreCase(((AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.ChangeType).getExactlyOne()).toString())) continue;
                TransferableArtifact trans = new TransferableArtifact();
                ResultSet taskLink = artifactReadable.getRelated(AtsRelationTypes.TaskLink_To);
                ResultSet linktask = artifactReadable.getRelated(AtsRelationTypes.TaskLink_From);
                if (!taskLink.isEmpty() && taskLink.size() > 0) {
                    for (ArtifactReadable artifactReadable2 : taskLink) {
                        if (!artifactReadable2.getGuid().equals(taskGuid)) continue;
                        addTask = false;
                    }
                }
                if (!linktask.isEmpty() && linktask.size() > 0) {
                    for (ArtifactReadable artifactReadable2 : linktask) {
                        if (!artifactReadable2.getGuid().equals(taskGuid)) continue;
                        addTask = false;
                    }
                } else {
                    taskId = ((AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString();
                    taskId = String.valueOf(((AttributeReadable)((ArtifactReadable)projectReadable.getExactlyOne()).getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString()) + "-" + taskId;
                    taskName = artifactReadable.getName();
                    trans.putAttributes("TaskId", Arrays.asList(taskId));
                    trans.putAttributes("TaskName", Arrays.asList(taskName));
                    artifacts.add(trans);
                }
                if (!addTask) continue;
                taskId = ((AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString();
                taskId = String.valueOf(((AttributeReadable)((ArtifactReadable)projectReadable.getExactlyOne()).getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString()) + "-" + taskId;
                taskName = artifactReadable.getName();
                trans.putAttributes("TaskId", Arrays.asList(taskId));
                trans.putAttributes("TaskName", Arrays.asList(taskName));
                artifacts.add(trans);
            }
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            Object[] objectArray = st = artifacts.toArray();
            int n = st.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (artifacts.indexOf(s) != artifacts.lastIndexOf(s)) {
                    artifacts.remove(artifacts.lastIndexOf(s));
                }
                ++n2;
            }
            container.addAll(artifacts);
            json1 = gson.toJson((Object)container);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json1;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getAllProjectsForTaskLinking")
    public String getAllProjectsForTaskLinking(String json) {
        String json1 = null;
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            artifact.getUuid();
            HashSet<TransferableArtifact> userProjectList = new HashSet<TransferableArtifact>();
            ResultSet projects = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.AgileProject}).getResults();
            for (ArtifactReadable project : projects) {
                TransferableArtifact ar = new TransferableArtifact();
                TranferableArtifactLoader.copyBasicInfoToTransferableArtifact(project, (ITransferableArtifact)ar);
                userProjectList.add(ar);
            }
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            ArrayList<TransferableArtifact> selectedProjects = new ArrayList<TransferableArtifact>();
            selectedProjects.addAll(userProjectList);
            container.setArtifactList(selectedProjects);
            json1 = gson.toJson((Object)container);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json1;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getselectedProject")
    public String getselectedProject(String json) {
        String json1 = null;
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String taskGuid = artifact.getUuid();
            ResultSet task = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andUuid(Long.valueOf(taskGuid).longValue()).getResults();
            String projectName = ((ArtifactReadable)((ArtifactReadable)task.getExactlyOne()).getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne()).getName();
            TransferableArtifact trans = new TransferableArtifact();
            trans.putAttributes("Project", Arrays.asList(projectName));
            ArrayList<TransferableArtifact> artifacts = new ArrayList<TransferableArtifact>();
            artifacts.add(trans);
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            container.addAll(artifacts);
            json1 = gson.toJson((Object)container);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json1;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="getAllTasksLinked")
    public String getAllTasksLinked(String json) {
        String json1 = null;
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String taskGuid = artifact.getUuid();
            ResultSet task = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andGuid(taskGuid).getResults();
            ArrayList<TeamWorkFlowArtifact> listTras = new ArrayList<TeamWorkFlowArtifact>();
            for (ArtifactReadable artifactReadable : task) {
                ResultSet related = artifactReadable.getRelated(AtsRelationTypes.TaskLink_From);
                for (ArtifactReadable artifactReadable2 : related) {
                    TeamWorkFlowArtifact ar = new TeamWorkFlowArtifact();
                    TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(artifactReadable2, (ITransferableArtifact)ar);
                    ArtifactReadable project = (ArtifactReadable)artifactReadable2.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne();
                    String shortName = ((AttributeReadable)project.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString();
                    String workpackage = ((AttributeReadable)artifactReadable2.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString();
                    String taskId = String.valueOf(shortName) + "-" + workpackage;
                    ar.putAttributes("TaskId", Arrays.asList(taskId));
                    listTras.add(ar);
                }
                ResultSet related2 = artifactReadable.getRelated(AtsRelationTypes.TaskLink_To);
                for (ArtifactReadable artifactReadable2 : related2) {
                    TeamWorkFlowArtifact ar = new TeamWorkFlowArtifact();
                    TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(artifactReadable2, (ITransferableArtifact)ar);
                    ArtifactReadable project = (ArtifactReadable)artifactReadable2.getRelated(AtsRelationTypes.ProjectToTeamWorkFlow_Project).getExactlyOne();
                    String shortName = ((AttributeReadable)project.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString();
                    String workpackage = ((AttributeReadable)artifactReadable2.getAttributes((AttributeTypeToken)AtsAttributeTypes.WorkPackage).getExactlyOne()).toString();
                    String taskId = String.valueOf(shortName) + "-" + workpackage;
                    ar.putAttributes("TaskId", Arrays.asList(taskId));
                    listTras.add(ar);
                }
            }
            TransferableArtifactsContainer container = new TransferableArtifactsContainer();
            Object[] st = listTras.toArray();
            Object[] objectArray = st;
            int n = st.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                if (listTras.indexOf(s) != listTras.lastIndexOf(s)) {
                    listTras.remove(listTras.lastIndexOf(s));
                }
                ++n2;
            }
            container.setListTeamWorkFlow(listTras);
            json1 = gson.toJson((Object)container);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json1;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="deleteLink")
    public String deleteLink(String json) {
        String json1 = null;
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            String taskGuid = artifact.getParentGuid();
            String secondTaskGuid = artifact.getUuid();
            ResultSet task1 = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andUuid(Long.valueOf(taskGuid).longValue()).getResults();
            ResultSet task2 = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andUuid(Long.valueOf(secondTaskGuid).longValue()).getResults();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, UserId.valueOf((Long)CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser()).getId()), "Unrelate Tasks");
            tx.unrelate((ArtifactId)task1.getExactlyOne(), (RelationTypeToken)AtsRelationTypes.TaskLink_To, (ArtifactId)task2.getExactlyOne());
            tx.unrelate((ArtifactId)task1.getExactlyOne(), (RelationTypeToken)AtsRelationTypes.TaskLink_From, (ArtifactId)task2.getExactlyOne());
            tx.commit();
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return json1;
    }

    private static String setAndVerifyRange(int runningNumber) throws OseeCoreException {
        if (runningNumber > 99999) {
            throw new OseeCoreException("Sequence value exceeded 99999", new Object[0]);
        }
        String taskCountAttr = String.valueOf(runningNumber);
        return taskCountAttr;
    }
}

