/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.structure.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import flexjson.JSONSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.icteam.common.artifact.interfaces.ITransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifact;
import org.eclipse.osee.icteam.common.clientserver.dependent.datamodel.TransferableArtifactsContainer;
import org.eclipse.osee.icteam.server.access.core.OseeCoreData;
import org.eclipse.osee.icteam.web.rest.data.write.TranferableArtifactLoader;
import org.eclipse.osee.icteam.web.rest.layer.util.CommonUtil;
import org.eclipse.osee.icteam.web.rest.layer.util.InterfaceAdapter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

@Path(value="projects")
public class ProjectsResource
extends AbstractConfigResource {
    public ProjectsResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.Project, atsApi, orcsApi);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="releaseWeb")
    public String getAssociatedReleasesForProjectWeb(String projectGuid) {
        String serialize = null;
        try {
            String attribute = projectGuid;
            if (attribute != null) {
                ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
                ResultSet<ArtifactReadable> releases = CommonUtil.getReleasesForProject(attribute);
                for (ArtifactReadable artifactReadable : releases) {
                    TransferableArtifact ar = new TransferableArtifact();
                    TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                    listTras.add(ar);
                    ResultSet attributes = artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.BaselineBranchGuid);
                    if (attributes == null) continue;
                    for (AttributeReadable attributeReadable : attributes) {
                        String branchGuid = attributeReadable.getValue().toString();
                        Branch andGuid = (Branch)OseeCoreData.getOrcsApi().getQueryFactory().branchQuery().getResultsAsId().getList().get(Integer.valueOf(branchGuid));
                        ar.putAttributes("BaseLineBranchName", Arrays.asList(andGuid.getName()));
                    }
                }
                TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                container.addAll(listTras);
                JSONSerializer serializer = new JSONSerializer();
                serialize = serializer.deepSerialize((Object)container);
            }
            return serialize;
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="componentforproject")
    public String getAssociatedComponentForProject(String attribute) {
        String serialize = null;
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            if (attribute != null) {
                ArtifactReadable project = CommonUtil.getArtifactFromIdExcludingDeleted(attribute, CommonUtil.getCommonBranch(orcsApi), orcsApi);
                ResultSet teamArtifacts = project.getRelated(AtsRelationTypes.ProjectToTeamDefinition_TeamDefinition);
                ArrayList<ArtifactReadable> listTeam = new ArrayList<ArtifactReadable>();
                for (ArtifactReadable teamArtifact : teamArtifacts) {
                    listTeam.add(teamArtifact);
                }
                ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
                if (!listTeam.isEmpty()) {
                    ResultSet components = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andRelatedTo(AtsRelationTypes.TeamActionableItem_TeamDefinition, listTeam).getResults();
                    for (ArtifactReadable artifactReadable : components) {
                        TransferableArtifact ar = new TransferableArtifact();
                        TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                        listTras.add(ar);
                    }
                }
                TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                container.addAll(listTras);
                JSONSerializer serializer = new JSONSerializer();
                serialize = serializer.deepSerialize((Object)container);
            }
            return serialize;
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="createproject")
    public String createProject(String json) {
        String serialize = null;
        try {
            Gson gson = new GsonBuilder().registerTypeAdapter(ITransferableArtifact.class, new InterfaceAdapter()).create();
            TransferableArtifact artifact = (TransferableArtifact)gson.fromJson(json, TransferableArtifact.class);
            ArtifactToken childArtifact = null;
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            TransactionFactory txFactory = orcsApi.getTransactionFactory();
            ArtifactReadable currentUser = CommonUtil.getCurrentUser(orcsApi, artifact.getCurrentLoggedInUser());
            UserId userId = UserId.valueOf((Long)currentUser.getId());
            TransactionBuilder tx = txFactory.createTransaction((BranchId)CoreBranches.COMMON, userId, "Add New Project");
            boolean status = true;
            String projectType = artifact.getArtifactType();
            ResultSet results = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.AgileProject}).andNameEquals(artifact.getName()).getResults();
            ResultSet shortnameResults = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.AgileProject}).getResults();
            List shortName = artifact.getAttributes("ShortName");
            for (ArtifactReadable artifactReadable : shortnameResults) {
                if (artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).isEmpty() || !((AttributeReadable)artifactReadable.getAttributes((AttributeTypeToken)AtsAttributeTypes.Shortname).getExactlyOne()).toString().equals(shortName.get(0))) continue;
                status = false;
                break;
            }
            TransferableArtifactsContainer artifactsContainer = new TransferableArtifactsContainer();
            if (results.isEmpty() && status) {
                childArtifact = AtsArtifactTypes.AgileProject.getName().equals(projectType) ? tx.createArtifact(AtsArtifactTypes.AgileProject, artifact.getName()) : tx.createArtifact(AtsArtifactTypes.Project, artifact.getName());
                Map attributes = artifact.getAttributes();
                Set entrySet = attributes.entrySet();
                for (Map.Entry entry : entrySet) {
                    String type = (String)entry.getKey();
                    List value = (List)entry.getValue();
                    if (!type.equalsIgnoreCase("ShortName")) {
                        for (String string : value) {
                            tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)Long.parseLong(type), (String)"Attribute"), string);
                        }
                        continue;
                    }
                    tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AtsAttributeTypes.Shortname, (String)shortName.get(0));
                }
                String uuid = CoreRelationTypes.Users_User.getGuid().toString();
                String type = CoreRelationTypes.Users_User.getRelationType().toString();
                String side = CoreRelationTypes.Users_User.getSide().toString();
                String key = "RelationTypeSide - uuid=[" + uuid + "] type=[" + type + "] side=[" + side + "]";
                List createdUserList = artifact.getRelatedArtifacts(key);
                for (ITransferableArtifact user : createdUserList) {
                    ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andGuid(user.getUuid()).getResults();
                    tx.relate((ArtifactId)childArtifact, (RelationTypeToken)CoreRelationTypes.Users_User, (ArtifactId)list.getExactlyOne());
                    tx.relate((ArtifactId)childArtifact, AtsRelationTypes.ProjectToUser, (ArtifactId)list.getExactlyOne());
                }
                ResultSet result1 = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.RootArtifact}).getResults();
                tx.addChild((ArtifactId)result1.getExactlyOne(), (ArtifactId)childArtifact);
                tx.setSoleAttributeFromString((ArtifactId)childArtifact, (AttributeTypeToken)AttributeTypeToken.valueOf((Long)AtsAttributeTypes.TaskCountForProject.getId(), (String)"Attribute"), String.valueOf(0));
                tx.commit();
                ResultSet result = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{childArtifact}).getResults();
                ArtifactReadable readableArtifact = (ArtifactReadable)result.getExactlyOne();
                TransferableArtifact ar = new TransferableArtifact();
                ar.putAttributes("Status", Arrays.asList("Success"));
                ar.setName(readableArtifact.getName());
                TranferableArtifactLoader.copyArtifactReadbleToTransferableArtifact(readableArtifact, (ITransferableArtifact)ar);
                ArrayList<TransferableArtifact> list = new ArrayList<TransferableArtifact>();
                list.add(ar);
                artifactsContainer.setArtifactList(list);
            } else {
                TransferableArtifact ar = new TransferableArtifact();
                ar.putAttributes("Status", Arrays.asList("Failure"));
                if (!status) {
                    ar.putAttributes("Message", Arrays.asList("ShortName already exists!!!!"));
                }
                if (!results.isEmpty()) {
                    ar.putAttributes("Message", Arrays.asList("Project Name already exists!!!!"));
                }
                if (!status && !results.isEmpty()) {
                    ar.putAttributes("Message", Arrays.asList("Project Name and Short Name already exists!!!!"));
                }
                ArrayList<TransferableArtifact> list = new ArrayList<TransferableArtifact>();
                list.add(ar);
                artifactsContainer.setArtifactList(list);
            }
            JSONSerializer serializer = new JSONSerializer();
            serialize = serializer.deepSerialize((Object)artifactsContainer);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return serialize;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="userSpecific")
    public String getUseeSpecificProjects(String uuid) {
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            if (uuid != null) {
                ResultSet userList = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andGuid(uuid).getResults();
                ArtifactReadable LoggedInUser = (ArtifactReadable)userList.getExactlyOne();
                ResultSet projects = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Project}).getResults();
                HashSet<TransferableArtifact> userProjectList = new HashSet<TransferableArtifact>();
                for (ArtifactReadable project : projects) {
                    if (project.getName().endsWith("#__$DORMANT$__#")) continue;
                    ResultSet createdUsers = project.getRelated(CoreRelationTypes.Users_User);
                    boolean addProject = false;
                    for (ArtifactReadable createdUser : createdUsers) {
                        if (!createdUser.getUuid().equals(LoggedInUser.getUuid())) continue;
                        addProject = true;
                    }
                    ResultSet related = project.getRelated(AtsRelationTypes.ProjectToUser_User);
                    for (ArtifactReadable projectUser : related) {
                        if (!projectUser.getUuid().equals(LoggedInUser.getUuid())) continue;
                        addProject = true;
                    }
                    if (!addProject) continue;
                    TransferableArtifact ar = new TransferableArtifact();
                    TranferableArtifactLoader.copyAllInfoToTransferableArtifact(project, (ITransferableArtifact)ar);
                    userProjectList.add(ar);
                }
                TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                ArrayList<TransferableArtifact> selectedProjects = new ArrayList<TransferableArtifact>();
                selectedProjects.addAll(userProjectList);
                container.setArtifactList(selectedProjects);
                JSONSerializer serializer = new JSONSerializer();
                String serialize = serializer.deepSerialize((Object)container);
                return serialize;
            }
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="uuidWeb")
    public String getProjectForUuidWeb(String projectUuid) {
        try {
            OrcsApi orcsApi = OseeCoreData.getOrcsApi();
            String attribute = projectUuid;
            if (attribute != null) {
                ResultSet list = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.Project}).andUuid(Long.valueOf(attribute).longValue()).getResults();
                ArrayList<TransferableArtifact> listTras = new ArrayList<TransferableArtifact>();
                for (ArtifactReadable artifactReadable : list) {
                    if (!artifactReadable.getUuid().toString().equals(attribute)) continue;
                    TransferableArtifact ar = new TransferableArtifact();
                    TranferableArtifactLoader.copyProjectArtifactReadbleToTransferableArtifact(artifactReadable, (ITransferableArtifact)ar);
                    listTras.add(ar);
                    TransferableArtifactsContainer container = new TransferableArtifactsContainer();
                    container.addAll(listTras);
                    JSONSerializer serializer = new JSONSerializer();
                    String serialize = serializer.deepSerialize((Object)container);
                    return serialize;
                }
            }
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

