/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.sync.jira;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.jira.JiraEndpoint;
import org.eclipse.osee.framework.core.exception.OseeAuthenticationException;

public class JiraEndpointImpl
implements JiraEndpoint {
    private final AtsApi atsApi;
    private String sessionId;
    private final String jiraUrl;
    static final String SESSION_AUTH = "rest/auth/1/session";
    static final String SEARCH_JIRA = "rest/api/2/search";

    public JiraEndpointImpl(AtsApi atsApi, String jiraUrl) {
        this.atsApi = atsApi;
        this.jiraUrl = this.linkParser(jiraUrl);
    }

    public String authenticate(String jsonPayload) {
        String websiteURL = String.valueOf(this.jiraUrl) + SESSION_AUTH;
        CookieManager cookieManager = new CookieManager();
        CookieHandler.setDefault(cookieManager);
        byte[] out = jsonPayload.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection conn = null;
        try {
            try {
                URL url = new URL(websiteURL);
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setFixedLengthStreamingMode(out.length);
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                conn.connect();
                Throwable throwable = null;
                Object var8_10 = null;
                try (OutputStream os = conn.getOutputStream();){
                    os.write(out, 0, out.length);
                    os.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                conn.getContent();
                CookieStore cookieStore = cookieManager.getCookieStore();
                for (HttpCookie cookie : cookieStore.getCookies()) {
                    if (!cookie.getName().equals("JSESSIONID")) continue;
                    this.sessionId = cookie.getValue();
                }
            }
            catch (Exception ex) {
                throw new OseeAuthenticationException("Failed to authenticate user with JIRA", (Throwable)ex);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return this.sessionId;
    }

    public String searchJira(String jsonPayload) {
        String searchResults = "";
        String websiteURL = String.valueOf(this.jiraUrl) + SEARCH_JIRA;
        CookieManager cookieManager = new CookieManager();
        CookieHandler.setDefault(cookieManager);
        byte[] out = jsonPayload.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection conn = null;
        try {
            try {
                URL url = new URL(websiteURL);
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setFixedLengthStreamingMode(out.length);
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                conn.setRequestProperty("Cookie", "JSESSIONID=" + this.sessionId);
                conn.connect();
                Throwable throwable = null;
                Object var9_11 = null;
                try (OutputStream os = conn.getOutputStream();){
                    os.write(out, 0, out.length);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (conn.getResponseCode() == 200) {
                    String readLine = null;
                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    while ((readLine = in.readLine()) != null) {
                        searchResults = String.valueOf(searchResults) + readLine;
                    }
                    in.close();
                }
                conn.getContent();
            }
            catch (Exception ex) {
                throw new OseeAuthenticationException("Failed to authenticate user with JIRA", (Throwable)ex);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return searchResults;
    }

    private String linkParser(String link) {
        String newLink = link;
        if (!link.startsWith("https://")) {
            newLink = "https://" + link;
        }
        if (!link.endsWith("/")) {
            newLink = String.valueOf(newLink) + "/";
        }
        return newLink;
    }
}

