/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.UniversalGroup;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeArtifactDialog;

public class GroupWorldSearchItem
extends WorldUISearchItem {
    private Collection<Artifact> groups = new ArrayList<Artifact>();
    private Collection<Artifact> selectedGroups;
    private String groupName;
    private final BranchId branch;

    public GroupWorldSearchItem(String displayName, String groupName, BranchId branch) {
        super(displayName, AtsImage.GROUP);
        this.groupName = groupName;
        this.branch = branch;
    }

    public GroupWorldSearchItem(Artifact group) {
        super("Group Search", AtsImage.GROUP);
        this.groups.add(group);
        this.branch = group.getBranch();
    }

    public GroupWorldSearchItem(BranchId branch) {
        this("Group Search", null, branch);
    }

    public GroupWorldSearchItem(GroupWorldSearchItem groupWorldSearchItem) {
        super(groupWorldSearchItem, AtsImage.GROUP);
        this.groups = groupWorldSearchItem.groups;
        this.groupName = groupWorldSearchItem.groupName;
        this.selectedGroups = groupWorldSearchItem.selectedGroups;
        this.branch = groupWorldSearchItem.branch;
    }

    public String getGroupSearchName() {
        if (this.groups != null && this.groups.size() == 1) {
            return this.groups.iterator().next().getName();
        }
        if (this.selectedGroups != null && this.selectedGroups.size() == 1) {
            return this.selectedGroups.iterator().next().getName();
        }
        if (this.groupName != null) {
            return this.groupName;
        }
        return "";
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        return String.format("Group Search - %s", this.getGroupSearchName());
    }

    public void getProduct() {
        if (this.groupName == null) {
            return;
        }
        if (this.groups.isEmpty() && this.branch != null) {
            this.groups.add((Artifact)UniversalGroup.getGroups((String)this.groupName, (BranchId)this.branch).iterator().next());
        }
        if (this.groups.isEmpty()) {
            throw new OseeArgumentException("Can't Find Universal Group for [%s]", new Object[]{this.getName()});
        }
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        this.getProduct();
        if (this.getSearchGroups() == null) {
            return EMPTY_SET;
        }
        HashSet<Artifact> arts = new HashSet<Artifact>(100);
        for (Artifact group : this.getSearchGroups()) {
            arts.addAll(group.getRelatedArtifacts(CoreRelationTypes.UniversalGrouping_Members));
        }
        if (this.cancelled) {
            return EMPTY_SET;
        }
        return arts;
    }

    private Collection<Artifact> getSearchGroups() {
        if (this.groups != null) {
            return this.groups;
        }
        if (this.selectedGroups != null) {
            return this.selectedGroups;
        }
        return null;
    }

    @Override
    public void performUI(WorldSearchItem.SearchType searchType) {
        super.performUI(searchType);
        if (this.groupName != null) {
            return;
        }
        if (this.groups != null) {
            return;
        }
        if (searchType == WorldSearchItem.SearchType.ReSearch && this.selectedGroups != null) {
            return;
        }
        Collection allGroups = UniversalGroup.getGroupsNotRoot((BranchId)AtsApiService.get().getAtsBranch());
        FilteredCheckboxTreeArtifactDialog gld = new FilteredCheckboxTreeArtifactDialog("Select Groups", "Select Groups", allGroups);
        int result = gld.open();
        if (result == 0) {
            this.selectedGroups = gld.getChecked();
            return;
        }
        this.selectedGroups = null;
        this.cancelled = true;
    }

    public void setSelectedGroup(Artifact selectedGroup) {
        this.selectedGroups = new ArrayList<Artifact>();
        this.selectedGroups.add(selectedGroup);
    }

    @Override
    public WorldUISearchItem copy() {
        return new GroupWorldSearchItem(this);
    }
}

