/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.world.IWorldEditorParameterProvider;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.ats.ide.world.WorldEditorProvider;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.ResultRows;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IDynamicWidgetLayoutListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;

public class WorldEditorParameterSearchItemProvider
extends WorldEditorProvider
implements IWorldEditorParameterProvider {
    private final WorldEditorParameterSearchItem worldParameterSearchItem;
    public static final String ENTER_OPTIONS_AND_SELECT_SEARCH = "Enter options and select \"Search\"";
    private boolean firstTime = true;
    private final boolean loading = false;

    public WorldEditorParameterSearchItemProvider(WorldEditorParameterSearchItem worldParameterSearchItem) {
        this(worldParameterSearchItem, null, XNavigateComposite.TableLoadOption.None);
    }

    public WorldEditorParameterSearchItemProvider(WorldEditorParameterSearchItem worldParameterSearchItem, CustomizeData customizeData, XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        super(customizeData, tableLoadOptions);
        this.worldParameterSearchItem = worldParameterSearchItem;
    }

    @Override
    public IWorldEditorProvider copyProvider() {
        return new WorldEditorParameterSearchItemProvider((WorldEditorParameterSearchItem)this.worldParameterSearchItem.copy(), this.customizeData, this.tableLoadOptions);
    }

    public WorldSearchItem getWorldSearchItem() {
        return this.worldParameterSearchItem;
    }

    @Override
    public String getName() {
        return this.worldParameterSearchItem.getName();
    }

    @Override
    public void run(WorldEditor worldEditor, WorldSearchItem.SearchType searchType, boolean forcePend) {
        this.run(worldEditor, searchType, forcePend, false);
    }

    @Override
    public void run(WorldEditor worldEditor, WorldSearchItem.SearchType searchType, boolean forcePend, boolean search2) {
        WorldSearchItem searchItem = this.getWorldSearchItem();
        if (searchItem instanceof AtsSearchWorkflowSearchItem) {
            AtsSearchWorkflowSearchItem workflowSearchItem = (AtsSearchWorkflowSearchItem)searchItem;
            if (search2) {
                Result result = this.worldParameterSearchItem.isParameterSelectionValid();
                if (result.isFalse()) {
                    AWorkbench.popup((Result)result);
                    return;
                }
                CustomizeData custData = worldEditor.getWorldComposite().getCustomizeDataCopy();
                final AtsSearchData data = AtsApiService.get().getQueryService().createSearchData(workflowSearchItem.getNamespace(), workflowSearchItem.getSearchName());
                workflowSearchItem.loadSearchData(data);
                data.setCustomizeData(custData);
                Thread srch = new Thread("ATS Search"){

                    @Override
                    public void run() {
                        ResultRows resultRows = AtsApiService.get().getServerEndpoints().getWorldEndpoint().search(data);
                        ResultsEditor.open((String)"Search Results", (ResultRows)resultRows, (boolean)false, (CustomizeData)data.getCustomizeData());
                        super.run();
                    }
                };
                srch.start();
                return;
            }
            AtsSearchData savedData = workflowSearchItem.getSavedData();
            if (savedData != null) {
                worldEditor.setTableTitle(ENTER_OPTIONS_AND_SELECT_SEARCH, false);
                this.firstTime = false;
            }
        }
        if (this.firstTime) {
            this.firstTime = false;
            worldEditor.getWorldXWidgetActionPage().getWorldComposite().getWorldXViewer().setLoading(false);
            worldEditor.setTableTitle(ENTER_OPTIONS_AND_SELECT_SEARCH, false);
            return;
        }
        if (this.worldParameterSearchItem.isCancelled()) {
            worldEditor.getWorldXWidgetActionPage().getWorldComposite().getWorldXViewer().setLoading(false);
            return;
        }
        Result result = this.worldParameterSearchItem.isParameterSelectionValid();
        if (result.isFalse()) {
            AWorkbench.popup((Result)result);
            return;
        }
        this.worldParameterSearchItem.setupSearch();
        boolean pend = Arrays.asList(this.tableLoadOptions).contains(XNavigateComposite.TableLoadOption.ForcePend) || forcePend;
        super.run(worldEditor, searchType, pend);
    }

    @Override
    public String getSelectedName(WorldSearchItem.SearchType searchType) {
        return Strings.truncate((String)this.worldParameterSearchItem.getSelectedName(searchType), (int)80, (boolean)true);
    }

    @Override
    public String getParameterXWidgetXml() {
        return this.worldParameterSearchItem.getParameterXWidgetXml();
    }

    @Override
    public IDynamicWidgetLayoutListener getDynamicWidgetLayoutListener() {
        return this.worldParameterSearchItem;
    }

    @Override
    public void createParametersSectionCompleted(IManagedForm managedForm, Composite mainComp) {
        AtsSearchWorkflowSearchItem workflowSearchItem;
        AtsSearchData savedData;
        this.worldParameterSearchItem.createParametersSectionCompleted(managedForm, mainComp);
        WorldSearchItem searchItem = this.getWorldSearchItem();
        if (searchItem instanceof AtsSearchWorkflowSearchItem && (savedData = (workflowSearchItem = (AtsSearchWorkflowSearchItem)searchItem).getSavedData()) != null) {
            workflowSearchItem.loadWidgets(savedData);
        }
    }

    @Override
    public void createToolbar(IToolBarManager toolBarManager) {
        this.worldParameterSearchItem.createToolbar(toolBarManager);
    }

    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        return Collections.castAll(this.worldParameterSearchItem.performSearch(searchType));
    }
}

