/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workflow.IWorkItemListener;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.MembersLabelProvider;
import org.eclipse.osee.ats.ide.workflow.goal.MembersManager;
import org.eclipse.osee.ats.ide.workflow.goal.MembersViewerSorter;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeArtifactDialog;

public class GoalManager
extends MembersManager<GoalArtifact> {
    public GoalArtifact promptChangeGoalOrder(Artifact artifact) {
        if (!this.isHasCollector(artifact)) {
            AWorkbench.popup((String)String.format("No Goal set for artifact [%s]", artifact));
            return null;
        }
        Collection<Artifact> goals = this.getCollectors(artifact, false);
        GoalArtifact goal = null;
        if (goals.size() == 1) {
            goal = (GoalArtifact)goals.iterator().next();
        } else if (goals.size() > 1) {
            FilteredTreeArtifactDialog dialog = new FilteredTreeArtifactDialog("Select Goal", "Artifact has multiple Goals\n\nSelect Goal to change order", goals, (ITreeContentProvider)new ArrayTreeContentProvider(), (ILabelProvider)new MembersLabelProvider(), (ViewerComparator)new MembersViewerSorter());
            dialog.setMultiSelect(false);
            if (dialog.open() == 0) {
                goal = (GoalArtifact)dialog.getSelectedFirst();
            } else {
                return null;
            }
        }
        return this.promptChangeMemberOrder(goal, artifact);
    }

    public static GoalArtifact createGoal(String title, IAtsChangeSet changes) {
        IAtsWorkDefinition workDef = AtsApiService.get().getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Goal);
        return GoalManager.createGoal(title, AtsArtifactTypes.Goal, workDef, AtsApiService.get().getTeamDefinitionService().getTopTeamDefinition(), changes, null);
    }

    public static GoalArtifact createGoal(String title, ArtifactTypeToken artifactType, IAtsWorkDefinition workDefinition, IAtsTeamDefinition teamDef, IAtsChangeSet changes, IWorkItemListener workItemListener) {
        GoalArtifact goalArt = (GoalArtifact)ArtifactTypeManager.addArtifact((ArtifactTypeToken)artifactType, (BranchToken)AtsApiService.get().getAtsBranch(), (String)title);
        IAtsTeamDefinition useTeamDef = teamDef;
        Conditions.assertNotNull((Object)useTeamDef, (String)"Team Definition can not be null for %s", (Object[])new Object[]{goalArt.toStringWithId()});
        AtsApiService.get().getActionService().setAtsId((IAtsObject)goalArt, useTeamDef, workItemListener, changes);
        IAtsWorkDefinition useWorkDefinition = workDefinition;
        if (useWorkDefinition == null) {
            useWorkDefinition = AtsApiService.get().getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Goal);
        }
        Conditions.assertNotNull((Object)workDefinition, (String)"Work Definition can not be null for %s", (Object[])new Object[]{goalArt.toStringWithId()});
        AtsApiService.get().getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)goalArt, workDefinition, changes);
        AtsApiService.get().getActionService().initializeNewStateMachine((IAtsWorkItem)goalArt, Arrays.asList(AtsApiService.get().getUserService().getCurrentUser()), new Date(), AtsApiService.get().getUserService().getCurrentUser(), workDefinition, changes);
        changes.add((Object)goalArt);
        return goalArt;
    }

    @Override
    public RelationTypeSide getMembersRelationTypeSide() {
        return AtsRelationTypes.Goal_Member;
    }

    @Override
    public String getItemName() {
        return "Goal";
    }

    @Override
    public ArtifactTypeToken getArtifactType() {
        return AtsArtifactTypes.Goal;
    }

    @Override
    public String getMemberOrder(GoalArtifact goalArt, Artifact member) {
        return AtsApiService.get().getGoalMembersCache().getMemberOrder(goalArt, member);
    }
}

