/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr.taskest;

import java.util.Arrays;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstDefinition;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstUtil;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.TaskEstNameProvider;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.TaskEstOperations;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.XTaskEstWidget;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class XTaskEstActionBar
implements TaskEstNameProvider {
    private final XTaskEstWidget xTaskEstWidget;
    private Label extraInfoLabel;
    private ToolItem refreshItem;
    private final AtsApi atsApi;
    private final IAtsTeamWorkflow teamWf;

    public XTaskEstActionBar(XTaskEstWidget xTaskEstWidget) {
        this.xTaskEstWidget = xTaskEstWidget;
        this.atsApi = AtsApiService.get();
        this.teamWf = xTaskEstWidget.getTeamWf();
    }

    public ToolBar createTaskActionBar(Composite parent) {
        Composite bComp = new Composite(parent, 0);
        bComp.setLayout((Layout)new GridLayout(2, false));
        bComp.setLayoutData((Object)new GridData(768));
        Composite leftComp = new Composite(bComp, 0);
        leftComp.setLayout((Layout)new GridLayout());
        leftComp.setLayoutData((Object)new GridData(769));
        this.extraInfoLabel = new Label(leftComp, 0);
        this.extraInfoLabel.setLayoutData((Object)new GridData(768));
        this.extraInfoLabel.setText("");
        this.extraInfoLabel.setForeground(Displays.getSystemColor((int)3));
        this.xTaskEstWidget.setExtraInfoLabel(this.extraInfoLabel);
        Composite rightComp = new Composite(bComp, 0);
        rightComp.setLayout((Layout)new GridLayout());
        rightComp.setLayoutData((Object)new GridData(3));
        ToolBar toolBar = new ToolBar(rightComp, 0x820000);
        GridData gd = new GridData(768);
        toolBar.setLayoutData((Object)gd);
        ToolItem addCannedItem = new ToolItem(toolBar, 8);
        addCannedItem.setText("Create Checked Task(s)");
        addCannedItem.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.GREEN_PLUS));
        addCannedItem.setToolTipText("Create Checked Estimating Task(s)");
        addCannedItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XTaskEstActionBar.this.createCannedTasks();
            }
        });
        ToolItem addManualItem = new ToolItem(toolBar, 8);
        addManualItem.setText("Create Manual Task(s)");
        addManualItem.setImage(ImageManager.getImage((OseeImage)AtsImage.NEW_TASK));
        addManualItem.setToolTipText("Create Manual Estimating Task(s) from entered list");
        addManualItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XTaskEstActionBar.this.createManualTasks();
            }
        });
        new ToolItem(toolBar, 2);
        this.refreshItem = new ToolItem(toolBar, 8);
        this.refreshItem.setImage(ImageManager.getImage((KeyedImage)PluginUiImage.REFRESH));
        this.refreshItem.setToolTipText("Refresh");
        this.refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XTaskEstActionBar.this.xTaskEstWidget.loadTable();
            }
        });
        new ToolItem(toolBar, 2);
        return toolBar;
    }

    protected void createManualTasks() {
        EntryDialog dialog = new EntryDialog("Create Manual Estimating Task(s)", "Enter task names one per line.");
        dialog.setFillVertically(true);
        dialog.setAddOpenInEditorOption(false);
        if (dialog.open() != 0) {
            return;
        }
        NewTaskSet newTaskSet = NewTaskSet.create((String)"Create Task(s)", (String)this.atsApi.getUserService().getCurrentUserId());
        NewTaskData newTaskData = NewTaskData.create((NewTaskSet)newTaskSet, (IAtsTeamWorkflow)this.teamWf);
        String[] stringArray = dialog.getEntry().split("\r\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (Strings.isValid((String)name)) {
                newTaskData.setTaskWorkDef(this.xTaskEstWidget.getTaskWorkDefTok());
                JaxAtsTask task = new JaxAtsTask();
                task.setName(name);
                task.setCreatedByUserId(this.atsApi.getUserService().getCurrentUserId());
                task.setCreatedDate(new Date());
                task.addAttributes((AttributeTypeToken)CoreAttributeTypes.StaticId, Arrays.asList(TaskEstUtil.TASK_EST_MANUAL, TaskEstUtil.TASK_EST_STATIC_ID));
                task.addRelation(AtsRelationTypes.Derive_From, new long[]{this.teamWf.getId()});
                newTaskData.add(task);
            }
            ++n2;
        }
        if (newTaskData.getTasks().isEmpty()) {
            AWorkbench.popup((String)"No Tasks Entered");
        } else {
            newTaskSet = this.atsApi.getTaskService().createTasks(newTaskSet);
            if (newTaskSet.isErrors() || newTaskSet.getTaskData().isEmpty()) {
                XResultDataUI.report((XResultData)newTaskSet.getResults(), (String)XTaskEstWidget.NAME);
            } else {
                AWorkbench.popup((String)"New Tasks Created");
            }
        }
    }

    protected void createCannedTasks() {
        if (this.xTaskEstWidget.getTaskEstDefsFromTableChecked().isEmpty()) {
            AWorkbench.popup((String)"No Tasks Selected");
            return;
        }
        TaskEstOperations ops = new TaskEstOperations(this.atsApi, this.xTaskEstWidget.getTaskWorkDefTok(), this);
        NewTaskSet newTaskSet = ops.createCannedTasks(this.teamWf, this.xTaskEstWidget.getTaskEstDefsFromTableChecked());
        if (newTaskSet.isErrors() || newTaskSet.getTaskData().isEmpty()) {
            XResultDataUI.report((XResultData)newTaskSet.getResults(), (String)XTaskEstWidget.NAME);
        } else {
            AWorkbench.popup((String)"New Tasks Created");
        }
    }

    @Override
    public String getTaskName(TaskEstDefinition ted) {
        return String.format(this.xTaskEstWidget.getTaskNameFormat(), ted.getName());
    }
}

