/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr.sibling.base;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.operation.CreateSiblingWorkflowBlam;
import org.eclipse.osee.ats.ide.workflow.cr.sibling.base.XSiblingWorldWidget;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.BlamEditor;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class XSiblingActionBar {
    protected Label extraInfoLabel;
    protected final XSiblingWorldWidget siblingWorldWidget;
    protected final IAtsTeamWorkflow teamWf;

    public XSiblingActionBar(XSiblingWorldWidget siblingWorldWidget) {
        this.siblingWorldWidget = siblingWorldWidget;
        this.teamWf = siblingWorldWidget.getTeamWf();
    }

    public ToolBar createTaskActionBar(Composite parent) {
        Composite bComp = new Composite(parent, 0);
        bComp.setLayout((Layout)new GridLayout(2, false));
        bComp.setLayoutData((Object)new GridData(768));
        this.createExtraLabel(bComp);
        Composite rightComp = new Composite(bComp, 0);
        rightComp.setLayout((Layout)new GridLayout());
        rightComp.setLayoutData((Object)new GridData(3));
        ToolBar toolBar = new ToolBar(rightComp, 0x820000);
        GridData gd = new GridData(768);
        toolBar.setLayoutData((Object)gd);
        this.createPreToolbarItems(toolBar);
        ToolItem createSibling = new ToolItem(toolBar, 8);
        createSibling.setImage(ImageManager.getImage((OseeImage)AtsImage.WORKFLOW));
        createSibling.setText("Create Sibling Workflow(s)");
        createSibling.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XSiblingActionBar.openCreateSiblingWorkflowBlam(XSiblingActionBar.this.teamWf);
            }
        });
        new ToolItem(toolBar, 2);
        ToolItem openInWorld = new ToolItem(toolBar, 8);
        openInWorld.setImage(ImageManager.getImage((OseeImage)AtsImage.NEW_ACTION));
        openInWorld.setToolTipText("Open in ATS World Editor");
        openInWorld.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection<IAtsWorkItem> items = XSiblingActionBar.this.siblingWorldWidget.getItems();
                WorldEditorSimpleProvider provider = new WorldEditorSimpleProvider("Sibling Workflows", Collections.castAll(items));
                WorldEditor.open(provider);
            }
        });
        ToolItem openSelectedInWorld = new ToolItem(toolBar, 8);
        openSelectedInWorld.setImage(ImageManager.getImage((OseeImage)AtsImage.GLOBE_SELECT));
        openSelectedInWorld.setToolTipText("Open Selected in ATS World Editor");
        openSelectedInWorld.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List items = Collections.castAll(XSiblingActionBar.this.siblingWorldWidget.getxWorldViewer().getSelectedTeamWorkflowArtifacts());
                WorldEditorSimpleProvider provider = new WorldEditorSimpleProvider("Selected Sibling Workflows", Collections.castAll((Collection)items));
                WorldEditor.open(provider);
            }
        });
        new ToolItem(toolBar, 2);
        ToolItem refreshItem = new ToolItem(toolBar, 8);
        refreshItem.setImage(ImageManager.getImage((KeyedImage)PluginUiImage.REFRESH));
        refreshItem.setToolTipText("Refresh");
        refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XSiblingActionBar.this.siblingWorldWidget.loadTable();
            }
        });
        new ToolItem(toolBar, 2);
        return toolBar;
    }

    protected void createPreToolbarItems(ToolBar toolBar) {
    }

    private void createExtraLabel(Composite bComp) {
        Composite leftComp = new Composite(bComp, 0);
        leftComp.setLayout((Layout)new GridLayout());
        leftComp.setLayoutData((Object)new GridData(769));
        this.extraInfoLabel = new Label(leftComp, 0);
        this.extraInfoLabel.setLayoutData((Object)new GridData(768));
        this.extraInfoLabel.setText("");
        this.extraInfoLabel.setForeground(Displays.getSystemColor((int)3));
        this.siblingWorldWidget.setExtraInfoLabel(this.extraInfoLabel);
    }

    public static void openCreateSiblingWorkflowBlam(IAtsTeamWorkflow teamWf) {
        CreateSiblingWorkflowBlam blamOperation = new CreateSiblingWorkflowBlam();
        blamOperation.setDefaultTeamWorkflow((TeamWorkFlowArtifact)teamWf);
        BlamEditor.edit((AbstractBlam)blamOperation, (boolean)false);
    }
}

