/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.core.util.HoursSpentUtil;
import org.eclipse.osee.ats.core.util.PercentCompleteTotalUtil;
import org.eclipse.osee.ats.ide.column.RemainingHoursColumn;
import org.eclipse.osee.ats.ide.column.WorkDaysNeededColumn;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.EstimatedHoursUtil;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class WorkflowMetrics {
    double estHours = 0.0;
    double hrsRemainFromEstimates = 0.0;
    double hrsSpent = 0.0;
    double manDaysNeeded = 0.0;
    double cummulativeWorkflowPercentComplete = 0.0;
    double percentCompleteByWorkflowPercents = 0.0;
    double points = 0.0;
    double pointsNumeric = 0.0;
    Date estimatedReleaseDate;
    long daysTillRel = 0L;
    IAtsVersion version = null;
    String str = "";
    Set<TeamWorkFlowArtifact> teamArts = new HashSet<TeamWorkFlowArtifact>();
    Set<Artifact> actionArts = new HashSet<Artifact>();
    Set<TaskArtifact> taskArts = new HashSet<TaskArtifact>();
    Set<AbstractReviewArtifact> reviewArts = new HashSet<AbstractReviewArtifact>();
    Set<GoalArtifact> goalArts = new HashSet<GoalArtifact>();
    Set<AbstractWorkflowArtifact> awas = new HashSet<AbstractWorkflowArtifact>();
    Set<AtsUser> assignees = new HashSet<AtsUser>();
    Set<AtsUser> assigneesAssignedOrCompleted = new HashSet<AtsUser>();
    private final HashCollectionSet<AtsUser, Artifact> userToAssignedSmas = new HashCollectionSet(false, 100, HashSet::new);
    private final HashCollectionSet<AtsUser, Artifact> userToCompletedSmas = new HashCollectionSet(false, 100, HashSet::new);
    private final double manHoursPerDay;

    public WorkflowMetrics(Collection<? extends Artifact> artifacts, IAtsVersion version, double manHoursPerDay, Date estimatedReleaseDate) {
        this.manHoursPerDay = manHoursPerDay;
        this.version = version;
        this.estimatedReleaseDate = estimatedReleaseDate;
        if (artifacts.isEmpty()) {
            return;
        }
        for (Artifact artifact : artifacts) {
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                this.teamArts.add((TeamWorkFlowArtifact)artifact);
            } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
                this.taskArts.add((TaskArtifact)artifact);
            } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractReview})) {
                this.reviewArts.add((AbstractReviewArtifact)artifact);
            } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                this.goalArts.add((GoalArtifact)artifact);
            } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                this.actionArts.add(artifact);
            }
            if (!(artifact instanceof AbstractWorkflowArtifact)) continue;
            this.awas.add((AbstractWorkflowArtifact)artifact);
            HashSet users = new HashSet();
            users.addAll(((AbstractWorkflowArtifact)artifact).getStateMgr().getAssignees());
            this.assignees.addAll(users);
            this.assigneesAssignedOrCompleted.addAll(users);
            for (AtsUser user : users) {
                this.userToAssignedSmas.put((Object)user, (Object)artifact);
            }
            if (!((AbstractWorkflowArtifact)artifact).isCompleted()) continue;
            List<AtsUser> implementers = ((AbstractWorkflowArtifact)artifact).getImplementers();
            this.assigneesAssignedOrCompleted.addAll(implementers);
            for (AtsUser user : implementers) {
                this.userToCompletedSmas.put((Object)user, (Object)artifact);
            }
        }
        this.estHours = 0.0;
        this.hrsRemainFromEstimates = 0.0;
        this.hrsSpent = 0.0;
        this.manDaysNeeded = 0.0;
        this.cummulativeWorkflowPercentComplete = 0.0;
        this.manDaysNeeded = 0.0;
        this.points = 0.0;
        this.pointsNumeric = 0.0;
        for (AbstractWorkflowArtifact abstractWorkflowArtifact : this.awas) {
            this.hrsRemainFromEstimates += RemainingHoursColumn.getRemainingHours((Object)abstractWorkflowArtifact);
            this.estHours += EstimatedHoursUtil.getEstimatedHours((Object)abstractWorkflowArtifact);
            this.hrsSpent += HoursSpentUtil.getHoursSpentTotal((IAtsObject)abstractWorkflowArtifact, (AtsApi)AtsApiService.get());
            this.manDaysNeeded += WorkDaysNeededColumn.getWorldViewManDaysNeeded((Object)abstractWorkflowArtifact);
            this.cummulativeWorkflowPercentComplete += (double)PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)abstractWorkflowArtifact, (AtsApi)AtsApiService.get());
            String ptsStr = (String)abstractWorkflowArtifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Points, null);
            this.points += (double)(Strings.isNumeric((String)ptsStr) ? Integer.valueOf(ptsStr) : 0);
            this.pointsNumeric += ((Double)abstractWorkflowArtifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.PointsNumeric, 0.0)).doubleValue();
        }
        if (this.hrsRemainFromEstimates != 0.0) {
            this.manDaysNeeded = this.hrsRemainFromEstimates / manHoursPerDay;
        }
        this.percentCompleteByWorkflowPercents = 0.0;
        if (this.getNumSMAs() > 0 && this.cummulativeWorkflowPercentComplete > 0.0) {
            this.percentCompleteByWorkflowPercents = this.cummulativeWorkflowPercentComplete / (double)this.getNumSMAs();
        }
        Date date = new Date();
        this.daysTillRel = 0L;
        if (version != null && estimatedReleaseDate == null) {
            estimatedReleaseDate = AtsApiService.get().getVersionService().getEstimatedReleaseDate(version);
        }
        if (estimatedReleaseDate != null && estimatedReleaseDate.after(date)) {
            this.daysTillRel = DateUtil.getWorkingDaysBetween((Date)date, (Date)estimatedReleaseDate);
        }
        Object[] objectArray = new Object[12];
        objectArray[0] = this.getNumTeamWfs();
        objectArray[1] = this.getNumTasks();
        objectArray[2] = this.getNumReviews();
        objectArray[3] = this.estHours;
        objectArray[4] = "%";
        objectArray[5] = this.percentCompleteByWorkflowPercents;
        objectArray[6] = this.hrsRemainFromEstimates;
        objectArray[7] = this.hrsSpent;
        objectArray[8] = this.points;
        objectArray[9] = this.pointsNumeric;
        Object object = objectArray[10] = this.manDaysNeeded > 0.0 ? String.format("ManDaysNeeded: %5.2f ", this.manDaysNeeded) : "";
        objectArray[11] = version != null ? String.format("Version: %s  EstRelDate: %s DaysLeft: %d ", version.getName(), estimatedReleaseDate == null ? "Not Set" : DateUtil.getMMDDYY((Date)estimatedReleaseDate), this.daysTillRel) : "";
        this.str = String.format("TeamWFs: %s Tasks: %s Revs: %s EstHrs: %5.2f  %sCmp: %5.2f  RmnHrs: %5.2f  HrsSpnt: %5.2f  Pts: %s  PtsNum: %s  %s  %s", objectArray);
    }

    public HashCollectionSet<AtsUser, Artifact> getUserToCompletedSmas() {
        return this.userToCompletedSmas;
    }

    public <A extends AbstractWorkflowArtifact> Collection<A> getUserToCompletedSmas(AtsUser user) {
        return this.getUserToCompletedSmas(user, null);
    }

    public <A extends AbstractWorkflowArtifact> Collection<A> getUserToCompletedSmas(AtsUser user, Class<A> clazz) {
        if (!this.userToCompletedSmas.containsKey((Object)user)) {
            return Collections.emptyList();
        }
        ArrayList<AbstractWorkflowArtifact> awas = new ArrayList<AbstractWorkflowArtifact>();
        for (Artifact art : (Set)this.userToCompletedSmas.getValues((Object)user)) {
            if (clazz != null && !art.getClass().isInstance(clazz)) continue;
            awas.add((AbstractWorkflowArtifact)art);
        }
        return awas;
    }

    public <A extends AbstractWorkflowArtifact> Collection<A> getUserToAssignedSmas(AtsUser user, Class<A> clazz) {
        if (!this.userToAssignedSmas.containsKey((Object)user)) {
            return Collections.emptyList();
        }
        ArrayList<AbstractWorkflowArtifact> awas = new ArrayList<AbstractWorkflowArtifact>();
        for (Artifact art : (Set)this.userToAssignedSmas.getValues((Object)user)) {
            if (clazz != null && !art.getClass().equals(clazz)) continue;
            awas.add((AbstractWorkflowArtifact)art);
        }
        return awas;
    }

    public Collection<TeamWorkFlowArtifact> getCompletedTeamWorkflows() {
        HashSet<TeamWorkFlowArtifact> teams = new HashSet<TeamWorkFlowArtifact>();
        for (TeamWorkFlowArtifact team : this.getTeamArts()) {
            if (!team.isCompletedOrCancelled()) continue;
            teams.add(team);
        }
        return teams;
    }

    public Collection<AbstractWorkflowArtifact> getCompletedWorkflows() {
        HashSet<AbstractWorkflowArtifact> completed = new HashSet<AbstractWorkflowArtifact>();
        for (AbstractWorkflowArtifact awa : this.awas) {
            if (!awa.isCompletedOrCancelled()) continue;
            completed.add(awa);
        }
        return completed;
    }

    public double getPercentCompleteByWorkflow() {
        if (this.awas.isEmpty()) {
            return 0.0;
        }
        double completed = this.getCompletedWorkflows().size();
        if (completed == 0.0) {
            return 0.0;
        }
        return completed / (double)this.awas.size() * 100.0;
    }

    public Collection<TaskArtifact> getCompletedTaskWorkflows() {
        HashSet<TaskArtifact> tasks = new HashSet<TaskArtifact>();
        for (TaskArtifact team : this.getTaskArts()) {
            if (!team.isCompletedOrCancelled()) continue;
            tasks.add(team);
        }
        return tasks;
    }

    public String toString() {
        return this.str;
    }

    public static String getEstRemainMetrics(Collection<? extends Artifact> awas, IAtsVersion versionArtifact, double manHoursPerDay, Date estimatedrelDate) {
        return new WorkflowMetrics(awas, (IAtsVersion)versionArtifact, (double)manHoursPerDay, (Date)estimatedrelDate).str;
    }

    public Set<AtsUser> getAssigneesAssignedOrCompleted() {
        return this.assigneesAssignedOrCompleted;
    }

    public String toStringObjectBreakout() {
        return String.format("Actions: %s  - Team Workflows: %s - Task Workflows: %s - Review Workflows: %s  - Goal Workflows: %s ", this.getNumActions(), this.getNumTeamWfs(), this.getNumTasks(), this.getNumReviews(), this.getGoals());
    }

    public Date getEstRelDate() {
        return this.estimatedReleaseDate;
    }

    public double getHoursTillRel() {
        return (double)this.daysTillRel * this.manHoursPerDay;
    }

    public String getHoursTillRelStr() {
        return String.format("%5.2f hours = %d days till release * %5.2f Man Hours Per Day", this.getHoursTillRel(), this.daysTillRel, this.manHoursPerDay);
    }

    public String getDaysTillRelStr() {
        return String.format("%d workdays (M-F) till release", this.daysTillRel);
    }

    public int getNumTeamWfs() {
        return this.teamArts.size();
    }

    public int getNumTasks() {
        return this.taskArts.size();
    }

    public int getNumSMAs() {
        return this.awas.size();
    }

    public int getNumNotEstimated() {
        int count = 0;
        for (AbstractWorkflowArtifact awa : this.awas) {
            if (EstimatedHoursUtil.getEstimatedHours((Object)awa) != 0.0) continue;
            ++count;
        }
        return count;
    }

    public int getNumActions() {
        return this.actionArts.size();
    }

    public int getNumReviews() {
        return this.reviewArts.size();
    }

    public int getGoals() {
        return this.goalArts.size();
    }

    public double getEstHours() {
        return this.estHours;
    }

    public double getHrsRemainFromEstimates() {
        return this.hrsRemainFromEstimates;
    }

    public double getHrsSpent() {
        return this.hrsSpent;
    }

    public double getManDaysNeeded() {
        return this.manDaysNeeded;
    }

    public double getCummulativeWorkflowPercentComplete() {
        return this.cummulativeWorkflowPercentComplete;
    }

    public double getPercentCompleteByWorkflowPercents() {
        return this.percentCompleteByWorkflowPercents;
    }

    public double getHoursPerManDay() {
        return this.manHoursPerDay;
    }

    public Set<TeamWorkFlowArtifact> getTeamArts() {
        return this.teamArts;
    }

    public Set<TaskArtifact> getTaskArts() {
        return this.taskArts;
    }

    public HashCollectionSet<AtsUser, Artifact> getUserToAssignedSmas() {
        return this.userToAssignedSmas;
    }

    public <A extends AbstractWorkflowArtifact> Collection<A> getUserToAssignedSmas(AtsUser user) {
        return this.getUserToAssignedSmas(user, null);
    }
}

