/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.util.widgets.XArtifactReferencedAtsObjectAttributeWidget;
import org.eclipse.osee.ats.ide.util.widgets.XProgramSelectionWidget;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidgetDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XOption;
import org.eclipse.osee.framework.ui.skynet.widgets.XTextFlatDam;
import org.eclipse.osee.framework.ui.skynet.widgets.util.DefaultAttributeXWidgetProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;

public class AtsAttributeXWidgetProvider
extends DefaultAttributeXWidgetProvider {
    private static final Collection<AttributeTypeId> xFlatAttributeTypes = new ArrayList<AttributeTypeId>();
    private static final Map<AttributeTypeId, ArtifactTypeId> artRefAttrTypeToValidArtType = new HashMap<AttributeTypeId, ArtifactTypeId>();
    private static final Collection<AttributeTypeId> artRefAttributeTypes;

    static {
        xFlatAttributeTypes.add((AttributeTypeId)CoreAttributeTypes.WorkTransition);
        xFlatAttributeTypes.add((AttributeTypeId)CoreAttributeTypes.WorkData);
        xFlatAttributeTypes.add((AttributeTypeId)AtsAttributeTypes.State);
        artRefAttrTypeToValidArtType.put((AttributeTypeId)AtsAttributeTypes.ActionableItemReference, (ArtifactTypeId)AtsArtifactTypes.ActionableItem);
        artRefAttrTypeToValidArtType.put((AttributeTypeId)AtsAttributeTypes.TeamDefinitionReference, (ArtifactTypeId)AtsArtifactTypes.TeamDefinition);
        artRefAttrTypeToValidArtType.put((AttributeTypeId)AtsAttributeTypes.WorkflowDefinitionReference, ArtifactTypeId.SENTINEL);
        artRefAttrTypeToValidArtType.put((AttributeTypeId)AtsAttributeTypes.WorkPackageReference, (ArtifactTypeId)AtsArtifactTypes.WorkPackage);
        artRefAttrTypeToValidArtType.put((AttributeTypeId)AtsAttributeTypes.RelatedPeerWorkflowDefinitionReference, (ArtifactTypeId)AtsArtifactTypes.TeamDefinition);
        artRefAttrTypeToValidArtType.put((AttributeTypeId)AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference, (ArtifactTypeId)AtsArtifactTypes.TeamDefinition);
        artRefAttrTypeToValidArtType.put((AttributeTypeId)AtsAttributeTypes.TaskToChangedArtifactReference, (ArtifactTypeId)AtsArtifactTypes.TeamDefinition);
        artRefAttributeTypes = artRefAttrTypeToValidArtType.keySet();
    }

    public List<XWidgetRendererItem> getDynamicXWidgetLayoutData(ArtifactTypeToken artType, AttributeTypeToken attributeType) {
        List<XWidgetRendererItem> layouts = new ArrayList();
        if (attributeType.equals(AtsAttributeTypes.BaselineBranchId)) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = (XWidgetRendererItem)layouts.get(0);
            layoutData.setXWidgetName(XBranchSelectWidgetDam.WIDGET_ID);
        } else if (xFlatAttributeTypes.contains(attributeType)) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = (XWidgetRendererItem)layouts.get(0);
            layoutData.setXWidgetName(XTextFlatDam.WIDGET_ID);
        } else if (attributeType.matches(new Id[]{AtsAttributeTypes.TestRunToSourceLocator})) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = layouts.get(0);
            layoutData.getXOptionHandler().add(XOption.FILL_VERTICALLY);
        } else if (attributeType.equals(AtsAttributeTypes.ProgramId)) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = layouts.get(0);
            layoutData.setXWidgetName(XProgramSelectionWidget.WIDGET_ID);
        } else if (artRefAttributeTypes.contains(attributeType)) {
            layouts = super.getDynamicXWidgetLayoutData(artType, attributeType);
            XWidgetRendererItem layoutData = layouts.get(0);
            ArtifactTypeId newArtType = artRefAttrTypeToValidArtType.get(attributeType);
            if (newArtType.isValid()) {
                layoutData.setArtifactType(newArtType);
            }
            layoutData.setXWidgetName(XArtifactReferencedAtsObjectAttributeWidget.WIDGET_ID);
        }
        return layouts;
    }
}

