/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.attribute.DateAttribute;

public class ArtifactValueProvider
implements IValueProvider {
    private final Artifact artifact;
    private final AttributeTypeToken attributeType;

    public ArtifactValueProvider(Artifact artifact, WidgetDefinition widgetDef) {
        this.artifact = artifact;
        this.attributeType = widgetDef.getAttributeType();
    }

    public ArtifactValueProvider(Artifact artifact, AttributeTypeToken attributeType) {
        this.artifact = artifact;
        this.attributeType = attributeType;
    }

    public boolean isEmpty() {
        AttributeTypeToken attributeType = this.getAtributeType();
        if (attributeType != null) {
            return this.artifact.getAttributeCount((AttributeTypeId)attributeType) == 0;
        }
        return true;
    }

    public Collection<String> getValues() {
        AttributeTypeToken attributeType = this.getAtributeType();
        if (attributeType != null) {
            return this.artifact.getAttributesToStringList((AttributeTypeId)attributeType);
        }
        return Collections.emptyList();
    }

    public AttributeTypeToken getAtributeType() {
        return this.attributeType;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public Collection<Date> getDateValues() {
        AttributeTypeToken attributeType = this.getAtributeType();
        if (attributeType != null) {
            ArrayList<Date> dates = new ArrayList<Date>();
            for (Attribute attr : this.artifact.getAttributes((AttributeTypeId)attributeType)) {
                if (!(attr instanceof DateAttribute)) continue;
                dates.add(((DateAttribute)attr).getValue());
            }
            return dates;
        }
        return Collections.emptyList();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Object getObject() {
        return this.artifact;
    }
}

