/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.Import;

import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.task.JaxAttribute;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelAtsActionArtifactExtractor {
    private final List<ActionData> actionDatas = new ArrayList<ActionData>();
    private final Set<Artifact> actionArts = new HashSet<Artifact>();
    private final Map<String, ActionResult> actionNameToAction = new HashMap<String, ActionResult>(100);
    private final boolean emailPOCs;
    private final boolean dataIsValid = true;
    private final IAtsGoal toGoal;
    private final Map<String, IAgileTeam> teamNameByTeamMap = new HashMap<String, IAgileTeam>();
    private InputStreamReader inputStream;
    private XResultData rd;

    public ExcelAtsActionArtifactExtractor(boolean emailPOCs, IAtsGoal toGoal) {
        this.emailPOCs = emailPOCs;
        this.toGoal = toGoal;
    }

    public XResultData dataIsValid() {
        this.rd = new XResultData();
        int rowNum = 1;
        for (ActionData aData : this.actionDatas) {
            IAgileSprint sprint;
            IAgileTeam aTeam;
            ++rowNum;
            if (aData.title.equals("")) {
                this.rd.error("Row " + rowNum + "; Invalid Title");
            }
            if (Strings.isInValid((String)aData.desc)) {
                this.rd.error("Row " + rowNum + "; Invalid Description");
            }
            HashSet teamDefs = new HashSet();
            if (aData.actionableItems.isEmpty()) {
                this.rd.error("Row " + rowNum + ": Must have at least one ActionableItem defined");
            } else {
                for (String actionableItemName : aData.actionableItems) {
                    try {
                        ArrayList<ActionableItem> aias = new ArrayList<ActionableItem>();
                        for (Artifact aiaArt : ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)AtsArtifactTypes.ActionableItem, (String)actionableItemName, (BranchId)AtsApiService.get().getAtsBranch())) {
                            ActionableItem ai = AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)aiaArt);
                            if (ai == null) continue;
                            aias.add(ai);
                        }
                        if (aias.isEmpty()) {
                            this.rd.error("Row " + rowNum + ": Couldn't find actionable item for \"" + actionableItemName + "\"");
                            continue;
                        }
                        if (aias.size() > 1) {
                            this.rd.error("Row " + rowNum + ": Duplicate actionable items found with name \"" + actionableItemName + "\"");
                            continue;
                        }
                        IAtsActionableItem aia = (IAtsActionableItem)aias.iterator().next();
                        teamDefs.addAll(AtsApiService.get().getActionableItemService().getImpactedTeamDefs(Arrays.asList(aia)));
                        if (teamDefs.isEmpty()) {
                            this.rd.error("Row " + rowNum + ": No related Team Definition for Actionable Item\"" + actionableItemName + "\"");
                            continue;
                        }
                        if (teamDefs.size() <= 1) continue;
                        this.rd.error("Row " + rowNum + ": Duplicate Team Definitions found for Actionable Item\"" + actionableItemName + "\"");
                    }
                    catch (Exception ex) {
                        this.rd.error("Row " + rowNum + " - " + ex.getLocalizedMessage());
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
            if (!aData.version.equals("")) {
                try {
                    for (IAtsTeamDefinition teamDef : teamDefs) {
                        if (AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions(teamDef) == null) {
                            this.rd.errorf("No Team Definitions Holding Versions found for Team Definition [%s]", new Object[]{teamDef});
                        }
                        IAtsTeamDefinition teamDefHolVer = AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions(teamDef);
                        if (AtsApiService.get().getVersionService().getVersion(teamDefHolVer, aData.version) != null) continue;
                        this.rd.errorf("No version [%s] configured for Team Definition [%s]", new Object[]{aData.version, teamDef});
                    }
                }
                catch (Exception ex) {
                    this.rd.error("Row " + rowNum + " - " + ex.getLocalizedMessage());
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
            if (aData.assigneeStrs.size() > 0) {
                for (String assignee : aData.assigneeStrs) {
                    try {
                        assignee = assignee.replaceFirst("^ *", "");
                        assignee = assignee.replaceFirst(" *$", "");
                        AtsUser user = AtsApiService.get().getUserService().getUserByName(assignee);
                        if (user == null) {
                            this.rd.error("Row " + rowNum + ": Couldn't retrieve user \"" + assignee + "\"");
                            continue;
                        }
                        aData.assignees.add(user);
                    }
                    catch (UserNotInDatabase ex) {
                        this.rd.error("Row " + rowNum + ": " + ex.getLocalizedMessage());
                    }
                }
            }
            if (Strings.isValid((String)aData.agileTeamName)) {
                IAgileBacklog backlog;
                aTeam = this.getAgileTeamByName(aData.agileTeamName);
                if (aTeam == null) {
                    this.rd.errorf("Invalid team name [%s]", new Object[]{aData.agileTeamName});
                }
                if ((backlog = this.getAgileBacklog(aData.agileTeamName)) == null) {
                    this.rd.errorf("No backlog for team [%s]", new Object[]{aData.agileTeamName});
                }
            }
            if (Strings.isValid((String)aData.agileSprintName) && (sprint = this.getAgileSprint(aData.agileTeamName, aData.agileSprintName)) == null) {
                this.rd.errorf("Invalid sprint name [%s] for team [%s]", new Object[]{aData.agileSprintName, aData.agileTeamName});
            }
            if (!Strings.isValid((String)aData.agilePoints)) continue;
            aTeam = this.getAgileTeamByName(aData.agileTeamName);
            if (aTeam == null) {
                this.rd.errorf("Invalid team name [%s] for points [%s]", new Object[]{aData.agileTeamName, aData.agilePoints});
                continue;
            }
            AttributeTypeToken pointsAttrType = AtsApiService.get().getAgileService().getAgileTeamPointsAttributeType(aTeam);
            if (pointsAttrType != null) continue;
            this.rd.errorf("Points not configured for team [%s]", new Object[]{aData.agileTeamName});
        }
        return this.rd;
    }

    public void createArtifactsAndNotify(IAtsChangeSet changes) {
        AtsUtilClient.setEmailEnabled(false);
        HashSet<IAtsTeamWorkflow> teamWfs = new HashSet<IAtsTeamWorkflow>();
        Date createdDate = new Date();
        try {
            try {
                AtsUser createdBy = AtsApiService.get().getUserService().getCurrentUser();
                for (ActionData aData : this.actionDatas) {
                    ActionResult actionResult = this.actionNameToAction.get(aData.title);
                    if (actionResult == null) {
                        ChangeType changeType = this.getChangeType(aData);
                        String priorityStr = this.getPriority(aData);
                        ActionResult aResult = AtsApiService.get().getActionService().createAction(null, aData.title, aData.desc, changeType, priorityStr, false, null, (Collection)AtsApiService.get().getActionableItemService().getActionableItems(aData.actionableItems), createdDate, createdBy, null, changes);
                        this.actionNameToAction.put(aData.title, aResult);
                        for (IAtsTeamWorkflow teamWf : aResult.getTeams()) {
                            this.processTeamWorkflow(changes, aData, teamWf);
                            teamWfs.add(teamWf);
                        }
                        this.actionArts.add(AtsApiService.get().getQueryServiceIde().getArtifact(aResult.getActionArt()));
                        continue;
                    }
                    HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
                    for (String actionableItemName : aData.actionableItems) {
                        for (Artifact aiaArt : ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)AtsArtifactTypes.ActionableItem, (String)actionableItemName, (BranchId)AtsApiService.get().getAtsBranch())) {
                            ActionableItem ai = AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)aiaArt);
                            if (ai == null) continue;
                            aias.add((IAtsActionableItem)ai);
                        }
                    }
                    Map<IAtsTeamDefinition, Collection<IAtsActionableItem>> teamDefToAias = this.getTeamDefToAias(aias);
                    for (Map.Entry<IAtsTeamDefinition, Collection<IAtsActionableItem>> entry : teamDefToAias.entrySet()) {
                        IAtsTeamWorkflow teamWf = AtsApiService.get().getActionService().createTeamWorkflow(actionResult.getAction(), entry.getKey(), entry.getValue(), aData.assignees, changes, createdDate, createdBy, null, new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
                        actionResult.getTeams().add(teamWf);
                        this.processTeamWorkflow(changes, aData, teamWf);
                        teamWfs.add(teamWf);
                    }
                }
                AtsUtilClient.setEmailEnabled(true);
                if (this.emailPOCs) {
                    for (IAtsTeamWorkflow teamWf : teamWfs) {
                        try {
                            changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)AtsApiService.get().getUserService().getCurrentUser(), (IAtsWorkItem)teamWf, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Assigned}));
                        }
                        catch (OseeCoreException ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error adding ATS Notification Event", (Throwable)ex);
                        }
                    }
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                AtsUtilClient.setEmailEnabled(true);
            }
        }
        finally {
            AtsUtilClient.setEmailEnabled(true);
        }
    }

    private String getPriority(ActionData aData) {
        String priorityStr = "3";
        if (Strings.isValid((String)aData.priorityStr)) {
            priorityStr = aData.priorityStr;
        }
        return priorityStr;
    }

    private ChangeType getChangeType(ActionData aData) {
        ChangeType changeType = ChangeType.None;
        if (Strings.isValid((String)aData.changeType)) {
            changeType = ChangeType.getChangeType((Object)aData.changeType);
        }
        return changeType;
    }

    private void processTeamWorkflow(IAtsChangeSet changes, ActionData aData, IAtsTeamWorkflow teamWf) {
        ChangeType changeType = this.getChangeType(aData);
        String priorityStr = this.getPriority(aData);
        changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.Description, aData.desc);
        changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.Priority, priorityStr);
        changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.ChangeType, changeType.name());
        this.addToAgile(changes, aData, teamWf);
        for (JaxAttribute attr : aData.attributes) {
            AttributeTypeToken attrType = attr.getAttrType();
            changes.setAttributeValues((IAtsObject)teamWf, attrType, attr.getValues());
        }
        this.addToGoal(Collections.singleton((TeamWorkFlowArtifact)teamWf.getStoreObject()), changes);
        if (!aData.version.equals("")) {
            IAtsTeamDefinition teamDefHoldVer = AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions(teamWf.getTeamDefinition());
            IAtsVersion version = AtsApiService.get().getVersionService().getVersion(teamDefHoldVer, aData.version);
            if (version == null) {
                this.rd.errorf("No version [%s] configured for Team Definition [%s]", new Object[]{aData.version, teamWf.getTeamDefinition()});
            }
            AtsApiService.get().getVersionService().setTargetedVersion(teamWf, version, changes);
        }
        if (aData.estimatedHours != null) {
            changes.setSoleAttributeValue((ArtifactId)teamWf, (AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)aData.estimatedHours);
        }
        if (aData.assigneeStrs.size() > 0) {
            teamWf.getStateMgr().setAssignees(aData.assignees);
        }
        if (aData.originator != null) {
            changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, aData.originator.getUserId());
        }
    }

    private void addToAgile(IAtsChangeSet changes, ActionData aData, IAtsTeamWorkflow teamWf) {
        IAgileSprint sprint;
        IAgileBacklog backlog;
        if (Strings.isValid((String)aData.agileTeamName) && (backlog = this.getAgileBacklog(aData.agileTeamName)) != null) {
            changes.relate((Object)backlog, AtsRelationTypes.Goal_Member, (Object)teamWf);
        }
        if (Strings.isValid((String)aData.agileSprintName) && (sprint = this.getAgileSprint(aData.agileTeamName, aData.agileSprintName)) != null) {
            changes.relate((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)teamWf);
        }
        if (Strings.isValid((String)aData.agilePoints)) {
            IAgileTeam aTeam = this.getAgileTeamByName(aData.agileTeamName);
            AttributeTypeToken attrType = AtsApiService.get().getAgileService().getAgileTeamPointsAttributeType(aTeam);
            if (attrType.getId().equals(AtsAttributeTypes.Points.getId())) {
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, attrType, aData.agilePoints);
            } else if (attrType.getId().equals(AtsAttributeTypes.PointsNumeric.getId())) {
                changes.setSoleAttributeValue((IAtsObject)teamWf, attrType, (Object)Double.valueOf(aData.agilePoints));
            } else {
                throw new OseeArgumentException("Un-configured pointes types for team %s", new Object[]{teamWf.getTeamDefinition().toStringWithId()});
            }
        }
    }

    private IAgileTeam getAgileTeamByName(String agileTeamName) {
        IAgileTeam aTeam;
        IAgileTeam team = this.teamNameByTeamMap.get(agileTeamName);
        if (team == null && (aTeam = AtsApiService.get().getAgileService().getAgileTeamByName(agileTeamName)) != null) {
            this.teamNameByTeamMap.put(agileTeamName, aTeam);
            team = aTeam;
        }
        return team;
    }

    private IAgileSprint getAgileSprint(String agileTeamName, String agileSprintName) {
        IAgileTeam aTeam = this.getAgileTeamByName(agileTeamName);
        if (aTeam != null) {
            for (IAgileSprint teamSprint : AtsApiService.get().getAgileService().getAgileSprints(aTeam)) {
                if (!teamSprint.getName().equals(agileSprintName)) continue;
                return teamSprint;
            }
        }
        return null;
    }

    private IAgileBacklog getAgileBacklog(String agileTeamName) {
        IAgileTeam aTeam = AtsApiService.get().getAgileService().getAgileTeamByName(agileTeamName);
        if (aTeam != null) {
            return AtsApiService.get().getAgileService().getAgileBacklog(aTeam);
        }
        return null;
    }

    private void addToGoal(Collection<TeamWorkFlowArtifact> newTeamArts, IAtsChangeSet changes) {
        if (this.toGoal != null) {
            GoalArtifact goal = (GoalArtifact)AtsApiService.get().getQueryService().getArtifact((IAtsObject)this.toGoal);
            if (goal == null) {
                throw new OseeArgumentException("Goal artifact does not exist for goal %s", new Object[]{this.toGoal.toStringWithId()});
            }
            for (Artifact artifact : newTeamArts) {
                goal.addMember((ArtifactId)artifact);
            }
            changes.add((Object)goal);
        }
    }

    public Map<IAtsTeamDefinition, Collection<IAtsActionableItem>> getTeamDefToAias(Collection<IAtsActionableItem> aias) {
        HashMap<IAtsTeamDefinition, Collection<IAtsActionableItem>> teamDefToAias = new HashMap<IAtsTeamDefinition, Collection<IAtsActionableItem>>();
        for (IAtsActionableItem aia : aias) {
            IAtsTeamDefinition teamDef = (IAtsTeamDefinition)AtsApiService.get().getTeamDefinitionService().getImpactedTeamDefs(Arrays.asList(aia)).iterator().next();
            if (teamDefToAias.containsKey(teamDef)) {
                ((Collection)teamDefToAias.get(teamDef)).add(aia);
                continue;
            }
            teamDefToAias.put(teamDef, Arrays.asList(aia));
        }
        return teamDefToAias;
    }

    public void process(URI source) {
        try {
            XResultData rd;
            block11: {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                rd = new XResultData();
                try {
                    try {
                        xmlReader.setContentHandler((ContentHandler)new ExcelSaxHandler((RowProcessor)new InternalRowProcessor(this.actionDatas, rd), true));
                        this.inputStream = new InputStreamReader(source.toURL().openStream(), "UTF-8");
                        xmlReader.parse(new InputSource(this.inputStream));
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                        rd.errorf("Exception in parsing import (see log for details) %s\n", new Object[]{Strings.isValid((String)ex.getLocalizedMessage()) ? ex.getLocalizedMessage() : ""});
                        if (this.inputStream != null) {
                            this.inputStream.close();
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                    throw throwable;
                }
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            if (!rd.isEmpty()) {
                XResultDataUI.report((XResultData)rd, (String)"Action Import Validation Errors");
            }
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public String getDescription() {
        return "Extract each row as an Action";
    }

    public Set<Artifact> getActionArts() {
        return this.actionArts;
    }

    public String getName() {
        return "Excel Ats Actions";
    }

    public List<ActionData> getActionDatas() {
        return this.actionDatas;
    }

    public static final class ActionData {
        protected String title = "";
        protected String desc = "";
        protected String priorityStr = "";
        protected String changeType = "";
        protected Set<String> assigneeStrs = new HashSet<String>();
        protected List<AtsUser> assignees = new LinkedList<AtsUser>();
        protected AtsUser originator = null;
        protected Set<String> actionableItems = new HashSet<String>();
        protected String version = "";
        protected Double estimatedHours = null;
        protected List<JaxAttribute> attributes = new LinkedList<JaxAttribute>();
        protected String agilePoints = "";
        protected String agileTeamName = "";
        protected String agileSprintName = "";
    }

    private static final class InternalRowProcessor
    implements RowProcessor {
        private String[] headerRow;
        private int rowNum = 0;
        private final List<ActionData> actionDatas;
        private final XResultData resultData;

        protected InternalRowProcessor(List<ActionData> actionDatas, XResultData resultData) {
            this.actionDatas = actionDatas;
            this.resultData = resultData;
        }

        public void processEmptyRow() {
        }

        public void processCommentRow(String[] row) {
        }

        public void reachedEndOfWorksheet() {
        }

        public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
        }

        public void foundStartOfWorksheet(String sheetName) {
        }

        public void processHeaderRow(String[] headerRow) {
            this.headerRow = (String[])headerRow.clone();
        }

        public void processRow(String[] cols) {
            ++this.rowNum;
            boolean fullRow = false;
            int i = 0;
            while (i < cols.length) {
                if (Strings.isValid((String)cols[i])) {
                    fullRow = true;
                    break;
                }
                ++i;
            }
            if (!fullRow) {
                this.resultData.warning("Empty Row Found => " + this.rowNum + " skipping...");
                return;
            }
            ActionData aData = new ActionData();
            int i2 = 0;
            while (i2 < cols.length) {
                String header = this.headerRow[i2];
                if (header != null) {
                    if (header.equalsIgnoreCase(Columns.Title.name())) {
                        if (cols[i2].equals("")) {
                            return;
                        }
                        aData.title = cols[i2];
                    } else if (header.equalsIgnoreCase(Columns.Priority.name())) {
                        aData.priorityStr = cols[i2];
                    } else if (header.equalsIgnoreCase(Columns.Version.name())) {
                        aData.version = cols[i2] == null ? "" : cols[i2];
                    } else if (header.equalsIgnoreCase(Columns.ChangeType.name())) {
                        aData.changeType = cols[i2];
                    } else if (header.equalsIgnoreCase(Columns.Description.name())) {
                        aData.desc = cols[i2] == null ? "" : cols[i2];
                    } else if (header.equalsIgnoreCase(Columns.EstimatedHours.name())) {
                        if (Strings.isValid((String)cols[i2])) {
                            aData.estimatedHours = new Double(cols[i2]);
                        }
                    } else if (header.equalsIgnoreCase(Columns.ActionableItems.name())) {
                        this.processActionableItems(cols, aData, i2);
                    } else if (header.equalsIgnoreCase(Columns.Assignees.name())) {
                        this.processAssignees(cols, aData, i2);
                    } else if (header.equalsIgnoreCase(Columns.Originator.name())) {
                        this.processOriginator(cols, aData, i2);
                    } else if (header.equalsIgnoreCase(Columns.AgileTeamName.getColName())) {
                        if (Strings.isValid((String)cols[i2])) {
                            aData.agileTeamName = cols[i2];
                        }
                    } else if (header.equalsIgnoreCase(Columns.AgileSprintName.getColName())) {
                        if (Strings.isValid((String)cols[i2])) {
                            aData.agileSprintName = cols[i2];
                        }
                    } else if (header.equalsIgnoreCase(Columns.AgilePoints.getColName())) {
                        if (Strings.isValid((String)cols[i2])) {
                            aData.agilePoints = cols[i2];
                        }
                    } else {
                        String attrTypeName = header;
                        if (Strings.isValid((String)attrTypeName)) {
                            AttributeTypeToken attributeType = AttributeTypeManager.getType((String)attrTypeName);
                            if (attributeType == null) {
                                this.resultData.errorf("Invalid Attribute Type Name => %s\n", new Object[]{header});
                            } else if (!AtsArtifactTypes.Task.isValidAttributeType((AttributeTypeId)attributeType)) {
                                this.resultData.errorf("Invalid Attribute Type for Task => %s\n", new Object[]{header});
                            } else {
                                String value = cols[i2];
                                if (Strings.isValid((String)value)) {
                                    JaxAttribute attr = new JaxAttribute();
                                    attr.setAttrType(attributeType);
                                    attr.getValues().add(value);
                                    aData.attributes.add(attr);
                                }
                            }
                        } else {
                            this.resultData.errorf("Unhandled column => %s\n", new Object[]{header});
                        }
                    }
                }
                ++i2;
            }
            this.actionDatas.add(aData);
        }

        private void processActionableItems(String[] cols, ActionData aData, int i) {
            String[] stringArray = cols[i].split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (!str.equals("")) {
                    aData.actionableItems.add(str);
                }
                ++n2;
            }
        }

        private void processAssignees(String[] cols, ActionData aData, int i) {
            if (cols[i] != null) {
                String[] stringArray = cols[i].split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (!str.equals("")) {
                        aData.assigneeStrs.add(str);
                    }
                    ++n2;
                }
            }
        }

        private void processOriginator(String[] cols, ActionData aData, int i) {
            String origStr = cols[i];
            if (Strings.isValid((String)origStr)) {
                AtsUser orig = AtsApiService.get().getUserService().getUserByName(origStr);
                if (orig == null) {
                    this.resultData.errorf("Invalid name for originator [%s] rown %s", new Object[]{origStr, i});
                } else {
                    aData.originator = orig;
                }
            }
        }

        private static enum Columns {
            Title("Title"),
            Description("Description"),
            ActionableItems("ActionableItems"),
            Assignees("ActionableItems"),
            Originator("Originator"),
            Priority("Priority"),
            ChangeType("AllowDeny"),
            Version("Version"),
            EstimatedHours("EstimatedHours"),
            Goal("Goal"),
            AgileTeamName("Agile Team Name"),
            AgileSprintName("Agile Sprint Name"),
            AgilePoints("Agile Points");

            private final String colName;

            private Columns(String name) {
                this.colName = name;
            }

            public String getColName() {
                return this.colName;
            }
        }
    }
}

