/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XHyperlabelTeamDefinitionSelection;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;

public class TeamDefinitionSearchWidget {
    public static final String TEAM_DEFINITIONS = "Team Definition(s)";
    private final WorldEditorParameterSearchItem searchItem;

    public TeamDefinitionSearchWidget(WorldEditorParameterSearchItem searchItem) {
        this.searchItem = searchItem;
    }

    public void addWidget(int beginComposite) {
        this.searchItem.addWidgetXml(String.format("<XWidget displayName=\"%s\" xwidgetType=\"XHyperlabelTeamDefinitionSelection\" horizontalLabel=\"true\" %s />", TEAM_DEFINITIONS, this.searchItem.getBeginComposite(beginComposite)));
    }

    public Collection<Long> getIds() {
        LinkedList<Long> ids = new LinkedList<Long>();
        if (this.get() != null) {
            for (IAtsTeamDefinition teamDef : this.get()) {
                ids.add(teamDef.getId());
            }
        }
        return ids;
    }

    public Collection<IAtsTeamDefinition> get() {
        XHyperlabelTeamDefinitionSelection widget = this.getWidget();
        if (widget != null) {
            return AtsApiService.get().getTeamDefinitionService().getTeamDefs(widget.getSelectedTeamDefintions());
        }
        return null;
    }

    public XHyperlabelTeamDefinitionSelection getWidget() {
        return (XHyperlabelTeamDefinitionSelection)this.searchItem.getxWidgets().get(TEAM_DEFINITIONS);
    }

    public void set(Collection<TeamDefinition> teamDefs) {
        this.getWidget().setSelectedTeamDefs(teamDefs);
    }

    public void set(AtsSearchData data) {
        if (this.getWidget() != null) {
            this.getWidget().handleClear();
            LinkedList<TeamDefinition> teamDefs = new LinkedList<TeamDefinition>();
            for (Long id : data.getTeamDefIds()) {
                TeamDefinition teamDef = (TeamDefinition)AtsApiService.get().getConfigService().getConfigurations().getIdToTeamDef().get(id);
                if (teamDef == null) continue;
                teamDefs.add(teamDef);
            }
            this.set(teamDefs);
        }
    }
}

