/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.query.AtsSearchUserType;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.ClearSearchAction;
import org.eclipse.osee.ats.ide.search.DeleteSearchAction;
import org.eclipse.osee.ats.ide.search.LoadSearchAction;
import org.eclipse.osee.ats.ide.search.SaveAsSearchAction;
import org.eclipse.osee.ats.ide.search.SaveSearchAction;
import org.eclipse.osee.ats.ide.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;

public class AtsSearchWorkflowSearchItem
extends WorldEditorParameterSearchItem {
    private static final AtsImage IMAGE = AtsImage.SEARCH;
    private static final String TITLE = "Action Search";
    protected WorldSearchItem searchItem;
    private long searchId = Lib.generateId();
    private String searchName = "";
    protected AtsSearchData savedData;

    public AtsSearchWorkflowSearchItem() {
        super(TITLE, IMAGE);
        this.setShortName(TITLE);
    }

    public AtsSearchWorkflowSearchItem(String name, AtsImage image) {
        super(name, image);
        this.setShortName(name);
    }

    public AtsSearchWorkflowSearchItem(AtsSearchWorkflowSearchItem searchItem) {
        this(searchItem, TITLE, IMAGE);
    }

    public AtsSearchWorkflowSearchItem(AtsSearchWorkflowSearchItem searchItem, String name, AtsImage image) {
        super(searchItem, image);
        this.setShortName(name);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)IMAGE);
    }

    protected boolean showWorkItemWidgets() {
        return true;
    }

    protected boolean showWorkPackageWidgets() {
        return false;
    }

    protected void addWidgets() {
        if (this.showWorkItemWidgets()) {
            this.getWorkItemType().addWidget(14);
        }
        this.addBaseWidgets();
    }

    protected void addBaseWidgets() {
        this.getTitle().addWidget();
        this.getAi().addWidget(3);
        this.getTeamDef().addWidget(2);
        this.getVersion().addWidget(6);
        this.getStateType().addWidget();
        this.getStateName().addWidget();
        this.getUser().addWidget(6);
        this.getUserType().addWidget();
        if (this.showWorkPackageWidgets()) {
            this.getProgram().addWidget(8);
            this.getInsertion().addWidget();
            this.getInsertionActivity().addWidget();
            this.getWorkPackage().addWidget();
        }
    }

    @Override
    public String getParameterXWidgetXml() {
        this.addWidgets();
        return super.getParameterXWidgetXml();
    }

    public AtsSearchData loadSearchData(AtsSearchData data) {
        if (this.searchId > 0L) {
            data.setId(this.searchId);
        }
        data.setSearchName(this.searchName);
        if (this.getTitle() != null && Strings.isValid((String)this.getTitle().get())) {
            data.setTitle(this.getTitle().get());
        }
        if (data.getStateTypes() != null) {
            data.getStateTypes().clear();
            data.getStateTypes().addAll(this.getStateType().getTypes());
        }
        if (this.getUser() != null) {
            AtsUser user = (AtsUser)this.getUser().get();
            data.setUserId(user == null ? null : user.getUserId());
        }
        if (this.getUserType() != null) {
            data.setUserType((AtsSearchUserType)this.getUserType().get());
        }
        if (this.showWorkItemWidgets() && this.getWorkItemType() != null) {
            data.getWorkItemTypes().clear();
            data.getWorkItemTypes().addAll(this.getWorkItemType().get());
        }
        if (data.getTeamDefIds() != null) {
            data.getTeamDefIds().clear();
            data.getTeamDefIds().addAll(this.getTeamDef().getIds());
        }
        if (this.getAi().getIds() != null) {
            data.getAiIds().clear();
            data.getAiIds().addAll(this.getAi().getIds());
        }
        if (this.getVersion().get() != null) {
            data.setVersionId(((IAtsVersion)this.getVersion().get()).getId());
        }
        if (this.getStateName() != null && Strings.isValid((String)((String)this.getStateName().get()))) {
            data.setState((String)this.getStateName().get());
        }
        if (this.showWorkPackageWidgets() && this.getProgram() != null && this.getProgram().get() != null) {
            data.setProgramId(((IAtsProgram)this.getProgram().get()).getId());
        }
        if (this.showWorkPackageWidgets() && this.getInsertion() != null && this.getInsertion().get() != null) {
            data.setInsertionId(((IAtsInsertion)this.getInsertion().get()).getId());
        }
        if (this.showWorkPackageWidgets() && this.getInsertionActivity() != null && this.getInsertionActivity().get() != null) {
            data.setInsertionActivityId(((IAtsInsertionActivity)this.getInsertionActivity().get()).getId());
        }
        if (this.showWorkPackageWidgets() && this.getWorkPackage() != null && this.getWorkPackage().get() != null) {
            data.setWorkPackageId(((IAtsWorkPackage)this.getWorkPackage().get()).getId());
        }
        if (data.getWorkItemTypes().isEmpty()) {
            WorkItemType[] workItemTypeArray = WorkItemType.values();
            int n = workItemTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkItemType type = workItemTypeArray[n2];
                data.getWorkItemTypes().add(type);
                ++n2;
            }
        }
        data.setNamespace(this.getNamespace());
        if (this.getReviewType() != null) {
            data.setReviewType(this.getReviewType().getType());
        }
        return data;
    }

    public void loadWidgets(AtsSearchData data) {
        try {
            this.searchId = data.getId();
            this.searchName = data.getSearchName();
            this.getTitle().set(data);
            this.getStateType().set(data);
            this.getUser().set(data);
            this.getUserType().set(data);
            if (this.showWorkItemWidgets()) {
                this.getWorkItemType().clearAll();
                this.getWorkItemType().set(data);
            }
            this.getTeamDef().set(data);
            this.getAi().set(data);
            this.getVersion().set(data);
            this.getStateName().set(data);
            if (this.showWorkPackageWidgets()) {
                this.getProgram().set(data);
                this.getInsertion().set(data);
                this.getInsertionActivity().set(data);
                this.getWorkPackage().set(data);
            }
            this.getReviewType().set(data);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        return this.searchItem.performSearchGetResults(false);
    }

    @Override
    public void setupSearch() {
        AtsSearchData data = this.loadSearchData(new AtsSearchData());
        this.searchItem = new WorldSearchItem(data);
    }

    public void setRestoreId(long searchId) {
        Conditions.checkExpressionFailOnTrue((searchId <= 0L ? 1 : 0) != 0, (String)"searchId must be > 0, not %d", (Object[])new Object[]{searchId});
        this.searchId = searchId;
    }

    @Override
    public void createParametersSectionCompleted(IManagedForm managedForm, Composite mainComp) {
        AtsSearchData data;
        if (this.searchId > 0L && (data = AtsApiService.get().getQueryService().getSearch(AtsApiService.get().getUserService().getCurrentUser(), Long.valueOf(this.searchId))) != null) {
            this.loadWidgets(data);
            this.searchName = data.getSearchName();
        }
    }

    public long getSearchId() {
        return this.searchId;
    }

    @Override
    public String getShortName() {
        if (Strings.isValid((String)this.searchName)) {
            return String.valueOf(this.getShortNamePrefix()) + ": " + this.searchName;
        }
        return super.getShortName();
    }

    @Override
    public String getShortNamePrefix() {
        return "AS";
    }

    @Override
    public AtsSearchWorkflowSearchItem copy() {
        AtsSearchWorkflowSearchItem item = new AtsSearchWorkflowSearchItem(this);
        item.setSavedData(this.savedData);
        return item;
    }

    @Override
    public AtsSearchWorkflowSearchItem copyProvider() {
        AtsSearchWorkflowSearchItem item = new AtsSearchWorkflowSearchItem(this);
        item.setSavedData(this.savedData);
        return item;
    }

    @Override
    public void createToolbar(IToolBarManager toolBarManager) {
        toolBarManager.insertBefore("world.menu.group.pre", (IAction)new SaveSearchAction(this));
        toolBarManager.insertBefore("world.menu.group.pre", (IAction)new SaveAsSearchAction(this));
        toolBarManager.insertBefore("world.menu.group.pre", (IAction)new LoadSearchAction(this));
        toolBarManager.insertBefore("world.menu.group.pre", (IAction)new DeleteSearchAction(this));
        toolBarManager.insertBefore("world.menu.group.pre", (IAction)new ClearSearchAction(this));
        toolBarManager.insertBefore("world.menu.group.pre", (IContributionItem)new Separator());
    }

    @Override
    public Result isParameterSelectionValid() {
        Result result = super.isParameterSelectionValid();
        if (result.isFalse()) {
            return result;
        }
        try {
            return Result.TrueResult;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return new Result("Exception: " + ex.getLocalizedMessage());
        }
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public void setSearchId(long searchId) {
        this.searchId = searchId;
    }

    public String getNamespace() {
        return "ats.search";
    }

    public AtsSearchData getSavedData() {
        return this.savedData;
    }

    public void setSavedData(AtsSearchData savedData) {
        this.savedData = savedData;
    }
}

