/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.swt.graphics.Image;

public class FilteredDialogExampleUtil {
    private static MyTask child3;
    private static MyTask parent11;

    protected static void openAndReport(FilteredCheckboxTreeDialog<?> dialog, String title) {
        int result = dialog.open();
        XResultData rd = new XResultData();
        rd.log("RESULT=" + (result == 0 ? "Ok" : "Cancel"));
        Collection checked = dialog.getChecked();
        for (Object obj : checked) {
            rd.log("SELECTED=" + obj.toString());
        }
        if (checked.size() == 0) {
            rd.log("NONE SELECTED");
        }
        XResultDataUI.report((XResultData)rd, (String)title);
    }

    protected static void openAndReport(FilteredTreeDialog dialog, String title) {
        int result = dialog.open();
        XResultData rd = new XResultData();
        rd.log("RESULT=" + (result == 0 ? "Ok" : "Cancel"));
        Collection selected = dialog.getSelected();
        for (Object obj : selected) {
            rd.log("SELECTED=" + obj.toString());
        }
        if (dialog.getSelected().size() == 0) {
            rd.log("NONE SELECTED");
        }
        XResultDataUI.report((XResultData)rd, (String)title);
    }

    protected static List<MyTask> getInput() {
        ArrayList<MyTask> tasks = new ArrayList<MyTask>();
        MyTask parent1 = new MyTask("First One");
        tasks.add(parent1);
        MyTask child1 = new MyTask("Child this 1", parent1);
        parent1.addChild(child1);
        MyTask child2 = new MyTask("Child that 2", parent1);
        parent1.addChild(child2);
        child3 = new MyTask("Child and 3", parent1);
        parent1.addChild(child3);
        MyTask child4 = new MyTask("Child what 4", parent1);
        parent1.addChild(child4);
        parent11 = new MyTask("Second One");
        tasks.add(parent11);
        MyTask child11 = new MyTask("Child this 11", parent11);
        parent11.addChild(child11);
        MyTask child21 = new MyTask("Child that 21", parent11);
        parent11.addChild(child21);
        MyTask child31 = new MyTask("Child and 31", parent11);
        parent11.addChild(child31);
        MyTask child41 = new MyTask("Child what 41", parent11);
        parent11.addChild(child41);
        MyTask parent111 = new MyTask("Third One");
        tasks.add(parent111);
        MyTask child111 = new MyTask("Child this 111", parent111);
        parent111.addChild(child111);
        MyTask child211 = new MyTask("Child that 211", parent111);
        parent111.addChild(child211);
        MyTask child311 = new MyTask("Child and 311", parent111);
        parent111.addChild(child311);
        MyTask child411 = new MyTask("Child what 411", parent111);
        parent111.addChild(child411);
        return tasks;
    }

    public static MyTask getChild3() {
        return child3;
    }

    public static MyTask getParent11() {
        return parent11;
    }

    public static class FilterLabelProvider
    implements ILabelProvider {
        public Image getImage(Object arg0) {
            return null;
        }

        public String getText(Object arg0) {
            if (arg0 == null) {
                return "";
            }
            try {
                return arg0.toString();
            }
            catch (OseeCoreException ex) {
                return ex.getLocalizedMessage();
            }
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    public static class MyTask {
        String name;
        MyTask parent;
        List<MyTask> children = new ArrayList<MyTask>();

        public MyTask(String name) {
            this.name = name;
        }

        public MyTask(String name, MyTask parent) {
            this.name = name;
            this.parent = parent;
        }

        public String toString() {
            return this.name;
        }

        public void addChild(MyTask child) {
            this.children.add(child);
        }

        public MyTask getParent() {
            return this.parent;
        }

        public List<MyTask> getChildren() {
            return this.children;
        }
    }

    public static class MyTreeContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            if (parentElement instanceof Collection) {
                return ((Collection)parentElement).toArray();
            }
            if (parentElement instanceof MyTask) {
                return ((MyTask)parentElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof MyTask) {
                return ((MyTask)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof MyTask) {
                return !((MyTask)element).getChildren().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class MyViewSorter
    extends ViewerComparator {
        public int compare(Viewer viewer, Object o1, Object o2) {
            return super.compare(viewer, o1, o2);
        }
    }
}

