/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.ev;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.core.model.WorkPackage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class SearchWorkPackageOperation
extends AbstractOperation {
    private final Collection<IAtsTeamDefinition> teamDefs;
    private final Collection<IAtsActionableItem> ais;
    private final Active activeWorkPkgs;
    private final Set<Artifact> results = new HashSet<Artifact>();
    private final boolean includeChildrenTeamDefs;
    private final boolean includeChildrenAis;

    public SearchWorkPackageOperation(String operationName, Collection<IAtsTeamDefinition> teamDefs, boolean includeChildrenTeamDefs, Collection<IAtsActionableItem> ais, boolean includeChildrenAis, Active activeWorkPkgs) {
        super(operationName, "org.eclipse.osee.ats.ide");
        this.includeChildrenTeamDefs = includeChildrenTeamDefs;
        this.includeChildrenAis = includeChildrenAis;
        Conditions.notNull((Object[])new Object[]{teamDefs});
        Conditions.notNull((Object[])new Object[]{ais});
        Conditions.notNull((Object[])new Object[]{activeWorkPkgs});
        this.teamDefs = teamDefs;
        this.ais = ais;
        this.activeWorkPkgs = activeWorkPkgs;
    }

    protected void doWork(IProgressMonitor monitor) {
        if (this.teamDefs.isEmpty() && this.ais.isEmpty()) {
            throw new OseeArgumentException("ERROR", new Object[]{"Must provide Team Definitions or Actionable Items"});
        }
        SearchWorkPackageOperation.checkForCancelledStatus((IProgressMonitor)monitor);
        ArrayList<ArtifactId> ids = new ArrayList<ArtifactId>();
        this.addAllTeamDefIds(monitor, Collections.castAll(this.teamDefs), this.includeChildrenTeamDefs, ids);
        this.addAllAisIds(monitor, this.ais, this.includeChildrenAis, ids);
        for (Artifact teamOrAiArt : ArtifactQuery.getArtifactListFrom(ids, (BranchId)AtsApiService.get().getAtsBranch())) {
            for (Artifact workPkgArt : teamOrAiArt.getRelatedArtifacts(AtsRelationTypes.TeamDefinitionToWorkPackage_WorkPackage)) {
                boolean active = (Boolean)workPkgArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)true);
                if (this.activeWorkPkgs == Active.Both || active && this.activeWorkPkgs == Active.Active || !active && this.activeWorkPkgs == Active.InActive) {
                    this.results.add(workPkgArt);
                }
                SearchWorkPackageOperation.checkForCancelledStatus((IProgressMonitor)monitor);
            }
            SearchWorkPackageOperation.checkForCancelledStatus((IProgressMonitor)monitor);
        }
    }

    private void addAllAisIds(IProgressMonitor monitor, Collection<IAtsActionableItem> ais2, boolean includeChildrenAis2, List<ArtifactId> ids) {
        for (IAtsActionableItem ai : ais2) {
            ids.add((ArtifactId)ai.getStoreObject());
            if (!includeChildrenAis2) continue;
            this.addAllAisIds(monitor, ai.getChildrenActionableItems(), includeChildrenAis2, ids);
            SearchWorkPackageOperation.checkForCancelledStatus((IProgressMonitor)monitor);
        }
    }

    private void addAllTeamDefIds(IProgressMonitor monitor, Collection<TeamDefinition> teamDefs2, boolean includeChildrenTeamDefs2, List<ArtifactId> ids) {
        for (IAtsTeamDefinition iAtsTeamDefinition : teamDefs2) {
            ids.add((ArtifactId)iAtsTeamDefinition.getStoreObject());
            if (!includeChildrenTeamDefs2) continue;
            this.addAllTeamDefIds(monitor, AtsApiService.get().getTeamDefinitionService().getChildrenTeamDefinitions(iAtsTeamDefinition), includeChildrenTeamDefs2, ids);
            SearchWorkPackageOperation.checkForCancelledStatus((IProgressMonitor)monitor);
        }
    }

    public Set<Artifact> getResultArtifacts() {
        return this.results;
    }

    public Set<IAtsWorkPackage> getResults() {
        HashSet<IAtsWorkPackage> resultWorkPgks = new HashSet<IAtsWorkPackage>();
        for (Artifact art : this.results) {
            resultWorkPgks.add((IAtsWorkPackage)new WorkPackage(AtsApiService.get().getLogger(), (AtsApi)AtsApiService.get(), (ArtifactToken)art));
        }
        return resultWorkPgks;
    }
}

