/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WfeTeamAndIdsHeader
extends Composite {
    private final IAtsWorkItem workItem;
    Text teamWfIdValue;
    Text parentIdValue;
    Text idValue;
    Text actionIdValue;

    public WfeTeamAndIdsHeader(Composite parent, int style, IAtsWorkItem workItem, WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.setLayoutData(new GridData(768));
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)3, (boolean)true));
        editor.getToolkit().adapt((Composite)this);
        try {
            if (workItem.isTeamWorkflow()) {
                this.teamWfIdValue = (Text)FormsUtil.createLabelText((XFormToolkit)editor.getToolkit(), (Composite)this, (String)"Team: ", (String)"").getSecond();
                this.teamWfIdValue.setLayoutData((Object)new GridData(768));
            } else if ((workItem.isTask() || workItem.isReview()) && workItem.getParentTeamWorkflow() != null) {
                this.parentIdValue = (Text)FormsUtil.createLabelText((XFormToolkit)editor.getToolkit(), (Composite)this, (String)"Parent Id: ", (String)"").getSecond();
                this.parentIdValue.setLayoutData((Object)new GridData(768));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        try {
            this.idValue = (Text)FormsUtil.createLabelText((XFormToolkit)editor.getToolkit(), (Composite)this, (String)(String.valueOf(workItem.getArtifactTypeName()) + " Id: "), (String)"").getSecond();
            this.idValue.setLayoutData((Object)new GridData(768));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        try {
            IAtsAction action = workItem.getParentAction();
            if (action != null) {
                this.actionIdValue = (Text)FormsUtil.createLabelText((XFormToolkit)editor.getToolkit(), (Composite)this, (String)"Action Id: ", (String)"").getSecond();
                this.actionIdValue.setLayoutData((Object)new GridData(768));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        this.refresh();
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.idValue)) {
            Thread refreshThread = new Thread("Refresh Workflow Editor"){

                @Override
                public void run() {
                    super.run();
                    String legacyPcrId = AtsApiService.get().getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)WfeTeamAndIdsHeader.this.workItem, (AttributeTypeToken)AtsAttributeTypes.LegacyPcrId, "");
                    legacyPcrId = Strings.isValid((String)legacyPcrId) ? " | " + legacyPcrId : "";
                    String idValueStr = String.valueOf(WfeTeamAndIdsHeader.this.workItem.getAtsId()) + legacyPcrId;
                    String teamWfIdValueStr = "";
                    String parentIdValueStr = "";
                    if (WfeTeamAndIdsHeader.this.workItem.isTeamWorkflow()) {
                        teamWfIdValueStr = ((TeamWorkFlowArtifact)WfeTeamAndIdsHeader.this.workItem).getTeamName();
                    } else if ((WfeTeamAndIdsHeader.this.workItem.isTask() || WfeTeamAndIdsHeader.this.workItem.isReview()) && WfeTeamAndIdsHeader.this.workItem.getParentTeamWorkflow() != null) {
                        IAtsTeamWorkflow parentTeamWorkflow = WfeTeamAndIdsHeader.this.workItem.getParentTeamWorkflow();
                        parentIdValueStr = AtsApiService.get().getWorkItemService().getCombinedPcrId((IAtsWorkItem)parentTeamWorkflow);
                    }
                    IAtsAction action = WfeTeamAndIdsHeader.this.workItem.getParentAction();
                    String actionIdValueStr = "";
                    if (action != null) {
                        actionIdValueStr = action.getAtsId();
                    }
                    final String fTeamWfIdValueStr = teamWfIdValueStr;
                    final String fIdValueStr = idValueStr;
                    final String fParentIdValueStr = parentIdValueStr;
                    final String fActionIdValueStrr = actionIdValueStr;
                    Displays.ensureInDisplayThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (Widgets.isAccessible((Widget)(this).WfeTeamAndIdsHeader.this.idValue)) {
                                (this).WfeTeamAndIdsHeader.this.idValue.setText(fIdValueStr);
                            }
                            if (Widgets.isAccessible((Widget)(this).WfeTeamAndIdsHeader.this.teamWfIdValue)) {
                                (this).WfeTeamAndIdsHeader.this.teamWfIdValue.setText(fTeamWfIdValueStr);
                            }
                            if (Widgets.isAccessible((Widget)(this).WfeTeamAndIdsHeader.this.parentIdValue)) {
                                (this).WfeTeamAndIdsHeader.this.parentIdValue.setText(fParentIdValueStr);
                            }
                            if (Widgets.isAccessible((Widget)(this).WfeTeamAndIdsHeader.this.actionIdValue)) {
                                (this).WfeTeamAndIdsHeader.this.actionIdValue.setText(fActionIdValueStrr);
                            }
                        }
                    });
                }
            };
            refreshThread.start();
        }
    }
}

