/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.copy;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.config.copy.ConfigData;
import org.eclipse.osee.ats.ide.config.copy.CopyAtsUtil;
import org.eclipse.osee.ats.ide.health.ValidateResults;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class CopyAtsValidation {
    private final ConfigData configData;
    protected final XResultData resultData;

    public CopyAtsValidation(ConfigData configData, XResultData resultData) {
        this.configData = configData;
        this.resultData = resultData;
    }

    public void validate() {
        this.configData.validateData(this.resultData);
        if (this.resultData.isErrors()) {
            return;
        }
        this.performValidateAtsDatabaseChecks();
        if (this.resultData.isErrors()) {
            return;
        }
        this.validateTeamDefinition(this.configData.getTeamDef());
        this.validateActionableItem(this.configData.getActionableItem());
    }

    private void performValidateAtsDatabaseChecks() {
        ValidateResults results = new ValidateResults();
        HashSet aias = new HashSet();
        aias.addAll(Collections.castAll((Collection)AtsApiService.get().getQueryService().getArtifactsFromObjects((Collection)AtsApiService.get().getActionableItemService().getActionableItemsFromItemAndChildren(this.configData.getActionableItem()))));
        HashSet teamDefs = new HashSet();
        teamDefs.addAll(AtsApiService.get().getTeamDefinitionService().getTeamsFromItemAndChildren(this.configData.getTeamDef()));
        results.addResultsMapToResultData(this.resultData);
    }

    private void validateTeamDefinition(IAtsTeamDefinition teamDef) {
        String newName = CopyAtsUtil.getConvertedName(this.configData, teamDef.getName());
        if (newName.equals(teamDef.getName())) {
            this.resultData.errorf("Could not get new name from name conversion for Team Definition [%s]", new Object[]{teamDef.getName()});
        }
        for (IAtsTeamDefinition childTeamDef : AtsApiService.get().getTeamDefinitionService().getTeamsFromItemAndChildren(teamDef)) {
            if (!teamDef.notEqual((Id)childTeamDef)) continue;
            this.validateTeamDefinition(childTeamDef);
        }
    }

    private void validateActionableItem(IAtsActionableItem aiArt) {
        String newName = CopyAtsUtil.getConvertedName(this.configData, aiArt.getName());
        if (newName.equals(aiArt.getName())) {
            this.resultData.errorf("Could not get new name from name conversion for ActionableItem [%s]", new Object[]{aiArt.getName()});
        }
        for (IAtsActionableItem childAiArt : AtsApiService.get().getActionableItemService().getActionableItemsFromItemAndChildren(aiArt)) {
            if (!aiArt.notEqual((Id)childAiArt)) continue;
            this.validateActionableItem(childAiArt);
        }
    }
}

