/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.core.column.AtsColumnToken;
import org.eclipse.osee.ats.ide.agile.AgileFeatureGroupColumn;
import org.eclipse.osee.ats.ide.agile.SprintColumn;
import org.eclipse.osee.ats.ide.column.AbstractMembersOrderColumn;
import org.eclipse.osee.ats.ide.column.AgileTeamPointsColumnUI;
import org.eclipse.osee.ats.ide.column.AssigneeColumnUI;
import org.eclipse.osee.ats.ide.column.BacklogOrderColumn;
import org.eclipse.osee.ats.ide.column.ChangeTypeColumnUI;
import org.eclipse.osee.ats.ide.column.CreatedDateColumnUI;
import org.eclipse.osee.ats.ide.column.PriorityColumnUI;
import org.eclipse.osee.ats.ide.column.TargetedVersionColumnUI;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.world.WorldXViewerFactory;
import org.eclipse.osee.ats.ide.world.WorldXViewerSorter;
import org.eclipse.osee.ats.ide.world.WorldXViewerUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.SkynetXViewerFactory;

public class BacklogXViewerFactory
extends SkynetXViewerFactory {
    public static final String NAMESPACE = "BacklogXViewer";

    public BacklogXViewerFactory(GoalArtifact soleBacklogArtifact, IOseeTreeReportProvider reportProvider) {
        super(NAMESPACE, reportProvider);
        List<XViewerAtsAttributeValueColumn> configCols = WorldXViewerUtil.getConfigurationColumns();
        LinkedList<XViewerColumn> backlogCols = new LinkedList<XViewerColumn>();
        WorldXViewerUtil.addColumn(this, BacklogOrderColumn.getInstance(), AbstractMembersOrderColumn.DEFAULT_WIDTH, backlogCols);
        WorldXViewerUtil.addColumn(this, new XViewerAtsAttributeValueColumn(AtsColumnToken.TitleColumn), 300, backlogCols);
        WorldXViewerUtil.addColumn(this, AgileTeamPointsColumnUI.getInstance(), AtsColumnToken.AgileTeamPointsColumn.getWidth(), backlogCols);
        WorldXViewerUtil.addColumn(this, WorldXViewerFactory.getColumnServiceColumn(AtsColumnToken.StateColumn), 116, backlogCols);
        WorldXViewerUtil.addColumn(this, PriorityColumnUI.getInstance(), 20, backlogCols);
        WorldXViewerUtil.addColumn(this, ChangeTypeColumnUI.getInstance(), 20, backlogCols);
        WorldXViewerUtil.addColumn(this, AssigneeColumnUI.getInstance(), 113, backlogCols);
        WorldXViewerUtil.addColumn(this, TargetedVersionColumnUI.getInstance(), 50, backlogCols);
        WorldXViewerUtil.addColumn(this, SprintColumn.getInstance(), 100, backlogCols);
        XViewerColumn unPlannedWorkColumn = WorldXViewerUtil.getConfigColumn("ats.Unplanned Work", configCols);
        if (unPlannedWorkColumn != null) {
            WorldXViewerUtil.addColumn(this, unPlannedWorkColumn, 20, backlogCols);
            configCols.remove(unPlannedWorkColumn);
        }
        WorldXViewerUtil.addColumn(this, AgileFeatureGroupColumn.getInstance(), 91, backlogCols);
        WorldXViewerUtil.addColumn(this, CreatedDateColumnUI.getInstance(), 82, backlogCols);
        WorldXViewerUtil.addColumn(this, WorldXViewerFactory.getColumnServiceColumn(AtsColumnToken.AtsIdColumnShow), 50, backlogCols);
        XViewerColumn[] xViewerColumnArray = WorldXViewerFactory.getWorldViewColumns();
        int n = xViewerColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            XViewerColumn worldCol = xViewerColumnArray[n2];
            if (!backlogCols.contains(worldCol)) {
                XViewerColumn newCol = worldCol.copy();
                newCol.setShow(false);
                this.registerColumns(new XViewerColumn[]{newCol});
            }
            ++n2;
        }
        WorldXViewerUtil.registerAtsAttributeColumns(this);
        WorldXViewerUtil.registerPluginColumns(this);
        for (XViewerAtsAttributeValueColumn col : configCols) {
            this.registerColumns(new XViewerColumn[]{col});
        }
    }

    public XViewerSorter createNewXSorter(XViewer xViewer) {
        return new WorldXViewerSorter(xViewer);
    }

    public CustomizeData getDefaultTableCustomizeData() {
        CustomizeData customizeData = super.getDefaultTableCustomizeData();
        for (XViewerColumn xCol : customizeData.getColumnData().getColumns()) {
            if (!xCol.getId().equals("ats.column.backlogOrder")) continue;
            xCol.setSortForward(true);
        }
        customizeData.getSortingData().setSortingNames(new String[]{"ats.column.backlogOrder"});
        return customizeData;
    }
}

