/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class ExtractText {
    protected String line;
    protected int lineNum;
    protected BufferedReader in;
    protected FileWriter out;

    public ExtractText(String sourceFile) {
        try {
            this.in = new BufferedReader(new FileReader(sourceFile));
            this.out = new FileWriter("sourceText.txt");
            this.line = null;
            this.lineNum = 0;
            while ((this.line = this.in.readLine()) != null) {
                int pos = this.line.indexOf("/*");
                if (pos != -1) {
                    if (!ExtractText.insideStringLiteral(this.line, pos)) {
                        pos = this.line.indexOf("*/");
                        while (this.line != null && pos == -1) {
                            this.writeText();
                            this.line = this.in.readLine();
                            if (this.line == null) continue;
                            pos = this.line.indexOf("*/");
                        }
                        this.writeText();
                    } else {
                        this.writeText();
                    }
                } else if (this.line.indexOf("//") != -1) {
                    this.writeText();
                } else {
                    pos = this.line.indexOf("\"");
                    if (pos != -1 && this.line.charAt(pos + 1) != '\'') {
                        this.writeText();
                    }
                }
                ++this.lineNum;
            }
            this.in.close();
            this.out.close();
        }
        catch (IOException ex) {
            XConsoleLogger.err(Lib.exceptionToString(ex), new Object[0]);
            return;
        }
    }

    protected void writeText() throws IOException {
        String str = String.valueOf(++this.lineNum);
        this.out.write(str, 0, str.length());
        this.out.write(this.line, 0, this.line.length());
        this.out.write(10);
    }

    public static boolean insideStringLiteral(String str, int pos) {
        int index = 0;
        boolean inside = false;
        char[] chars = new char[str.length()];
        str.getChars(0, chars.length, chars, 0);
        while (index < pos) {
            if (chars[index] == '\\' && chars[index + 1] == '\"') {
                ++index;
            } else if (chars[index] == '\"') {
                inside = !inside;
            }
            ++index;
        }
        return inside;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            XConsoleLogger.out("Usage:\tExtractText [source\tfile]", new Object[0]);
            return;
        }
        new ExtractText(args[0]);
    }
}

