/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.parsers;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.importing.parsers.AbstractArtifactExtractor;

public class NativeDocumentExtractor
extends AbstractArtifactExtractor {
    @Override
    public String getDescription() {
        return "Extract the content of each native document as one artifact.";
    }

    @Override
    protected void extractFromSource(OperationLogger logger, URI source, RoughArtifactCollector collector) {
        String extension = Lib.getExtension((String)source.toASCIIString());
        String name = Lib.removeExtension((String)new File(source).getName());
        RoughArtifact roughArtifact = new RoughArtifact(CoreArtifactTypes.NativeArtifact, name);
        collector.addRoughArtifact(roughArtifact);
        roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.Extension, extension);
        roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.NativeContent, source);
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }
        };
    }

    @Override
    public String getName() {
        return "General Documents (Any Format)";
    }
}

