/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughRelation;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractor;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;

public class RoughToRealArtifactOperation
extends AbstractOperation {
    private final SkynetTransaction transaction;
    private final RoughArtifactCollector rawData;
    private final IArtifactImportResolver artifactResolver;
    private final Map<RoughArtifact, Artifact> roughToRealArtifact;
    private final Collection<Artifact> createdArtifacts;
    private final Artifact destinationArtifact;
    private final RelationSorter importArtifactOrder;
    private final boolean deleteUnmatchedArtifacts;
    private final OrcsTokenService tokenService;
    private Collection<Artifact> unmatchedArtifacts;
    private final IArtifactExtractor extractor;
    private boolean addRelation = true;

    public RoughToRealArtifactOperation(SkynetTransaction transaction, Artifact destinationArtifact, RoughArtifactCollector rawData, IArtifactImportResolver artifactResolver, boolean deleteUnmatchedArtifacts, IArtifactExtractor extractor) {
        super("Materialize Artifacts", "org.eclipse.osee.framework.skynet.core");
        this.rawData = rawData;
        this.transaction = transaction;
        this.artifactResolver = artifactResolver;
        this.destinationArtifact = destinationArtifact;
        this.importArtifactOrder = RelationSorter.PREEXISTING;
        this.roughToRealArtifact = new HashMap<RoughArtifact, Artifact>();
        this.createdArtifacts = new LinkedList<Artifact>();
        this.deleteUnmatchedArtifacts = deleteUnmatchedArtifacts;
        this.extractor = extractor;
        this.tokenService = (OrcsTokenService)OsgiUtil.getService(OrcsTokenService.class, OrcsTokenService.class);
        this.roughToRealArtifact.put(rawData.getParentRoughArtifact(), this.destinationArtifact);
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        if (monitor != null) {
            monitor.setTaskName("Creating Artifacts");
        }
        this.unmatchedArtifacts = this.destinationArtifact.getDescendants();
        int totalItems = this.rawData.getRoughArtifacts().size() + this.rawData.getRoughRelations().size();
        int unitOfWork = this.calculateWork(1.0 / (double)totalItems);
        for (RoughArtifact roughArtifact : this.rawData.getParentRoughArtifact().getChildren()) {
            Artifact child = this.createArtifact(monitor, roughArtifact, this.destinationArtifact);
            this.createdArtifacts.add(child);
            if (this.addRelation && child != null && !child.hasParent()) {
                this.destinationArtifact.addChild(this.importArtifactOrder, child);
            }
            if (monitor != null) {
                monitor.worked(unitOfWork);
            }
            if (monitor != null) {
                monitor.setTaskName("Creating Relations");
            }
            for (RoughRelation roughRelation : this.rawData.getRoughRelations()) {
                this.createRelation(monitor, roughRelation);
                if (monitor == null) continue;
                monitor.worked(unitOfWork);
            }
        }
        if (this.deleteUnmatchedArtifacts) {
            for (Artifact toDelete : this.unmatchedArtifacts) {
                toDelete.deleteAndPersist(this.transaction);
            }
        }
    }

    private Artifact createArtifact(IProgressMonitor monitor, RoughArtifact roughArtifact, Artifact realParent) {
        Artifact realArtifact = this.roughToRealArtifact.get(roughArtifact);
        if (realArtifact != null) {
            return realArtifact;
        }
        realArtifact = this.artifactResolver.resolve(roughArtifact, BranchManager.getBranchToken(this.transaction.getBranch()), realParent, this.destinationArtifact);
        this.unmatchedArtifacts.remove((Object)realArtifact);
        for (RoughArtifact childRoughArtifact : roughArtifact.getDescendants()) {
            Artifact childArtifact = this.createArtifact(monitor, childRoughArtifact, realArtifact);
            if (this.areValid(realArtifact, childArtifact)) {
                this.removeOtherParent(childArtifact, realArtifact);
                if (!childArtifact.hasParent()) {
                    realArtifact.addChild(this.importArtifactOrder, childArtifact);
                }
            }
            if (this.extractor == null || !this.extractor.artifactCreated(childArtifact, childRoughArtifact)) continue;
            childArtifact.persist(this.transaction);
        }
        if (realArtifact != null) {
            realArtifact.persist(this.transaction);
        }
        return realArtifact;
    }

    private void removeOtherParent(Artifact child, Artifact parent) {
        if (this.hasDifferentParent(child, parent)) {
            child.deleteRelations(CoreRelationTypes.DefaultHierarchical_Parent);
            child.persist(this.transaction);
        }
    }

    private boolean hasDifferentParent(Artifact art, Artifact parent) {
        return art.hasParent() && art.getParent().notEqual((Id)parent);
    }

    private boolean isValid(Artifact art) {
        return art != null && !art.isDeleted();
    }

    private boolean areValid(Artifact ... artifacts) {
        boolean returnValue = true;
        Artifact[] artifactArray = artifacts;
        int n = artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            Artifact art = artifactArray[n2];
            returnValue &= this.isValid(art);
            ++n2;
        }
        return returnValue;
    }

    private void createRelation(IProgressMonitor monitor, RoughRelation roughRelation) {
        RelationTypeToken relationType = this.tokenService.getRelationType(roughRelation.getRelationTypeName());
        Artifact aArt = ArtifactQuery.getArtifactFromId(roughRelation.getAartifactGuid(), this.transaction.getBranch());
        Artifact bArt = ArtifactQuery.getArtifactFromId(roughRelation.getBartifactGuid(), this.transaction.getBranch());
        if (aArt == null || bArt == null) {
            OseeLog.log(Activator.class, (Level)Level.WARNING, (String)("The relation of type " + roughRelation.getRelationTypeName() + " could not be created."));
            if (aArt == null) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)("The artifact with guid: " + roughRelation.getAartifactGuid() + " does not exist."));
            }
            if (bArt == null) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)("The artifact with guid: " + roughRelation.getBartifactGuid() + " does not exist."));
            }
        } else {
            try {
                if (monitor != null) {
                    monitor.subTask(String.valueOf(aArt.getName()) + " <--> " + bArt.getName());
                    monitor.worked(1);
                }
                RelationManager.addRelation(this.importArtifactOrder, relationType, aArt, bArt, roughRelation.getRationale());
                aArt.persist(this.transaction);
            }
            catch (IllegalArgumentException ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (Throwable)ex);
            }
        }
    }

    public boolean isAddRelation() {
        return this.addRelation;
    }

    public void setAddRelation(boolean addRelation) {
        this.addRelation = addRelation;
    }

    public Collection<Artifact> getCreatedArtifacts() {
        return this.createdArtifacts;
    }
}

