/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.model;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.DefaultBasicIdRelation;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;

public class EventBasicGuidRelation
extends DefaultBasicIdRelation {
    private final RelationEventType relationEventType;
    private final int artAId;
    private final int artBId;
    private String rationale;

    public EventBasicGuidRelation(RelationEventType relationEventType, ArtifactId artAId, ArtifactId artBId, DefaultBasicIdRelation guidRel) {
        this(relationEventType, guidRel.getBranch(), guidRel.getRelTypeGuid(), guidRel.getRelationId(), guidRel.getGammaId(), artAId.getId().intValue(), guidRel.getArtA(), artBId.getId().intValue(), guidRel.getArtB());
    }

    public EventBasicGuidRelation(RelationEventType relationEventType, BranchId branchUuid, Long relTypeGuid, Long relationId, GammaId gammaId, int artAId, DefaultBasicGuidArtifact artA, int artBId, DefaultBasicGuidArtifact artB) {
        super(branchUuid, relTypeGuid, relationId, gammaId, artA, artB);
        this.relationEventType = relationEventType;
        this.artAId = artAId;
        this.artBId = artBId;
    }

    public RelationEventType getModType() {
        return this.relationEventType;
    }

    public String toString() {
        return String.format("[%s - B:%s - TG:%s - GI:%s - RI:%s - A:%s - B:%s]", new Object[]{this.relationEventType, this.getBranch().getIdString(), this.getBranch().getIdString(), this.getGammaId(), this.getRelationId(), this.getArtA(), this.getArtB()});
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.relationEventType == null ? 0 : this.relationEventType.hashCode());
        result = 31 * result + this.artAId;
        result = 31 * result + (this.getArtA() == null ? 0 : this.getArtA().hashCode());
        result = 31 * result + this.artBId;
        result = 31 * result + (this.getArtB() == null ? 0 : this.getArtB().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EventBasicGuidRelation other = (EventBasicGuidRelation)((Object)obj);
        if (this.relationEventType == null ? other.relationEventType != null : !this.relationEventType.equals((Object)other.relationEventType)) {
            return false;
        }
        if (this.artAId != other.artAId) {
            return false;
        }
        if (this.getArtA() == null ? other.getArtA() != null : !this.getArtA().equals((Object)other.getArtA())) {
            return false;
        }
        if (this.artBId != other.artBId) {
            return false;
        }
        return !(this.getArtB() == null ? other.getArtB() != null : !this.getArtB().equals((Object)other.getArtB()));
    }

    public int getArtAId() {
        return this.artAId;
    }

    public int getArtBId() {
        return this.artBId;
    }

    public String getRationale() {
        return this.rationale;
    }

    public void setRationale(String rationale) {
        this.rationale = rationale;
    }

    public boolean is(RelationEventType ... relationEventTypes) {
        RelationEventType[] relationEventTypeArray = relationEventTypes;
        int n = relationEventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RelationEventType eventModType = relationEventTypeArray[n2];
            if (this.relationEventType == eventModType) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

