/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.conflict;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.core.enums.ConflictType;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.BranchMergeException;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.conflict.Conflict;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;

public class ArtifactConflict
extends Conflict {
    private static final String CHANGE_ITEM = "Artifact State";
    private static final String ARTIFACT_DELETED = "DELETED";
    private static final String ARTIFACT_MODIFIED = "MODIFIED";
    private final ModificationType sourceModType;
    private final ModificationType destModType;

    public ArtifactConflict(GammaId sourceGamma, GammaId destGamma, ArtifactId artId, TransactionToken toTransactionId, BranchId mergeBranch, BranchToken sourceBranch, BranchToken destBranch, ModificationType sourceModType, ModificationType destModType, long artTypeId) {
        super(sourceGamma, destGamma, artId, toTransactionId, null, mergeBranch, sourceBranch, destBranch);
        this.sourceModType = sourceModType;
        this.destModType = destModType;
    }

    @Override
    public String getArtifactName() {
        if (this.sourceModType.isDeleted()) {
            return this.getDestArtifact().getName();
        }
        return this.getSourceArtifact().getName();
    }

    @Override
    public boolean clearValue() {
        return false;
    }

    @Override
    public ConflictStatus computeStatus() {
        return super.computeStatus(this.getObjectId(), ConflictStatus.INFORMATIONAL);
    }

    @Override
    public Id getObjectId() {
        return this.getArtId();
    }

    @Override
    public String getChangeItem() {
        return CHANGE_ITEM;
    }

    @Override
    public ConflictType getConflictType() {
        return ConflictType.ARTIFACT;
    }

    @Override
    public String getDestDisplayData() {
        return this.destModType.isDeleted() ? ARTIFACT_DELETED : ARTIFACT_MODIFIED;
    }

    @Override
    public String getMergeDisplayData() {
        return "";
    }

    protected Object getMergeValue() {
        return this.getArtifact();
    }

    @Override
    public String getSourceDisplayData() {
        return this.sourceModType.isDeleted() ? ARTIFACT_DELETED : ARTIFACT_MODIFIED;
    }

    @Override
    public boolean mergeEqualsDestination() {
        return this.getDestArtifact().equals(this.getMergeValue());
    }

    @Override
    public boolean mergeEqualsSource() {
        return this.getSourceArtifact().equals(this.getMergeValue());
    }

    @Override
    public boolean setToDest(SkynetTransaction transaction) {
        return this.setToDest();
    }

    @Override
    public boolean setToDest() {
        return false;
    }

    @Override
    public boolean setToSource(SkynetTransaction transaction) {
        return this.setToSource();
    }

    @Override
    public boolean setToSource() {
        return false;
    }

    @Override
    public boolean sourceEqualsDestination() {
        return false;
    }

    @Override
    public GammaId getMergeGammaId() throws BranchMergeException {
        throw new BranchMergeException("Artifact Conflicts can not be handled they must be reverted on the Source Branch", new Object[0]);
    }

    @Override
    public boolean applyPreviousMerge(BranchId mergeBranchId, BranchId destBranchId) {
        return false;
    }
}

