/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.change;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.skynet.core.change.ArtifactWasIsLazyProvider;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public final class AttributeChange
extends Change {
    private static final ChangeType changeType = ChangeType.Attribute;
    private String isValue;
    private final String isUri;
    private String wasValue;
    private final String wasUri;
    private final AttributeId attrId;
    private final AttributeTypeToken attributeType;
    private final ModificationType artModType;
    private final ArtifactWasIsLazyProvider wasIsProvider;

    public AttributeChange(BranchId branch, GammaId sourceGamma, ArtifactId artId, TransactionDelta txDelta, ModificationType modType, String isValue, String isUri, String wasValue, String wasUri, AttributeId attrId, AttributeTypeToken attributeType, ModificationType artModType, boolean isHistorical, Artifact changeArtifact, ArtifactDelta artifactDelta) {
        this(branch, sourceGamma, artId, txDelta, modType, isValue, isUri, wasValue, wasUri, null, attrId, attributeType, artModType, isHistorical, changeArtifact, artifactDelta);
    }

    public AttributeChange(BranchId branch, GammaId sourceGamma, ArtifactId artId, TransactionDelta txDelta, ModificationType modType, ArtifactWasIsLazyProvider wasIsProvider, AttributeId attrId, AttributeTypeToken attributeType, ModificationType artModType, boolean isHistorical, Artifact changeArtifact, ArtifactDelta artifactDelta) {
        this(branch, sourceGamma, artId, txDelta, modType, null, null, null, null, wasIsProvider, attrId, attributeType, artModType, isHistorical, changeArtifact, artifactDelta);
    }

    public AttributeChange(BranchId branch, GammaId sourceGamma, ArtifactId artId, TransactionDelta txDelta, ModificationType modType, String isValue, String isUri, String wasValue, String wasUri, ArtifactWasIsLazyProvider wasIsProvider, AttributeId attrId, AttributeTypeToken attributeType, ModificationType artModType, boolean isHistorical, Artifact changeArtifact, ArtifactDelta artifactDelta) {
        super(branch, sourceGamma, artId, txDelta, modType, isHistorical, changeArtifact, artifactDelta);
        this.isValue = isValue;
        this.wasValue = wasValue;
        this.wasIsProvider = wasIsProvider;
        this.attrId = attrId;
        this.attributeType = attributeType;
        this.artModType = artModType;
        this.isUri = isUri;
        this.wasUri = wasUri;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AttributeChange) {
            AttributeChange change = (AttributeChange)obj;
            return super.equals(obj) && change.getArtId() == this.getArtId() && change.getArtModType() == this.getArtModType() && change.getAttrId() == this.getAttrId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 7 * super.hashCode();
        hashCode += this.getAttributeType() != null ? 7 * this.getAttributeType().hashCode() : 0;
        hashCode += this.getArtModType() != null ? 7 * this.getArtModType().hashCode() : 0;
        return hashCode += 7 * this.getAttrId().hashCode();
    }

    public AttributeId getAttrId() {
        return this.attrId;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    @Override
    public String getName() {
        return this.getArtifactName();
    }

    @Override
    public String getNameOrToken() {
        return this.getArtifactNameOrToken();
    }

    @Override
    public String getItemTypeName() {
        return this.getAttributeType().getName();
    }

    @Override
    public String getItemKind() {
        return "Attribute";
    }

    @Override
    public String getIsValue() {
        if (this.isValue == null && this.wasIsProvider != null) {
            this.isValue = this.wasIsProvider.getIsValue();
        }
        return this.isValue != null ? this.isValue : "";
    }

    @Override
    public String getWasValue() {
        if (this.wasValue == null && this.wasIsProvider != null) {
            this.wasValue = this.wasIsProvider.getWasValue();
        }
        return this.wasValue != null ? this.wasValue : "";
    }

    public Attribute<?> getAttribute() {
        List<Attribute<?>> attributes = this.getChangeArtifact().getAttributes(true);
        for (Attribute<?> attribute : attributes) {
            if (!attribute.getId().equals(this.attrId.getId())) continue;
            return attribute;
        }
        throw new AttributeDoesNotExist("Attribute %s could not be found on artifact %s on branch %s", new Object[]{this.attrId, this.getArtId(), this.getBranch()});
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        Object toReturn = super.getAdapter(type);
        if (toReturn == null) {
            try {
                Attribute<?> attr = this.getAttribute();
                if (type.isInstance(attr)) {
                    toReturn = attr;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return toReturn;
    }

    public ModificationType getArtModType() {
        return this.artModType;
    }

    @Override
    public Id getItemTypeId() {
        return this.getAttributeType();
    }

    public AttributeId getItemId() {
        return this.attrId;
    }

    @Override
    public ChangeType getChangeType() {
        return changeType;
    }

    public String getWasUri() {
        return this.wasUri;
    }

    public void setWasValue(String wasValue) {
        this.wasValue = wasValue;
    }

    public String getIsUri() {
        return this.isUri;
    }
}

