/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.attribute.BinaryAttribute;

public final class CompressedContentAttribute
extends BinaryAttribute<InputStream> {
    public InputStream getValue() {
        return Lib.byteBufferToInputStream((ByteBuffer)this.getAttributeDataProvider().getValueAsBytes());
    }

    @Override
    protected boolean subClassSetValue(InputStream value) {
        return this.setValueFromInputStream(value);
    }

    @Override
    public boolean setValueFromInputStream(InputStream value) {
        boolean response = false;
        try {
            byte[] data = Lib.inputStreamToBytes((InputStream)value);
            response = this.getAttributeDataProvider().setValue(ByteBuffer.wrap(data));
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        if (response) {
            this.markAsNewOrChanged();
        }
        return response;
    }

    @Override
    public InputStream convertStringToValue(String value) {
        try {
            return Lib.stringToInputStream((String)value);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    @Override
    protected void uponInitialize() {
        this.getAttributeDataProvider().setDisplayableString(this.getAttributeType().getName());
    }
}

