/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public final class ArtifactHierarchyComparator
implements Comparator<Artifact> {
    private final Map<Long, List<Artifact>> parentToChildrenCache = new HashMap<Long, List<Artifact>>();

    @Override
    public int compare(Artifact art1, Artifact art2) {
        try {
            int[] set2;
            int length2;
            int[] set1;
            int length1;
            int size;
            String paragraph2;
            int toReturn = 0;
            String paragraph1 = art1.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, "");
            if (paragraph1.isEmpty()) {
                paragraph1 = this.getHierarchyPosition(art1);
            }
            if ((paragraph2 = art2.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, "")).isEmpty()) {
                paragraph2 = this.getHierarchyPosition(art2);
            }
            int n = size = (length1 = (set1 = this.getParagraphIndices(paragraph1)).length) < (length2 = (set2 = this.getParagraphIndices(paragraph2)).length) ? length1 : length2;
            if (size == 0 && length1 != length2) {
                toReturn = length1 < length2 ? -1 : 1;
            } else {
                int index = 0;
                while (index < size) {
                    toReturn = Integer.compare(set1[index], set2[index]);
                    if (toReturn != 0) break;
                    ++index;
                }
                if (toReturn == 0) {
                    toReturn = length1 < length2 ? -1 : 1;
                }
            }
            return toReturn;
        }
        catch (Exception ex) {
            OseeLog.log(this.getClass(), (Level)Level.SEVERE, (Throwable)ex);
            return 1;
        }
    }

    public String getHierarchyPosition(Artifact art1) {
        Artifact artifactCursor = art1;
        StringBuilder builder = new StringBuilder(20);
        while (artifactCursor.notEqual((Id)CoreArtifactTokens.DefaultHierarchyRoot)) {
            Artifact parent = null;
            try {
                parent = artifactCursor.getParent();
            }
            catch (OseeCoreException oseeCoreException) {
                return "0";
            }
            if (parent == null) {
                return "0";
            }
            builder.insert(0, String.valueOf(this.getPosition(artifactCursor)) + ".");
            artifactCursor = parent;
        }
        return builder.substring(0, builder.length() - 1);
    }

    private int getPosition(Artifact artifact) {
        int index;
        Artifact parent = artifact.getParent();
        List<Artifact> children = this.parentToChildrenCache.get(parent.getId());
        if (children == null) {
            children = parent.getChildren();
            this.parentToChildrenCache.put(parent.getId(), children);
        }
        if ((index = 1 + children.indexOf((Object)artifact)) > 0) {
            return index;
        }
        throw new OseeStateException("[%s] is expected to be a child of [%s]", new Object[]{artifact, parent});
    }

    private int[] getParagraphIndices(String paragraph) {
        int[] paragraphs;
        if (Strings.isValid((String)paragraph)) {
            String[] values = paragraph.split("\\.");
            paragraphs = new int[values.length];
            int index = 0;
            while (index < values.length) {
                paragraphs[index] = Integer.parseInt(values[index].replace("-", ""));
                ++index;
            }
        } else {
            paragraphs = new int[]{};
        }
        return paragraphs;
    }
}

