/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.TextFileReader;
import org.hsqldb.persist.TextFileSettings;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;

public class TextCache
extends DataFileCache {
    TextFileSettings textFileSettings;
    protected String header;
    protected Table table;
    private LongKeyHashMap uncommittedCache;
    HsqlByteArrayOutputStream buffer = new HsqlByteArrayOutputStream(128);

    TextCache(Table table, String string) {
        super(table.database, string);
        this.table = table;
        this.uncommittedCache = new LongKeyHashMap();
    }

    @Override
    protected void initParams(Database database, String string) {
        this.database = database;
        this.fa = FileUtil.getFileUtil();
        this.textFileSettings = new TextFileSettings(database, string);
        this.dataFileName = this.textFileSettings.getFileName();
        if (this.dataFileName == null) {
            throw Error.error(301);
        }
        this.dataFileName = ((FileUtil)this.fa).canonicalOrAbsolutePath(this.dataFileName);
        this.maxCacheRows = this.textFileSettings.getMaxCacheRows();
        this.maxCacheBytes = this.textFileSettings.getMaxCacheBytes();
        this.maxDataFileSize = Integer.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.dataFileScale = 1;
    }

    @Override
    protected void initBuffers() {
        if (this.textFileSettings.isQuoted || this.textFileSettings.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.textFileSettings.fs, this.textFileSettings.vs, this.textFileSettings.lvs, this.textFileSettings.isAllQuoted);
            this.rowOut = new RowOutputTextQuoted(this.textFileSettings.fs, this.textFileSettings.vs, this.textFileSettings.lvs, this.textFileSettings.isAllQuoted, this.textFileSettings.stringEncoding);
        } else {
            this.rowIn = new RowInputText(this.textFileSettings.fs, this.textFileSettings.vs, this.textFileSettings.lvs, false);
            this.rowOut = new RowOutputText(this.textFileSettings.fs, this.textFileSettings.vs, this.textFileSettings.lvs, false, this.textFileSettings.stringEncoding);
        }
    }

    @Override
    public void open(boolean bl) {
        this.fileFreePosition = 0L;
        try {
            int n = this.database.getType() == "res:" ? 2 : 5;
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName, bl, n);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > Integer.MAX_VALUE) {
                throw Error.error(468);
            }
            this.initBuffers();
            this.freeBlocks = new DataFileBlockManager(0, this.dataFileScale, 0, 0L);
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 42, new Object[]{throwable.toString(), this.dataFileName});
        }
        this.cacheReadonly = bl;
    }

    void reopen() {
        this.open(this.cacheReadonly);
    }

    @Override
    public void close(boolean bl) {
        if (this.dataFile == null) {
            return;
        }
        this.writeLock.lock();
        try {
            this.cache.saveAll();
            boolean bl2 = this.dataFile.length() <= (long)TextFileSettings.NL.length();
            this.dataFile.synch();
            this.dataFile.close();
            this.dataFile = null;
            if (bl2 && !this.cacheReadonly) {
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
            this.uncommittedCache.clear();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 43, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void purge() {
        this.writeLock.lock();
        try {
            this.uncommittedCache.clear();
            if (this.cacheReadonly) {
                this.close(false);
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.getFileUtil().delete(this.dataFileName);
            }
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 44, new Object[]{throwable.toString(), this.dataFileName});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    long setFilePos(CachedObject cachedObject) {
        int n = cachedObject.getStorageSize();
        long l = this.fileFreePosition + (long)n;
        if (l > this.maxDataFileSize) {
            this.database.logger.logSevereEvent("data file reached maximum size " + this.dataFileName, null);
            throw Error.error(468);
        }
        long l2 = this.fileFreePosition;
        cachedObject.setPos(l2);
        this.clearRowImage(cachedObject);
        this.fileFreePosition = l;
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(long l, PersistentStore persistentStore) {
        this.writeLock.lock();
        try {
            CachedObject cachedObject = (CachedObject)this.uncommittedCache.remove(l);
            if (cachedObject != null) {
                return;
            }
            cachedObject = this.cache.release(l);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePersistence(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.clearRowImage(cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearRowImage(CachedObject cachedObject) {
        try {
            int n = cachedObject.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
            this.rowOut.reset();
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = this.rowOut.getOutputStream();
            hsqlByteArrayOutputStream.fill(32, n);
            hsqlByteArrayOutputStream.write(ScriptWriterText.BYTES_LINE_SEP);
            this.dataFile.seek(cachedObject.getPos());
            this.dataFile.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            throw Error.runtimeError(201, iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInit(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.cache.put(cachedObject.getPos(), cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.setFilePos(cachedObject);
            this.uncommittedCache.put(cachedObject.getPos(), cachedObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject get(CachedObject cachedObject, PersistentStore persistentStore, boolean bl) {
        if (cachedObject == null) {
            return null;
        }
        this.writeLock.lock();
        try {
            CachedObject cachedObject2 = this.cache.get(cachedObject.getPos());
            if (cachedObject2 != null) {
                CachedObject cachedObject3 = cachedObject;
                return cachedObject3;
            }
            this.buffer.reset(cachedObject.getStorageSize());
            this.dataFile.seek(cachedObject.getPos());
            this.dataFile.read(this.buffer.getBuffer(), 0, cachedObject.getStorageSize());
            this.buffer.setSize(cachedObject.getStorageSize());
            String string = this.buffer.toString(this.textFileSettings.stringEncoding);
            ((RowInputText)this.rowIn).setSource(string, cachedObject.getPos(), this.buffer.size());
            persistentStore.get(cachedObject, this.rowIn);
            this.cache.put(cachedObject.getPos(), cachedObject);
            CachedObject cachedObject4 = cachedObject;
            return cachedObject4;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(long l, PersistentStore persistentStore, boolean bl) {
        throw Error.runtimeError(201, "TextCache");
    }

    @Override
    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) {
    }

    @Override
    public void saveRow(CachedObject cachedObject) {
        this.writeLock.lock();
        try {
            this.setFileModified();
            this.saveRowNoLock(cachedObject);
            this.uncommittedCache.remove(cachedObject.getPos());
            this.cache.put(cachedObject.getPos(), cachedObject);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("saveRow failed", throwable);
            throw Error.error(466, throwable);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeaderInitialise(String string) {
        this.header = string;
    }

    public void setHeader(String string) {
        if (this.textFileSettings.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(string);
                this.header = string;
            }
            catch (HsqlException hsqlException) {
                throw new HsqlException(hsqlException, Error.getMessage(467), 467);
            }
            return;
        }
        throw Error.error(486);
    }

    private void writeHeader(String string) {
        try {
            byte[] byArray = null;
            String string2 = string + TextFileSettings.NL;
            try {
                byArray = string2.getBytes(this.textFileSettings.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
            this.dataFile.seek(0L);
            this.dataFile.write(byArray, 0, byArray.length);
            this.fileFreePosition = byArray.length;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    public TextFileSettings getTextFileSettings() {
        return this.textFileSettings;
    }

    public boolean isIgnoreFirstLine() {
        return this.textFileSettings.ignoreFirst;
    }

    @Override
    protected void setFileModified() {
        this.fileModified = true;
    }

    public TextFileReader getTextFileReader() {
        return new TextFileReader(this.dataFile, this.textFileSettings, this.rowIn, this.cacheReadonly);
    }
}

