/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileArchiver;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.ScriptRunner;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptReaderDecode;
import org.hsqldb.scriptio.ScriptReaderText;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterEncode;
import org.hsqldb.scriptio.ScriptWriterText;

public class Log {
    private HsqlDatabaseProperties properties;
    private String fileName;
    private Database database;
    private FileAccess fa;
    ScriptWriterBase dbLogWriter;
    private String scriptFileName;
    private String logFileName;
    private boolean filesReadOnly;
    private long maxLogSize;
    private int writeDelay;
    private DataFileCache cache;

    Log(Database database) {
        this.database = database;
        this.fa = database.logger.getFileAccess();
        this.fileName = database.getPath();
        this.properties = database.getProperties();
    }

    void initParams() {
        this.maxLogSize = (long)this.database.logger.propLogSize * 1024L * 1024L;
        this.writeDelay = this.database.logger.propWriteDelay;
        this.filesReadOnly = this.database.isFilesReadOnly();
        this.scriptFileName = this.fileName + ".script";
        this.logFileName = this.fileName + ".log";
    }

    void open() {
        this.initParams();
        int n = this.properties.getDBModified();
        switch (n) {
            case 3: {
                break;
            }
            case 1: {
                this.deleteNewAndOldFiles();
                this.deleteOldTempFiles();
                if (this.properties.isVersion18()) {
                    if (this.fa.isStreamElement(this.scriptFileName)) {
                        this.processScript();
                    } else {
                        this.database.schemaManager.createPublicSchema();
                    }
                    HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.findSchemaHsqlName("PUBLIC");
                    if (hsqlName != null) {
                        this.database.schemaManager.setDefaultSchemaHsqlName(hsqlName);
                    }
                } else {
                    this.processScript();
                }
                this.processLog();
                this.checkpoint();
                break;
            }
            case 2: {
                this.renameNewDataFile();
                this.renameNewBackup();
                this.renameNewScript();
                this.deleteLog();
                this.properties.setDBModified(0);
            }
            case 0: {
                this.processScript();
                if (this.filesReadOnly || !this.isAnyCacheModified()) break;
                this.properties.setDBModified(1);
                this.checkpoint();
            }
        }
        if (!this.filesReadOnly) {
            this.openLog();
            this.properties.setDBModified(1);
        }
    }

    void close(boolean bl) {
        this.closeLog();
        this.deleteOldDataFiles();
        this.deleteOldTempFiles();
        this.deleteTempFileDirectory();
        this.writeScript(bl);
        this.database.logger.closeAllTextCaches(bl);
        if (this.cache != null) {
            this.cache.close(true);
        }
        this.properties.setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
        this.properties.setDBModified(2);
        this.deleteLog();
        if (this.cache != null) {
            if (bl) {
                this.cache.deleteFile();
                this.cache.deleteBackup();
            } else {
                this.cache.backupFile(false);
                this.cache.renameBackupFile();
            }
        }
        this.renameNewScript();
        this.properties.setDBModified(0);
    }

    void shutdown() {
        if (this.cache != null) {
            this.cache.close(false);
        }
        this.database.logger.closeAllTextCaches(false);
        this.closeLog();
    }

    void deleteNewAndOldFiles() {
        this.deleteOldDataFiles();
        this.fa.removeElement(this.fileName + ".data" + ".new");
        this.fa.removeElement(this.fileName + ".backup" + ".new");
        this.fa.removeElement(this.scriptFileName + ".new");
    }

    void deleteBackup() {
        this.fa.removeElement(this.fileName + ".backup");
    }

    void deleteData() {
        this.fa.removeElement(this.fileName + ".data");
    }

    void backupData() throws IOException {
        if (this.database.logger.propIncrementBackup) {
            this.fa.removeElement(this.fileName + ".backup");
            return;
        }
        if (this.fa.isStreamElement(this.fileName + ".data")) {
            FileArchiver.archive(this.fileName + ".data", this.fileName + ".backup" + ".new", this.database.logger.getFileAccess(), 1);
        }
    }

    void renameNewDataFile() {
        if (this.fa.isStreamElement(this.fileName + ".data" + ".new")) {
            this.fa.renameElement(this.fileName + ".data" + ".new", this.fileName + ".data");
        }
    }

    void renameNewBackup() {
        this.fa.removeElement(this.fileName + ".backup");
        if (this.fa.isStreamElement(this.fileName + ".backup" + ".new")) {
            this.fa.renameElement(this.fileName + ".backup" + ".new", this.fileName + ".backup");
        }
    }

    void renameNewScript() {
        if (this.fa.isStreamElement(this.scriptFileName + ".new")) {
            this.fa.renameElement(this.scriptFileName + ".new", this.scriptFileName);
        }
    }

    void deleteNewScript() {
        this.fa.removeElement(this.scriptFileName + ".new");
    }

    void deleteNewBackup() {
        this.fa.removeElement(this.fileName + ".backup" + ".new");
    }

    void deleteLog() {
        this.fa.removeElement(this.logFileName);
    }

    boolean isAnyCacheModified() {
        if (this.cache != null && this.cache.isModified()) {
            return true;
        }
        return this.database.logger.isAnyTextCacheModified();
    }

    void checkpoint() {
        if (this.filesReadOnly) {
            return;
        }
        boolean bl = this.checkpointClose();
        if (bl) {
            this.checkpointReopen();
        } else {
            this.database.logger.logSevereEvent("checkpoint failed - see previous error", null);
        }
    }

    void checkpoint(boolean bl) {
        if (this.filesReadOnly) {
            return;
        }
        if (this.cache == null) {
            bl = false;
        } else if (this.forceDefrag()) {
            bl = true;
        }
        if (bl) {
            try {
                this.defrag();
                this.database.sessionManager.resetLoggedSchemas();
                return;
            }
            catch (Throwable throwable) {
                this.database.logger.logSevereEvent("defrag failed", throwable);
            }
        }
        this.checkpoint();
    }

    boolean checkpointClose() {
        if (this.filesReadOnly) {
            return true;
        }
        this.database.logger.logInfoEvent("checkpointClose start");
        this.synchLog();
        this.database.lobManager.synch();
        this.database.lobManager.deleteUnusedLobs();
        this.deleteOldDataFiles();
        try {
            this.writeScript(false);
        }
        catch (Throwable throwable) {
            this.deleteNewScript();
            this.database.logger.logSevereEvent("checkpoint failed - recovered", throwable);
            return false;
        }
        try {
            if (this.cache != null) {
                this.cache.commitChanges();
                this.cache.backupFile(false);
            }
        }
        catch (Throwable throwable) {
            this.deleteNewScript();
            this.deleteNewBackup();
            try {
                if (!this.cache.isFileOpen()) {
                    this.cache.open(false);
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            this.database.logger.logSevereEvent("checkpoint failed - recovered", throwable);
            return false;
        }
        this.closeLog();
        this.properties.setProperty("hsqldb.script_format", this.database.logger.propScriptFormat);
        this.properties.setDBModified(2);
        this.deleteLog();
        this.renameNewScript();
        this.renameNewBackup();
        try {
            this.properties.setDBModified(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.database.logger.logInfoEvent("checkpointClose end");
        return true;
    }

    boolean checkpointReopen() {
        if (this.filesReadOnly) {
            return true;
        }
        this.database.sessionManager.resetLoggedSchemas();
        try {
            if (this.cache != null) {
                this.cache.openShadowFile();
            }
            if (this.dbLogWriter != null) {
                this.openLog();
            }
            this.properties.setDBModified(1);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public void defrag() {
        if (this.cache.fileFreePosition == (long)this.cache.initialFreePos) {
            return;
        }
        this.database.logger.logInfoEvent("defrag start");
        try {
            this.synchLog();
            this.database.lobManager.synch();
            this.deleteOldDataFiles();
            DataFileDefrag dataFileDefrag = this.cache.defrag();
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("defrag failure", throwable);
            throw Error.error(466, throwable);
        }
        this.database.logger.logInfoEvent("defrag end");
    }

    boolean forceDefrag() {
        long l = (long)this.database.logger.propCacheDefragLimit * this.cache.getFileFreePos() / 100L;
        long l2 = this.cache.freeBlocks.getLostBlocksSize();
        return l > 0L && l2 > l;
    }

    boolean hasCache() {
        return this.cache != null;
    }

    DataFileCache getCache() {
        if (this.cache == null) {
            this.cache = new DataFileCache(this.database, this.fileName);
            this.cache.open(this.filesReadOnly);
        }
        return this.cache;
    }

    void setLogSize(int n) {
        this.maxLogSize = (long)n * 1024L * 1024L;
    }

    int getWriteDelay() {
        return this.writeDelay;
    }

    void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.dbLogWriter != null && this.dbLogWriter.getWriteDelay() != n) {
            this.dbLogWriter.forceSync();
            this.dbLogWriter.stop();
            this.dbLogWriter.setWriteDelay(n);
            this.dbLogWriter.start();
        }
    }

    public void setIncrementBackup(boolean bl) {
        if (this.cache != null) {
            this.cache.setIncrementBackup(bl);
        }
    }

    void writeOtherStatement(Session session, String string) {
        try {
            this.dbLogWriter.writeOtherStatement(session, string);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeInsertStatement(Session session, Row row, Table table) {
        try {
            this.dbLogWriter.writeInsertStatement(session, row, table);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeDeleteStatement(Session session, Table table, Object[] objectArray) {
        try {
            this.dbLogWriter.writeDeleteStatement(session, table, objectArray);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeSequenceStatement(Session session, NumberSequence numberSequence) {
        try {
            this.dbLogWriter.writeSequenceStatement(session, numberSequence);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void writeCommitStatement(Session session) {
        try {
            this.dbLogWriter.writeCommitStatement(session);
        }
        catch (IOException iOException) {
            throw Error.error(452, this.logFileName);
        }
        if (this.maxLogSize > 0L && this.dbLogWriter.size() > this.maxLogSize) {
            this.database.logger.setCheckpointRequired();
        }
    }

    void synchLog() {
        if (this.dbLogWriter != null) {
            this.dbLogWriter.forceSync();
        }
    }

    void openLog() {
        if (this.filesReadOnly) {
            return;
        }
        Crypto crypto = this.database.logger.getCrypto();
        try {
            this.dbLogWriter = crypto == null ? new ScriptWriterText(this.database, this.logFileName, false, false, false) : new ScriptWriterEncode(this.database, this.logFileName, crypto);
            this.dbLogWriter.setWriteDelay(this.writeDelay);
            this.dbLogWriter.start();
        }
        catch (Throwable throwable) {
            throw Error.error(452, this.logFileName);
        }
    }

    synchronized void closeLog() {
        if (this.dbLogWriter != null) {
            this.database.logger.logDetailEvent("log close size: " + this.dbLogWriter.size());
            this.dbLogWriter.close();
        }
    }

    void writeScript(boolean bl) {
        ScriptWriterText scriptWriterText;
        this.deleteNewScript();
        Crypto crypto = this.database.logger.getCrypto();
        if (crypto == null) {
            boolean bl2 = this.database.logger.propScriptFormat == 3;
            scriptWriterText = new ScriptWriterText(this.database, this.scriptFileName + ".new", bl, bl2);
        } else {
            scriptWriterText = new ScriptWriterEncode(this.database, this.scriptFileName + ".new", bl, crypto);
        }
        scriptWriterText.writeAll();
        scriptWriterText.close();
        scriptWriterText = null;
    }

    private void processScript() {
        ScriptReaderBase scriptReaderBase = null;
        try {
            Crypto crypto = this.database.logger.getCrypto();
            if (crypto == null) {
                boolean bl = this.database.logger.propScriptFormat == 3;
                scriptReaderBase = new ScriptReaderText(this.database, this.scriptFileName, bl);
            } else {
                scriptReaderBase = new ScriptReaderDecode(this.database, this.scriptFileName, crypto, false);
            }
            Session session = this.database.sessionManager.getSysSessionForScript(this.database);
            scriptReaderBase.readAll(session);
            scriptReaderBase.close();
        }
        catch (Throwable throwable) {
            if (scriptReaderBase != null) {
                scriptReaderBase.close();
                if (this.cache != null) {
                    this.cache.close(false);
                }
                this.database.logger.closeAllTextCaches(false);
            }
            this.database.logger.logWarningEvent("Script processing failure", throwable);
            if (throwable instanceof HsqlException) {
                throw (HsqlException)throwable;
            }
            if (throwable instanceof IOException) {
                throw Error.error(452, throwable);
            }
            if (throwable instanceof OutOfMemoryError) {
                throw Error.error(460);
            }
            throw Error.error(458, throwable);
        }
    }

    private void processLog() {
        if (this.fa.isStreamElement(this.logFileName)) {
            ScriptRunner.runScript(this.database, this.logFileName);
        }
    }

    void deleteOldDataFiles() {
        if (this.database.logger.isStoredFileAccess()) {
            return;
        }
        try {
            File file = new File(this.database.getCanonicalPath());
            File[] fileArray = file.getParentFile().listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().startsWith(file.getName()) || !fileArray[i].getName().endsWith(".old")) continue;
                fileArray[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteOldTempFiles() {
        try {
            if (this.database.logger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.database.logger.tempDirectoryPath);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void deleteTempFileDirectory() {
        try {
            if (this.database.logger.tempDirectoryPath == null) {
                return;
            }
            File file = new File(this.database.logger.tempDirectoryPath);
            file.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    String getLogFileName() {
        return this.logFileName;
    }
}

