/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.define.ide.blam.operation.FixAttributeOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;
import org.eclipse.ui.progress.UIJob;

public class FixAttributesUIReport
implements FixAttributeOperation.Display {
    @Override
    public void displayReport(String reportName, List<String[]> values) {
        ArrayList<XViewerColumn> columns = new ArrayList<XViewerColumn>();
        this.addColumn(columns, "Branch Name");
        this.addColumn(columns, "Artifact Guid");
        this.addColumn(columns, "Artifact Name");
        this.addColumn(columns, "Attribute Type");
        this.addColumn(columns, "Was Value");
        this.addColumn(columns, "Fixed Value");
        ArrayList<ResultsXViewerRow> rows = new ArrayList<ResultsXViewerRow>();
        for (String[] row : values) {
            rows.add(new ResultsXViewerRow(row));
        }
        ArrayList<IResultsEditorTab> tabs = new ArrayList<IResultsEditorTab>();
        tabs.add((IResultsEditorTab)new ResultsEditorTableTab("Results", columns, rows));
        ReportProvider report = new ReportProvider(reportName, tabs);
        this.openReport(report);
    }

    private void addColumn(List<XViewerColumn> columns, String name) {
        columns.add(new XViewerColumn(name, name, 120, XViewerAlign.Left, true, SortDataType.String, false, ""));
    }

    private void openReport(final ReportProvider report) {
        UIJob job = new UIJob(report.getEditorName()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStatus status;
                try {
                    ResultsEditor.open((IResultsEditorProvider)report);
                    status = Status.OK_STATUS;
                }
                catch (Exception ex) {
                    String message = String.format("Error creating [%s] Report", this.getName());
                    status = new Status(4, "org.eclipse.nebula.widgets.xviewer", message, (Throwable)ex);
                }
                return status;
            }
        };
        Operations.scheduleJob((Job)job, (boolean)true, (int)20, null);
    }

    private static final class ReportProvider
    implements IResultsEditorProvider {
        private final List<IResultsEditorTab> resultsTabs;
        private final String editorName;

        public ReportProvider(String editorName, List<IResultsEditorTab> resultsTabs) {
            this.resultsTabs = resultsTabs;
            this.editorName = editorName;
        }

        public String getEditorName() {
            return this.editorName;
        }

        public List<IResultsEditorTab> getResultsEditorTabs() {
            return this.resultsTabs;
        }
    }
}

