/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.branch.graph.Activator;
import org.eclipse.osee.framework.ui.branch.graph.figure.BranchFigure;
import org.eclipse.osee.framework.ui.branch.graph.figure.FigureFactory;
import org.eclipse.osee.framework.ui.branch.graph.figure.TxFigure;
import org.eclipse.osee.framework.ui.branch.graph.model.BranchModel;
import org.eclipse.osee.framework.ui.branch.graph.model.GraphCache;
import org.eclipse.osee.framework.ui.branch.graph.model.TxModel;
import org.eclipse.osee.framework.ui.branch.graph.utility.GraphOptions;
import org.eclipse.swt.graphics.Color;

public class GraphEditPart
extends AbstractGraphicalEditPart {
    private final GraphicalViewer viewer;
    private final Map<BranchId, BranchFigure> branchFigureMap;
    private final Map<Long, TxModel> txNumberToTxModelMap;
    private final Map<Long, TxFigure> txNumberToTxFigureMap;
    private final HashCollection<ConnectionType, Connection> connectionMap;
    private final HashCollection<Integer, BranchModel> branchesByLevel;
    private final IPreferenceStore preferenceStore;

    public GraphEditPart(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.branchFigureMap = new HashMap<BranchId, BranchFigure>();
        this.txNumberToTxModelMap = new HashMap<Long, TxModel>();
        this.txNumberToTxFigureMap = new HashMap<Long, TxFigure>();
        this.branchesByLevel = new HashCollection();
        this.connectionMap = new HashCollection();
        this.preferenceStore = Activator.getInstance().getPreferenceStore();
    }

    protected void createEditPolicies() {
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        figure.setBackgroundColor(ColorConstants.white);
        figure.setOpaque(true);
        XYLayout layout = new XYLayout();
        figure.setLayoutManager((LayoutManager)layout);
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        FanRouter router = new FanRouter();
        router.setSeparation(20);
        router.setNextRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)figure));
        connLayer.setConnectionRouter((ConnectionRouter)router);
        connLayer.setAntialias(1);
        return figure;
    }

    protected List<BranchModel> getModelChildren() {
        GraphCache graphCache = (GraphCache)this.getModel();
        ArrayList<BranchModel> nodes = new ArrayList<BranchModel>();
        nodes.add(graphCache.getRootModel());
        nodes.addAll(graphCache.getRootModel().getAllChildrenBelow());
        Collections.sort(nodes, new Comparator<BranchModel>(){

            @Override
            public int compare(BranchModel o1, BranchModel o2) {
                int level1 = o1.getDepth();
                int level2 = o2.getDepth();
                int result = new Integer(level1).compareTo(new Integer(level2));
                return result;
            }
        });
        ArrayList<BranchModel> toDraw = new ArrayList<BranchModel>();
        int index = 0;
        while (index < nodes.size()) {
            BranchModel model = (BranchModel)nodes.get(index);
            model.setIndex(index);
            toDraw.add(model);
            this.branchFigureMap.put(model.getBranch(), FigureFactory.createBranchLabelFigure(model));
            this.branchesByLevel.put((Object)model.getDepth(), (Object)model);
            ++index;
        }
        for (TxModel model : graphCache.getTxModels()) {
            BranchModel parent = model.getParentBranchModel();
            if (parent != null && parent.areTxsVisible() && parent.isVisible()) {
                Long txNumber = model.getRevision();
                this.txNumberToTxModelMap.put(txNumber, model);
                this.txNumberToTxFigureMap.put(txNumber, FigureFactory.createTxFigure(model));
                continue;
            }
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Orphan TxModel: [%s]", (Object[])new Object[]{model.toString()});
        }
        this.createTxConnections(toDraw);
        this.createMergedConnections(toDraw);
        this.setConnectionVisibility();
        return toDraw;
    }

    public int getMaxTxForGraphLevel(int graphLevel) {
        int max = Integer.MIN_VALUE;
        Collection models = this.branchesByLevel.getValues((Object)graphLevel);
        if (models != null) {
            for (BranchModel model : models) {
                max = model.areTxsVisible() ? Math.max(model.getTxs().size(), max) : Math.max(3, max);
            }
        }
        return max;
    }

    public int getNumberOfBranchesAtGraphLevel(int graphLevel) {
        Collection collection = this.branchesByLevel.getValues((Object)graphLevel);
        return collection != null ? collection.size() : 0;
    }

    public int getMaxNumberOfBranchesAtAnyLevel() {
        int max = Integer.MIN_VALUE;
        for (Integer level : this.branchesByLevel.keySet()) {
            max = Math.max(max, this.getNumberOfBranchesAtGraphLevel(level));
        }
        return max;
    }

    public BranchFigure getFigure(BranchId branch) {
        return this.branchFigureMap.get(branch);
    }

    public TxFigure getTxFigure(TxModel txModel) {
        return this.txNumberToTxFigureMap.get(txModel.getRevision());
    }

    private void createMergedConnections(Collection<BranchModel> toReturn) {
        for (BranchModel branchNode : toReturn) {
            for (TxModel txModel : branchNode.getTxs()) {
                if (txModel.getMergedTx() == null) continue;
                TxFigure txFigure = this.txNumberToTxFigureMap.get(txModel.getRevision());
                for (TxModel merged : txModel.getMergedTx()) {
                    TxFigure mergedView = this.txNumberToTxFigureMap.get(merged.getRevision());
                    if (mergedView == null) continue;
                    String message = this.getConnectionLabel(merged, txModel);
                    this.connect(ConnectionType.MERGE, this.getFigure(), (IFigure)mergedView, (IFigure)txFigure, message, true, ColorConstants.red);
                }
            }
        }
    }

    private String getConnectionLabel(TxModel source, TxModel target) {
        String sourceName = BranchManager.getBranchShortName((BranchId)source.getParentBranchModel().getBranch());
        String targetName = BranchManager.getBranchShortName((BranchId)target.getParentBranchModel().getBranch());
        return String.format("%s:%s - %s:%s", sourceName, source.getRevision(), targetName, target.getRevision());
    }

    private void createTxConnections(Collection<BranchModel> toReturn) {
        for (BranchModel branchModel : toReturn) {
            Object source;
            TxModel txModel2;
            if (branchModel.areTxsVisible()) {
                for (TxModel txModel2 : branchModel.getTxs()) {
                    TxFigure txFigure = this.getTxFigure(txModel2);
                    boolean connectToBranchLabel = branchModel.getFirstTx().equals(txModel2);
                    String msg = null;
                    if (txModel2.getParentTx() != null) {
                        TxModel parentTxModel = txModel2.getParentTx();
                        TxFigure parent = this.getTxFigure(parentTxModel);
                        if (parent != null) {
                            msg = this.getConnectionLabel(parentTxModel, txModel2);
                            this.connect(ConnectionType.BRANCH_INTERNAL, this.getFigure(), (IFigure)parent, (IFigure)txFigure, msg, false, ColorConstants.black);
                        }
                    } else if (txModel2.getSourceTx() != null) {
                        TxModel sourceTx = txModel2.getSourceTx();
                        TxFigure source2 = this.getTxFigure(sourceTx);
                        if (source2 != null) {
                            msg = this.getConnectionLabel(sourceTx, txModel2);
                            this.connect(ConnectionType.PARENT_CHILD, this.getFigure(), (IFigure)source2, (IFigure)txFigure, msg, true, ColorConstants.blue);
                        }
                    } else {
                        connectToBranchLabel = true;
                    }
                    if (!connectToBranchLabel) continue;
                    BranchFigure branchFigure = this.branchFigureMap.get(branchModel.getBranch());
                    msg = this.getConnectionLabel(branchModel.getFirstTx(), txModel2);
                    this.connect(ConnectionType.BRANCH_INTERNAL, this.getFigure(), (IFigure)branchFigure, (IFigure)txFigure, msg, false, ColorConstants.black);
                }
                continue;
            }
            txModel2 = branchModel.getFirstTx();
            if (txModel2 == null) {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Branch did not have a starting tx [%s]", (Object[])new Object[]{branchModel});
                continue;
            }
            if (txModel2.getSourceTx() == null) continue;
            TxModel sourceTx = txModel2.getSourceTx();
            String msg = this.getConnectionLabel(sourceTx, txModel2);
            BranchFigure branchFigure = this.branchFigureMap.get(branchModel.getBranch());
            if (sourceTx.getParentBranchModel().areTxsVisible()) {
                source = this.getTxFigure(sourceTx);
                if (source == null) continue;
                this.connect(ConnectionType.PARENT_CHILD, this.getFigure(), (IFigure)source, (IFigure)branchFigure, msg, true, ColorConstants.lightBlue);
                continue;
            }
            source = this.branchFigureMap.get(sourceTx.getParentBranchModel().getBranch());
            this.connect(ConnectionType.PARENT_CHILD, this.getFigure(), (IFigure)source, (IFigure)branchFigure, msg, true, ColorConstants.lightBlue);
        }
    }

    private Set<ConnectionType> getFilteredConnectionTypes() {
        int connectLevel = this.preferenceStore.getInt("revision.graph.filter.connections");
        GraphOptions.ConnectionFilter[] filters = GraphOptions.ConnectionFilter.values();
        GraphOptions.ConnectionFilter filter = GraphOptions.ConnectionFilter.NO_FILTER;
        if (connectLevel < filters.length && connectLevel >= 0) {
            filter = filters[connectLevel];
        }
        HashSet<ConnectionType> filtered = new HashSet<ConnectionType>();
        switch (filter) {
            case FILTER_CHILD_BRANCH_CONNECTIONS: {
                filtered.add(ConnectionType.PARENT_CHILD);
                break;
            }
            case FILTER_MERGE_CONNECTIONS: {
                filtered.add(ConnectionType.MERGE);
                break;
            }
            case FILTER_ALL_CONNECTIONS: {
                ConnectionType[] connectionTypeArray = ConnectionType.values();
                int n = connectionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionType connectionType = connectionTypeArray[n2];
                    if (connectionType != ConnectionType.BRANCH_INTERNAL) {
                        filtered.add(connectionType);
                    }
                    ++n2;
                }
                break;
            }
        }
        return filtered;
    }

    public void setConnectionVisibility() {
        Set<ConnectionType> filteredTypes = this.getFilteredConnectionTypes();
        for (ConnectionType connectType : this.connectionMap.keySet()) {
            Collection connections = this.connectionMap.getValues((Object)connectType);
            if (connections == null) continue;
            for (Connection connection : connections) {
                boolean isVisible = false;
                if (!filteredTypes.contains((Object)connectType)) {
                    isVisible = true;
                } else {
                    IFigure source = connection.getSourceAnchor().getOwner();
                    IFigure target = connection.getTargetAnchor().getOwner();
                    isVisible = source instanceof TxFigure && ((TxFigure)source).isSelected() ? true : target instanceof TxFigure && ((TxFigure)target).isSelected();
                }
                connection.setVisible(isVisible);
            }
        }
    }

    public void setTxVisibility() {
        int filterSetting = this.preferenceStore.getInt("revision.graph.show.all.transactions");
        boolean isVisible = GraphOptions.TxFilter.NO_FILTER.ordinal() == filterSetting;
        GraphCache graph = (GraphCache)this.getModel();
        for (BranchModel model : graph.getBranchModels()) {
            model.setTxsVisible(isVisible);
        }
        this.viewer.setContents((Object)graph);
    }

    private void connect(ConnectionType connectType, IFigure contents, IFigure source, IFigure target, String toolTip, boolean hasEndPoint, Color color) {
        PolylineConnection connection = FigureFactory.createConnection(this.getFigure(), source, target, toolTip, hasEndPoint, color);
        ConnectionMouseListener listener = new ConnectionMouseListener(connection);
        connection.addMouseMotionListener((MouseMotionListener)listener);
        connection.addMouseListener((MouseListener)listener);
        connection.setCursor(Cursors.HAND);
        this.connectionMap.put((Object)connectType, (Object)connection);
    }

    private void scrollTo(Rectangle fbounds) {
        this.scrollTo(fbounds.x + fbounds.width / 2, fbounds.y + fbounds.height / 2);
    }

    private void scrollTo(int ax, int ay) {
        Viewport viewport = ((FigureCanvas)this.viewer.getControl()).getViewport();
        Rectangle vbounds = viewport.getBounds();
        Point p = new Point(ax, ay);
        int x = p.x - vbounds.width / 2;
        int y = p.y - vbounds.height / 2;
        viewport.setHorizontalLocation(x);
        viewport.setVerticalLocation(y);
    }

    private void scrollTo(IFigure target) {
        this.scrollTo(target.getBounds());
    }

    private final class ConnectionMouseListener
    implements MouseMotionListener,
    MouseListener {
        private final PolylineConnection connection;

        public ConnectionMouseListener(PolylineConnection connection) {
            this.connection = connection;
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
            this.connection.setLineWidth(1);
        }

        public void mouseHover(MouseEvent event) {
            this.connection.setLineWidth(3);
        }

        public void mouseMoved(MouseEvent event) {
        }

        public void mouseDoubleClicked(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            EditPart editPart;
            TxFigure txFigure = (TxFigure)this.connection.getTargetAnchor().getOwner();
            GraphEditPart.this.scrollTo((IFigure)txFigure);
            Map map = GraphEditPart.this.viewer.getEditPartRegistry();
            TxModel txModel = (TxModel)GraphEditPart.this.txNumberToTxModelMap.get(txFigure.getTxNumber());
            if (txModel != null && (editPart = (EditPart)map.get(txModel)) != null) {
                GraphEditPart.this.viewer.select(editPart);
            }
        }

        public void mouseReleased(MouseEvent event) {
        }
    }

    private static enum ConnectionType {
        BRANCH_INTERNAL,
        PARENT_CHILD,
        MERGE;

    }
}

