/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ActivityLogEndpoint;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ActivityTypeId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.internal.UiPluginConstants;
import org.eclipse.osee.framework.ui.plugin.xnavigate.FilteredTreePlus;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateMenuItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.NavigateItemCollector;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateContentProvider;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateLabelProvider;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateViewFilter;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class XNavigateComposite
extends Composite {
    private final ToolTipDisplayListener tableListener = new ToolTipDisplayListener();
    protected final NavigateItemCollector navigateItemCollector;
    protected Browser browser;
    protected FilteredTreePlus filteredTree;
    private final String filterText;

    public XNavigateComposite(NavigateItemCollector navigateItemCollector, Composite parent, int style) {
        this(navigateItemCollector, parent, style, null);
    }

    public XNavigateComposite(NavigateItemCollector navigateItemCollector, Composite parent, int style, String filterText) {
        super(parent, style);
        this.navigateItemCollector = navigateItemCollector;
        this.filterText = filterText;
        this.setLayout((Layout)new GridLayout());
        this.createControl();
    }

    private void createControl() {
        this.filteredTree = new FilteredTreePlus(this, 2052, new XNavigateViewFilter(this.filterText), true);
        if (Strings.isValid((String)this.filterText)) {
            this.filteredTree.setFilterTextPlus(this.filterText);
        }
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new XNavigateContentProvider());
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new XNavigateLabelProvider());
        this.filteredTree.getViewer().getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.filteredTree.getViewer().getTree().setToolTipText("");
        this.filteredTree.getViewer().getTree().addListener(12, (Listener)this.tableListener);
        this.filteredTree.getViewer().getTree().addListener(1, (Listener)this.tableListener);
        this.filteredTree.getViewer().getTree().addListener(5, (Listener)this.tableListener);
        this.filteredTree.getViewer().getTree().addListener(32, (Listener)this.tableListener);
        this.filteredTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    XNavigateComposite.this.handleDoubleClick();
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(UiPluginConstants.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
        this.filteredTree.getViewer().getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    try {
                        XNavigateComposite.this.handleDoubleClick();
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(UiPluginConstants.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager menuManager = (MenuManager)manager;
                menuManager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.addMenu(this.filteredTree.getViewer());
    }

    private void addMenu(final TreeViewer treeViewer) {
        final Menu menu = new Menu((Decorations)treeViewer.getTree().getShell(), 8);
        treeViewer.getTree().setMenu(menu);
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                MenuItem[] menuItems = menu.getItems();
                int i = 0;
                while (i < menuItems.length) {
                    menuItems[i].dispose();
                    ++i;
                }
                TreeItem[] treeItems = treeViewer.getTree().getSelection();
                TreeItem selectedTreeItem = treeItems[0];
                if (selectedTreeItem.getData() instanceof XNavigateItem) {
                    XNavigateItem navItem = (XNavigateItem)selectedTreeItem.getData();
                    for (IXNavigateMenuItem menuItem : navItem.getMenuItems()) {
                        menuItem.addMenuItems(menu, selectedTreeItem);
                    }
                }
            }
        });
    }

    protected void disposeTooltip() {
        this.tableListener.disposeTooltip();
    }

    protected void handleDoubleClick() {
        IStructuredSelection sel = (IStructuredSelection)this.filteredTree.getViewer().getSelection();
        if (!sel.iterator().hasNext()) {
            return;
        }
        XNavigateItem item = (XNavigateItem)sel.iterator().next();
        this.handleDoubleClick(item, new TableLoadOption[0]);
    }

    protected void handleDoubleClick(XNavigateItem item, TableLoadOption ... tableLoadOptions) {
        this.disposeTooltip();
        if (item.getChildren().size() > 0) {
            this.filteredTree.getViewer().setExpandedState((Object)item, true);
        } else {
            try {
                long uuid = Lib.generateUuid();
                ActivityLogEndpoint activityEp = ((OseeClient)OsgiUtil.getService(((Object)((Object)this)).getClass(), OseeClient.class)).getActivityLogEndpoint();
                activityEp.createEntry((ActivityTypeId)CoreActivityTypes.XNAVIGATEITEM, Long.valueOf(uuid), ActivityLog.INITIAL_STATUS, item.getName());
                item.run(tableLoadOptions);
                activityEp.createEntry((ActivityTypeId)CoreActivityTypes.XNAVIGATEITEM, Long.valueOf(uuid), ActivityLog.COMPLETE_STATUS, item.getName());
            }
            catch (Exception ex) {
                OseeLog.log(UiPluginConstants.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }

    public abstract Collection<? extends ArtifactId> getCurrUserUserGroups();

    public void refresh() {
        ElapsedTime time = new ElapsedTime("Navigate Items - load", false);
        final List<XNavigateItem> items = this.navigateItemCollector.getComputedNavItems(this.getCurrUserUserGroups());
        time.end();
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ElapsedTime time = new ElapsedTime("Navigate Items - setInput", false);
                XNavigateComposite.this.filteredTree.getViewer().setInput((Object)items);
                time.end();
            }
        });
    }

    public FilteredTreePlus getFilteredTree() {
        return this.filteredTree;
    }

    public List<XNavigateItem> getInput() {
        Object input = this.filteredTree.getViewer().getInput();
        return (List)input;
    }

    private class LabelListener
    implements Listener {
        private LabelListener() {
        }

        public void handleEvent(Event event) {
            Label label = (Label)event.widget;
            Shell shell = label.getShell();
            switch (event.type) {
                case 3: {
                    Event e = new Event();
                    e.item = (TableItem)label.getData("_TABLEITEM");
                    XNavigateComposite.this.filteredTree.getViewer().getTree().notifyListeners(13, e);
                    shell.dispose();
                    XNavigateComposite.this.filteredTree.getViewer().getTree().setFocus();
                    break;
                }
                case 7: {
                    shell.dispose();
                }
            }
        }
    }

    public static enum TableLoadOption {
        None,
        ForcePend,
        ClearLastSearchItem,
        NoUI,
        DontCopySearchItem;

    }

    private class ToolTipDisplayListener
    implements Listener {
        private final LabelListener labelListener;
        private Shell tip;
        private Label label;

        private ToolTipDisplayListener() {
            this.labelListener = new LabelListener();
        }

        protected void disposeTooltip() {
            if (Widgets.isAccessible((Widget)this.tip)) {
                this.tip.dispose();
            }
            this.tip = null;
            this.label = null;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: 
                case 5: 
                case 12: {
                    if (this.tip == null) break;
                    this.disposeTooltip();
                    break;
                }
                case 32: {
                    XNavigateItem navItem;
                    String description;
                    Tree tree = XNavigateComposite.this.filteredTree.getViewer().getTree();
                    TreeItem item = tree.getItem(new Point(event.x, event.y));
                    if (item == null || !(item.getData() instanceof XNavigateItem) || !Strings.isValid((String)(description = (navItem = (XNavigateItem)item.getData()).getDescription()))) break;
                    this.disposeTooltip();
                    this.tip = new Shell(Displays.getActiveShell(), 540676);
                    this.tip.setBackground(Displays.getSystemColor((int)29));
                    FillLayout layout = new FillLayout();
                    layout.marginWidth = 2;
                    this.tip.setLayout((Layout)layout);
                    this.label = new Label((Composite)this.tip, 0);
                    this.label.setForeground(Displays.getSystemColor((int)28));
                    this.label.setBackground(Displays.getSystemColor((int)29));
                    this.label.setData("_TABLEITEM", (Object)item);
                    this.label.setText(String.format("%s\n\n%s", item.getText(), description));
                    this.label.addListener(7, (Listener)this.labelListener);
                    this.label.addListener(3, (Listener)this.labelListener);
                    Point size = this.tip.computeSize(-1, -1);
                    Rectangle rect = item.getBounds(0);
                    Point pt = tree.toDisplay(rect.x, rect.y);
                    this.tip.setBounds(pt.x, pt.y + 15, size.x, size.y);
                    this.tip.setVisible(true);
                }
            }
        }
    }
}

