/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.internal.fields;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.AbstractOseeField;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public final class ArtifactTypeAttributesField
extends AbstractOseeField<Map<BranchId, Collection<AttributeTypeToken>>> {
    private final Map<BranchId, Collection<AttributeTypeToken>> validityMap;

    public ArtifactTypeAttributesField(Map<BranchId, Collection<AttributeTypeToken>> validityMap) {
        this.validityMap = validityMap;
    }

    @Override
    public Map<BranchId, Collection<AttributeTypeToken>> get() {
        return new HashMap<BranchId, Collection<AttributeTypeToken>>(this.validityMap);
    }

    public void put(BranchId branch, Collection<AttributeTypeToken> attributes) {
        Collection<AttributeTypeToken> current = this.validityMap.get(branch);
        this.validityMap.put(branch, attributes);
        if (Compare.isDifferent(current, attributes)) {
            this.isDirty = true;
        }
    }

    @Override
    public void set(Map<BranchId, Collection<AttributeTypeToken>> attributeTypeMap) {
        Conditions.checkNotNull(attributeTypeMap, (String)"attribute type map input");
        boolean isDifferent = Compare.isDifferent((Object)this.get(), attributeTypeMap);
        if (isDifferent) {
            this.validityMap.clear();
            for (Map.Entry<BranchId, Collection<AttributeTypeToken>> entry : attributeTypeMap.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
        this.isDirty |= isDifferent;
    }

    private void set(BranchId branch, Collection<AttributeTypeToken> attributeTypes) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNull(attributeTypes, (String)"attribute types list");
        if (attributeTypes.isEmpty()) {
            this.validityMap.remove(branch);
        } else {
            Collection<AttributeTypeToken> cachedItems = this.validityMap.get(branch);
            if (cachedItems == null) {
                cachedItems = new HashSet<AttributeTypeToken>(attributeTypes);
                this.validityMap.put(branch, cachedItems);
            } else {
                cachedItems.clear();
                cachedItems.addAll(attributeTypes);
            }
        }
    }
}

