/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.server.task;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import org.eclipse.osee.framework.plugin.core.server.task.Command;
import org.eclipse.osee.framework.plugin.core.server.task.Parameter;

public class TaskServerThread
implements Runnable {
    private final int magicNumber;
    private Socket socket = null;
    private ObjectInputStream inFromClient;
    private PrintWriter out;
    private final HashMap<Integer, Command> commands;
    private final boolean running;

    public TaskServerThread(int magicNumber, Socket socket) {
        this.socket = socket;
        this.magicNumber = magicNumber;
        this.commands = new HashMap();
        this.running = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            this.inFromClient = new ObjectInputStream(this.socket.getInputStream());
            int code = this.inFromClient.readInt();
            if (code != this.magicNumber) {
                System.out.println("look what you did!");
                return;
            }
            while (true) {
                if (!this.running) {
                    this.inFromClient.close();
                    this.out.close();
                    this.socket.close();
                    return;
                }
                try {
                    int commandId = this.inFromClient.readUnsignedShort();
                    Object[] parameters = this.parseParameters();
                    Command command = this.commands.get(commandId);
                    if (parameters == null) continue;
                    this.sendResultToClient(command.invoke(parameters));
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void sendResultToClient(Object result) {
        if (result == null) {
            return;
        }
    }

    public void registerCommand(int commandId, Command command) {
        this.commands.put(commandId, command);
    }

    private Object[] parseParameters() throws IOException {
        int parametersCount = this.inFromClient.readUnsignedByte();
        if (parametersCount == 0) {
            return null;
        }
        Object[] parameters = new Object[parametersCount];
        int i = 0;
        while (i < parametersCount) {
            parameters[i] = this.readNextParameter();
            ++i;
        }
        return parameters;
    }

    private Object readNextParameter() throws IOException {
        return this.readNextParameter(Parameter.values()[this.inFromClient.readUnsignedByte()]);
    }

    private Object readNextParameter(Parameter typeId) {
        try {
            switch (typeId) {
                case BOOLEAN: {
                    return this.inFromClient.readBoolean();
                }
                case BYTE: {
                    return this.inFromClient.readByte();
                }
                case SHORT: {
                    return this.inFromClient.readShort();
                }
                case CHAR: {
                    return Character.valueOf(this.inFromClient.readChar());
                }
                case INT: {
                    return this.inFromClient.readInt();
                }
                case LONG: {
                    return this.inFromClient.readLong();
                }
                case FLOAT: {
                    return Float.valueOf(this.inFromClient.readFloat());
                }
                case DOUBLE: {
                    return this.inFromClient.readDouble();
                }
                case STRING: {
                    return this.inFromClient.readUTF();
                }
                case BYTE_ARRAY: {
                    byte[] byteArray = new byte[this.inFromClient.readUnsignedShort()];
                    int i = 0;
                    while (i < byteArray.length) {
                        byteArray[i] = (Byte)this.readNextParameter(Parameter.BYTE);
                        ++i;
                    }
                    return byteArray;
                }
                case SHORT_ARRAY: {
                    short[] shortArray = new short[this.inFromClient.readUnsignedShort()];
                    int i = 0;
                    while (i < shortArray.length) {
                        shortArray[i] = (Short)this.readNextParameter(Parameter.SHORT);
                        ++i;
                    }
                    return shortArray;
                }
                case CHAR_ARRAY: {
                    char[] charArray = new char[this.inFromClient.readUnsignedShort()];
                    int i = 0;
                    while (i < charArray.length) {
                        charArray[i] = ((Character)this.readNextParameter(Parameter.CHAR)).charValue();
                        ++i;
                    }
                    return charArray;
                }
                case INT_ARRAY: {
                    int[] intArray = new int[this.inFromClient.readUnsignedShort()];
                    int i = 0;
                    while (i < intArray.length) {
                        intArray[i] = (Integer)this.readNextParameter(Parameter.INT);
                        ++i;
                    }
                    return intArray;
                }
                case LONG_ARRAY: {
                    long[] longArray = new long[this.inFromClient.readUnsignedShort()];
                    int i = 0;
                    while (i < longArray.length) {
                        longArray[i] = (Long)this.readNextParameter(Parameter.LONG);
                        ++i;
                    }
                    return longArray;
                }
                case FLOAT_ARRAY: {
                    int[] floatArray = new int[this.inFromClient.readUnsignedShort()];
                    int i = 0;
                    while (i < floatArray.length) {
                        floatArray[i] = (Integer)this.readNextParameter(Parameter.INT);
                        ++i;
                    }
                    return floatArray;
                }
                case DOUBLE_ARRAY: {
                    double[] doubleArray = new double[this.inFromClient.readUnsignedShort()];
                    int i = 0;
                    while (i < doubleArray.length) {
                        doubleArray[i] = (Double)this.readNextParameter(Parameter.DOUBLE);
                        ++i;
                    }
                    return doubleArray;
                }
                case STRING_ARRAY: {
                    String[] stringArray = new String[this.inFromClient.readUnsignedShort()];
                    int i = 0;
                    while (i < stringArray.length) {
                        stringArray[i] = (String)this.readNextParameter(Parameter.STRING);
                        ++i;
                    }
                    return stringArray;
                }
            }
            throw new IllegalArgumentException("invalid parameter type id");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

