/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.parser.handlers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.ote.define.internal.Activator;
import org.eclipse.osee.ote.define.parser.IDataListener;
import org.eclipse.osee.ote.define.parser.ISaxElementHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractParseHandler
implements ISaxElementHandler {
    private final Set<IDataListener> listeners = Collections.synchronizedSet(new HashSet());

    protected AbstractParseHandler() {
    }

    @Override
    public void addListener(IDataListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IDataListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void notifyOnDataEvent(String name, String value) {
        for (IDataListener listener : this.listeners) {
            listener.notifyDataEvent(name, value);
        }
    }

    @Override
    public void processSaxChunkCollectorData(String currentLocalName, String xmlData) {
        try {
            Document doc = Jaxp.readXmlDocument((String)xmlData);
            Element root = doc.getDocumentElement();
            if (root != null) {
                this.processSaxChunk(root);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    protected abstract void processSaxChunk(Element var1);
}

