/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.threading.ThreadedWorkerExecutor;
import org.eclipse.osee.framework.core.threading.ThreadedWorkerFactory;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;

public class LinkTestRunToTestScriptOperation {
    private static final String OPERATION_NAME = "Link Test Run to Test Script";
    private final List<Artifact> artifacts;
    private final List<Artifact> unlinked;
    private final List<Artifact> linked;

    public LinkTestRunToTestScriptOperation(Artifact ... artifacts) {
        this.artifacts = Arrays.asList(artifacts);
        this.unlinked = new ArrayList<Artifact>();
        this.linked = new ArrayList<Artifact>();
    }

    public void execute(final IProgressMonitor monitor) {
        monitor.setTaskName(OPERATION_NAME);
        final AtomicInteger count = new AtomicInteger(0);
        ThreadedWorkerFactory<Object> outfileToArtifactFactory = new ThreadedWorkerFactory<Object>(){

            public int getWorkSize() {
                return LinkTestRunToTestScriptOperation.this.artifacts.size();
            }

            public Callable<Object> createWorker(int startIndex, int endIndex) {
                return new LinkTestRunToTestScriptCallable(monitor, LinkTestRunToTestScriptOperation.this.artifacts.subList(startIndex, endIndex), count, LinkTestRunToTestScriptOperation.this.artifacts.size());
            }
        };
        ThreadedWorkerExecutor executor = new ThreadedWorkerExecutor((ThreadedWorkerFactory)outfileToArtifactFactory, true);
        executor.executeWorkersBlocking();
    }

    public Artifact[] getLinkedArtifacts() {
        return this.linked.toArray(new Artifact[this.linked.size()]);
    }

    public Artifact[] getUnlinkedArtifacts() {
        return this.unlinked.toArray(new Artifact[this.unlinked.size()]);
    }

    private class LinkTestRunToTestScriptCallable
    implements Callable<Object> {
        private final IProgressMonitor monitor;
        private final List<Artifact> artifacts;
        private final AtomicInteger count;
        private final int totalSize;

        public LinkTestRunToTestScriptCallable(IProgressMonitor monitor, List<Artifact> artifacts, AtomicInteger count, int totalSize) {
            this.monitor = monitor;
            this.artifacts = artifacts;
            this.count = count;
            this.totalSize = totalSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            for (Artifact testRun : this.artifacts) {
                List list;
                this.monitor.subTask(String.format("Linking [%s] [%s of %s] ", testRun.getName(), this.count.incrementAndGet(), this.totalSize));
                ArtifactTestRunOperator operator = new ArtifactTestRunOperator(testRun);
                try {
                    operator.createTestScriptSoftLink();
                    list = LinkTestRunToTestScriptOperation.this.linked;
                    synchronized (list) {
                        LinkTestRunToTestScriptOperation.this.linked.add(testRun);
                    }
                }
                catch (Exception exception) {
                    list = LinkTestRunToTestScriptOperation.this.unlinked;
                    synchronized (list) {
                        LinkTestRunToTestScriptOperation.this.unlinked.add(testRun);
                    }
                }
                if (this.monitor.isCanceled()) break;
                this.monitor.worked(1);
            }
            return null;
        }
    }
}

