/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationListener;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class RtfDestination {
    protected RtfParser rtfParser = null;
    protected boolean modified = false;
    protected RtfCtrlWordData lastCtrlWord = null;
    private static ArrayList listeners = new ArrayList();

    public RtfDestination() {
        this.rtfParser = null;
    }

    public RtfDestination(RtfParser rtfParser) {
        this.rtfParser = rtfParser;
    }

    public void setParser(RtfParser rtfParser) {
        if (this.rtfParser != null && this.rtfParser.equals(rtfParser)) {
            return;
        }
        this.rtfParser = rtfParser;
    }

    public abstract boolean closeDestination();

    public abstract boolean handleOpeningSubGroup();

    public abstract boolean handleCloseGroup();

    public abstract boolean handleOpenGroup();

    public abstract boolean handleCharacter(int var1);

    public abstract boolean handleControlWord(RtfCtrlWordData var1);

    public abstract void setToDefaults();

    public boolean isModified() {
        return this.modified;
    }

    public boolean addListener(RtfDestinationListener rtfDestinationListener) {
        return listeners.add(rtfDestinationListener);
    }

    public boolean removeListener(RtfDestinationListener rtfDestinationListener) {
        return listeners.remove(rtfDestinationListener);
    }

    protected RtfCtrlWordData beforeCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener rtfDestinationListener = (RtfDestinationListener)iterator.next();
            rtfDestinationListener.beforeCtrlWord(rtfCtrlWordData);
        }
        return null;
    }

    protected RtfCtrlWordData onCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener rtfDestinationListener = (RtfDestinationListener)iterator.next();
            rtfDestinationListener.onCtrlWord(rtfCtrlWordData);
        }
        return null;
    }

    protected RtfCtrlWordData afterCtrlWord(RtfCtrlWordData rtfCtrlWordData) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener rtfDestinationListener = (RtfDestinationListener)iterator.next();
            rtfDestinationListener.afterCtrlWord(rtfCtrlWordData);
        }
        return null;
    }

    protected int beforeCharacter(int n) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener rtfDestinationListener = (RtfDestinationListener)iterator.next();
            rtfDestinationListener.beforeCharacter(n);
        }
        return 0;
    }

    protected int onCharacter(int n) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener rtfDestinationListener = (RtfDestinationListener)iterator.next();
            rtfDestinationListener.onCharacter(n);
        }
        return 0;
    }

    protected int afterCharacter(int n) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener rtfDestinationListener = (RtfDestinationListener)iterator.next();
            rtfDestinationListener.afterCharacter(n);
        }
        return 0;
    }

    protected boolean onOpenGroup() {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener rtfDestinationListener = (RtfDestinationListener)iterator.next();
            rtfDestinationListener.onOpenGroup();
        }
        return true;
    }

    protected boolean onCloseGroup() {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RtfDestinationListener rtfDestinationListener = (RtfDestinationListener)iterator.next();
            rtfDestinationListener.onCloseGroup();
        }
        return true;
    }

    public int getNewTokeniserState() {
        return 5;
    }
}

