/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.notify;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.core.notify.AbstractAtsNotificationService;
import org.eclipse.osee.ats.rest.internal.notify.AtsNotificationEventProcessor;
import org.eclipse.osee.ats.rest.internal.notify.WorkItemNotificationProcessor;
import org.eclipse.osee.ats.rest.internal.notify.email.IAtsEmailService;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class AtsNotificationServiceImpl
extends AbstractAtsNotificationService {
    private AtsNotificationEventProcessor notificationEventProcessor;
    private boolean loggedNotificationDisabled = false;
    private static final List<IAtsEmailService> notifiers = new CopyOnWriteArrayList<IAtsEmailService>();

    public AtsNotificationServiceImpl() {
    }

    public AtsNotificationServiceImpl(AtsApi atsApi) {
        super(atsApi);
    }

    public void addMailService(IAtsEmailService notifier) {
        notifiers.add(notifier);
    }

    public void sendNotifications(final String fromUserEmail, final Collection<String> toUserEmails, final String subject, final String body) {
        if (this.isNotificationsEnabled()) {
            Thread thread = new Thread("ATS Emailer"){

                @Override
                public void run() {
                    for (IAtsEmailService emailService : notifiers) {
                        emailService.sendNotifications(fromUserEmail, toUserEmails, subject, body);
                    }
                }
            };
            thread.start();
        }
    }

    public void sendNotifications(final AtsNotificationCollector notifications) {
        if (this.isNotificationsEnabled()) {
            if (notifiers.isEmpty() || !this.atsApi.getStoreService().isProductionDb()) {
                if (!this.loggedNotificationDisabled) {
                    this.atsApi.getLogger().info("Osee Notification Disabled", new Object[0]);
                    this.loggedNotificationDisabled = true;
                }
            } else {
                if (notifications.isIncludeCancelHyperlink() && !this.atsApi.getWorkItemService().isCancelHyperlinkConfigured()) {
                    throw new OseeArgumentException("Cancel Hyperlink URl not configured", new Object[0]);
                }
                final WorkItemNotificationProcessor workItemNotificationProcessor = new WorkItemNotificationProcessor(this.atsApi.getLogger(), this.atsApi, this.atsApi.getUserService(), this.atsApi.getAttributeResolver());
                Thread thread = new Thread("ATS Notification Sender"){

                    @Override
                    public void run() {
                        super.run();
                        AtsNotificationServiceImpl.this.notificationEventProcessor = new AtsNotificationEventProcessor(workItemNotificationProcessor, AtsNotificationServiceImpl.this.atsApi.getUserService(), AtsNotificationServiceImpl.this.atsApi.getConfigValue("NoReplyEmail"));
                        AtsNotificationServiceImpl.this.notificationEventProcessor.sendNotifications(notifications, notifiers);
                    }
                };
                thread.start();
            }
        }
    }
}

