/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="team")
public class TeamResource
extends AbstractConfigResource {
    public TeamResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.TeamDefinition, atsApi, orcsApi);
    }

    @GET
    @Path(value="{id}/Version")
    @Produces(value={"application/json"})
    public List<String> getVersionNames(@PathParam(value="id") ArtifactId teamId) {
        LinkedList<String> versions = new LinkedList<String>();
        IAtsTeamDefinition teamDef = (IAtsTeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(teamId.getId());
        if (teamDef == null) {
            teamDef = (IAtsTeamDefinition)this.atsApi.getQueryService().getConfigItem(teamId);
        }
        for (IAtsVersion version : this.atsApi.getVersionService().getVersions(teamDef)) {
            versions.add(version.getName());
        }
        return versions;
    }

    @Path(value="{id}/ai")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsActionableItem> getActionableAis(@PathParam(value="id") ArtifactId teamId) {
        IAtsTeamDefinition teamDef = (IAtsTeamDefinition)this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().get(teamId.getId());
        if (teamDef == null) {
            teamDef = (IAtsTeamDefinition)this.atsApi.getQueryService().getConfigItem(teamId);
        }
        if (teamDef != null) {
            List ais = this.atsApi.getActionableItemService().getActiveActionableItemsAndChildren(teamDef);
            Collections.sort(ais, new NamedComparator(SortOrder.ASCENDING));
            return ais;
        }
        return Collections.emptyList();
    }
}

