/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.config.AtsConfigEndpointApi;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.ColumnAlign;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.rest.internal.config.AtsUserServiceServerImpl;
import org.eclipse.osee.ats.rest.internal.config.UpdateAtsConfiguration;
import org.eclipse.osee.ats.rest.internal.config.operation.AtsConfigOperations;
import org.eclipse.osee.ats.rest.internal.demo.AtsDbConfigDemoOp;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthCheckOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactImage;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.result.table.ExampleTableData;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public final class AtsConfigEndpointImpl
implements AtsConfigEndpointApi {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private final ExecutorAdmin executorAdmin;
    private List<ArtifactImage> images;
    private final Runnable getConfigService = new Runnable(){

        @Override
        public void run() {
            AtsConfigEndpointImpl.this.atsApi.getConfigService().getConfigurationsWithPend();
        }
    };

    public AtsConfigEndpointImpl(AtsApi atsApi, OrcsApi orcsApi, ExecutorAdmin executorAdmin) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.executorAdmin = executorAdmin;
    }

    public String requestCacheReload() {
        this.executorAdmin.submit("REST requested ATS configuration cache reload", this.getConfigService);
        return "ATS configuration cache reload request submitted.";
    }

    public AtsConfigurations get() {
        return this.atsApi.getConfigService().getConfigurations();
    }

    public List<ArtifactImage> getArtifactImages() {
        if (this.images == null) {
            this.images = new LinkedList<ArtifactImage>();
            this.images.addAll(AtsArtifactImages.getImages());
            for (ArtifactTypeToken artifactType : AtsArtifactTypes.TeamWorkflow.getAllDescendantTypes()) {
                this.images.add(ArtifactImage.construct((ArtifactTypeToken)artifactType, (String)AtsArtifactImages.AGILE_TASK.getImageName(), (String)AtsArtifactImages.AGILE_TASK.getBaseUrl()));
            }
        }
        return this.images;
    }

    public AtsConfigurations getWithPend() {
        return this.atsApi.getConfigService().getConfigurationsWithPend();
    }

    public AtsUser getUserByLogin(String loginId) {
        AtsUser user = this.atsApi.getConfigService().getUserByLoginId(loginId);
        user.getSavedSearches().clear();
        ArtifactToken userArt = this.atsApi.getQueryService().getArtifact(user.getStoreObject().getId());
        user.getSavedSearches().addAll(this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)userArt, (AttributeTypeToken)CoreAttributeTypes.AtsActionSearch));
        user.getUserGroups().clear();
        for (ArtifactToken userGroup : this.atsApi.getRelationResolver().getRelated((ArtifactId)userArt, CoreRelationTypes.Users_Artifact)) {
            user.getUserGroups().add(userGroup);
        }
        user.setStoreObject(ArtifactToken.valueOf((long)user.getId(), (BranchId)this.atsApi.getAtsBranch()));
        return user;
    }

    @GET
    @Path(value="userid/{userId}")
    @Produces(value={"application/json"})
    public AtsUser getUserByUserId(@PathParam(value="userId") String userId) {
        ArtifactReadable userArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifactFromTypeAndAttribute(CoreArtifactTypes.User, (AttributeTypeToken)CoreAttributeTypes.UserId, userId, (BranchId)CoreBranches.COMMON);
        AtsUser user = AtsUserServiceServerImpl.valueOf(userArt);
        user.getSavedSearches().clear();
        user.getSavedSearches().addAll(this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)userArt, (AttributeTypeToken)CoreAttributeTypes.AtsActionSearch));
        user.getUserGroups().clear();
        for (ArtifactToken userGroup : this.atsApi.getRelationResolver().getRelated((ArtifactId)userArt, CoreRelationTypes.Users_Artifact)) {
            user.getUserGroups().add(userGroup);
        }
        user.setStoreObject(ArtifactToken.valueOf((long)user.getId(), (BranchId)this.atsApi.getAtsBranch()));
        return user;
    }

    public ViewModel getNewSource() {
        return new ViewModel("templates/newConfigBranch.html");
    }

    public XResultData createUpdateConfig() {
        XResultData resultData = new XResultData(false);
        UpdateAtsConfiguration update = new UpdateAtsConfiguration(this.atsApi, this.orcsApi);
        update.createUpdateConfig(resultData);
        if (resultData.isEmpty()) {
            resultData.log("Nothing to update");
        }
        return resultData;
    }

    public List<AtsAttributeValueColumn> generateAttrTypeViews() throws Exception {
        HashMap<String, AttributeTypeToken> idToToken = new HashMap<String, AttributeTypeToken>();
        for (AttributeTypeToken attrType : this.orcsApi.tokenService().getAttributeTypes()) {
            idToToken.put(attrType.getName(), attrType);
        }
        LinkedList sortedIds = new LinkedList();
        sortedIds.addAll(idToToken.keySet());
        Collections.sort(sortedIds);
        LinkedList<AtsAttributeValueColumn> columns = new LinkedList<AtsAttributeValueColumn>();
        for (String id : sortedIds) {
            AttributeTypeToken attrType = (AttributeTypeToken)idToToken.get(id);
            ColumnAlign columnAlign = ColumnAlign.Left;
            SortDataType sortDataType = SortDataType.String;
            int width = 60;
            if (attrType.isEnumerated()) {
                width = 40;
            } else if (attrType.isBoolean()) {
                width = 50;
            } else if (attrType.isInteger()) {
                width = 45;
                sortDataType = SortDataType.Integer;
                columnAlign = ColumnAlign.Center;
            } else if (attrType.isDouble()) {
                width = 40;
                sortDataType = SortDataType.Float;
                columnAlign = ColumnAlign.Center;
            } else if (attrType.isDate()) {
                width = 80;
                sortDataType = SortDataType.Date;
            }
            AtsAttributeValueColumn valueColumn = new AtsAttributeValueColumn();
            valueColumn.setAttrTypeId(attrType.getId().longValue());
            valueColumn.setAttrTypeName(attrType.getName());
            valueColumn.setWidth(width);
            valueColumn.setAlign(columnAlign);
            valueColumn.setVisible(true);
            valueColumn.setSortDataType(sortDataType.name());
            valueColumn.setColumnMultiEdit(true);
            valueColumn.setDescription(attrType.getDescription());
            valueColumn.setNamespace("org.eclipse.osee.ats.WorldXViewer");
            String name = attrType.getName().replaceAll("^.*\\.", "");
            valueColumn.setName(name);
            valueColumn.setId(this.generateId(attrType.getName(), name));
            if (attrType.isBoolean()) {
                valueColumn.setBooleanNotSetShow("");
                valueColumn.setBooleanOnFalseShow("false");
                valueColumn.setBooleanOnTrueShow("true");
            }
            columns.add(valueColumn);
        }
        return columns;
    }

    private String generateId(String id, String name) {
        String cleanName = name.replaceAll("-", " ");
        cleanName = cleanName.replaceAll("\\(", " ");
        cleanName = cleanName.replaceAll("\\)", " ");
        cleanName = cleanName.replaceAll("/", " ");
        cleanName = cleanName.replaceAll(" +", " ");
        cleanName = cleanName.replaceAll("^ ", "");
        String replaceValue = Lib.toCamelCaseFromStringsWithSpaces((String)cleanName);
        String result = id.replaceFirst(Lib.escapeForRegex((String)name), replaceValue);
        return result;
    }

    public XResultData alive() {
        XResultData results = new XResultData();
        results.logf("Alive", new Object[0]);
        return results;
    }

    public XResultData demoDbInit() {
        XResultData rd = new XResultData();
        try {
            AtsDbConfigDemoOp config = new AtsDbConfigDemoOp(this.atsApi);
            config.run();
        }
        catch (Exception ex) {
            rd.error(Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }

    public XResultData atsDbInit() {
        XResultData rd = new XResultData();
        try {
            rd = this.atsApi.getConfigService().configAtsDatabase(this.atsApi);
        }
        catch (Exception ex) {
            rd.error(Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }

    public ActionableItem getActionableItem(ArtifactId aiId) {
        return this.atsApi.getActionableItemService().getActionableItemById(aiId);
    }

    public Version getVersion(ArtifactId verId) {
        return this.atsApi.getVersionService().getVersionById(verId);
    }

    public TeamDefinition getTeamDefinition(ArtifactId teamDefId) {
        return this.atsApi.getTeamDefinitionService().getTeamDefinitionById(teamDefId);
    }

    public List<ArtifactToken> getTeamLeads(ArtifactId teamDefId) {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andRelatedTo(AtsRelationTypes.TeamLead_Team, teamDefId).asArtifactTokens();
    }

    public TransactionId demoInitilize(UserToken superUser) {
        TransactionId txId = this.orcsApi.getAdminOps().createDatastoreAndSystemBranches(superUser);
        this.orcsApi.getAdminOps().createDemoBranches();
        this.atsApi.getConfigService().configAtsDatabase(this.atsApi);
        return txId;
    }

    public XResultData validate() {
        AtsHealthCheckOperation op = new AtsHealthCheckOperation(this.atsApi, this.atsApi.getJdbcService(), null);
        return op.run();
    }

    public XResultData getResultTableTest() {
        return ExampleTableData.getResultTable();
    }

    @POST
    @Path(value="branch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BranchData createBranch(BranchData branchData) {
        AtsConfigOperations ops = new AtsConfigOperations(this.atsApi);
        return ops.createBranch(branchData);
    }
}

