/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.exception.OseeWrappedException;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifact;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttribute;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttributeType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelation;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelationType;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsCollectorWriter {
    private final OwCollector collector;
    private final OrcsApi orcsApi;
    private Map<Long, ArtifactId> idToArtifact;
    private TransactionBuilder transaction;
    private final BranchId branch;
    private UserId user;
    private final XResultData results;

    public OrcsCollectorWriter(OrcsApi orcsApi, OwCollector collector, XResultData results) {
        this.orcsApi = orcsApi;
        this.collector = collector;
        this.results = results;
        this.branch = BranchId.valueOf((Long)collector.getBranch().getId());
        this.idToArtifact = new HashMap<Long, ArtifactId>();
    }

    public XResultData run() {
        this.processCreate(this.results);
        this.processUpdate(this.results);
        this.processDelete(this.results);
        this.getTransaction().commit();
        this.results.log("Complete");
        return this.results;
    }

    private void processDelete(XResultData results) {
        for (ArtifactToken owArtifact : this.collector.getDelete()) {
            ArtifactReadable artifact = (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(this.branch).andUuid(owArtifact.getId().longValue()).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            if (artifact.isInvalid()) {
                results.warningf("Delete Artifact Token %s does not exist in database.  Skipping", new Object[]{owArtifact});
                continue;
            }
            this.getTransaction().deleteArtifact((ArtifactId)artifact);
            results.logf("Deleted artifact %s", new Object[]{owArtifact});
        }
    }

    private void processUpdate(XResultData results) {
        for (OwArtifact owArtifact : this.collector.getUpdate()) {
            ArtifactReadable artifact = (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(this.branch).andUuid(owArtifact.getId().longValue()).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            if (artifact.isInvalid()) {
                throw new OseeArgumentException("Artifact not found for OwArtifact %s", new Object[]{owArtifact});
            }
            if (Strings.isValid((String)owArtifact.getName()) && !owArtifact.getName().equals(artifact.getName())) {
                this.getTransaction().setName((ArtifactId)artifact, owArtifact.getName());
                this.logChange(artifact, (AttributeTypeToken)CoreAttributeTypes.Name, artifact.getName(), owArtifact.getName());
            }
            try {
                this.createMissingRelations(owArtifact.getRelations(), (ArtifactId)artifact, results);
            }
            catch (Exception ex) {
                throw new OseeWrappedException((Throwable)ex, "Exception processing relations for [%s]", new Object[]{owArtifact});
            }
            if (owArtifact.getAppId() != null) {
                try {
                    ApplicabilityId appId = ApplicabilityId.BASE;
                    HashMap tokenMap = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(this.branch);
                    Collection tokens = tokenMap.values();
                    for (ApplicabilityToken applicToken : tokens) {
                        if (!applicToken.getName().equals(owArtifact.getAppId().getValue())) continue;
                        appId = ApplicabilityId.valueOf((Long)applicToken.getId());
                        break;
                    }
                    if (appId.isInvalid()) {
                        results.warningf("Couldn't find applicability " + owArtifact.getAppId().getValue() + " on branch %s", new Object[]{this.branch.getIdString()});
                    } else {
                        ApplicabilityId currApp = artifact.getApplicability();
                        if (!currApp.equals(appId)) {
                            this.getTransaction().setApplicability((ArtifactId)artifact, appId);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new OseeWrappedException((Throwable)ex, "Exception processing applicability for [%s]", new Object[]{owArtifact});
                }
            }
            try {
                for (OwAttribute owAttribute : owArtifact.getAttributes()) {
                    AttributeTypeToken attrType = OrcsCollectorWriter.getAttributeType(this.orcsApi.tokenService(), owAttribute.getType());
                    if (artifact.getAttributeCount(attrType) <= 1 && owAttribute.getValues().size() <= 1) {
                        Comparable<Boolean> newVal;
                        Comparable<Boolean> currVal;
                        Object object;
                        String currValue = artifact.getSoleAttributeAsString(attrType, null);
                        String newValue = null;
                        if (owAttribute.getValues().size() == 1 && (object = owAttribute.getValues().iterator().next()) != null) {
                            newValue = owAttribute.getValues().iterator().next().toString();
                        }
                        if (Strings.isValid((String)currValue) && newValue == null) {
                            this.logChange(artifact, attrType, currValue, newValue);
                            this.getTransaction().deleteAttributes((ArtifactId)artifact, attrType);
                            continue;
                        }
                        if (attrType.isBoolean()) {
                            currVal = this.getBoolean(currValue);
                            newVal = this.getBoolean(newValue);
                            if (currVal != null && ((Boolean)currVal).equals(newVal)) continue;
                            this.logChange(artifact, attrType, currValue, newValue);
                            this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newVal);
                            continue;
                        }
                        if (attrType.isDouble()) {
                            try {
                                currVal = this.getDouble(currValue);
                                newVal = this.getDouble(newValue);
                                if (currVal != null && ((Double)currVal).equals(newVal)) continue;
                                this.logChange(artifact, attrType, currValue, newValue);
                                this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newVal);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new OseeArgumentException("Exception processing Double for OwAttribute %s Exception %s", new Object[]{owAttribute, ex});
                            }
                        }
                        if (attrType.isInteger()) {
                            try {
                                currVal = this.getInteger(currValue);
                                newVal = this.getInteger(newValue);
                                if (currVal != null && ((Integer)currVal).equals(newVal)) continue;
                                this.logChange(artifact, attrType, currValue, newValue);
                                this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newVal);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new OseeArgumentException("Exception processing Integer for OwAttribute %s Exception %s", new Object[]{owAttribute, ex});
                            }
                        }
                        if (attrType.isDate()) {
                            try {
                                currVal = (Date)artifact.getSoleAttributeValue(attrType, null);
                                newVal = this.getDate(newValue);
                                if (currVal != null && ((Date)currVal).compareTo((Date)newVal) == 0) continue;
                                this.logChange(artifact, attrType, DateUtil.getMMDDYYHHMM(currVal), DateUtil.getMMDDYYHHMM((Date)newVal));
                                TransactionBuilder tx = this.getTransaction();
                                tx.setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newVal);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new OseeArgumentException("Exception processing Integer for OwAttribute %s Exception %s", new Object[]{owAttribute, ex});
                            }
                        }
                        if (attrType.equals(CoreAttributeTypes.WordTemplateContent)) {
                            if (!newValue.contains("<w:p><w:r><w:t>")) {
                                newValue = "<w:p><w:r><w:t>" + AXml.textToXml((String)newValue) + "</w:t></w:r></w:p>";
                            }
                            if ((currValue != null || newValue == null) && (currValue == null || currValue.equals(newValue))) continue;
                            this.logChange(artifact, attrType, currValue, newValue);
                            this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newValue);
                            continue;
                        }
                        if ((currValue != null || newValue == null) && (currValue == null || currValue.equals(newValue))) continue;
                        this.logChange(artifact, attrType, currValue, newValue);
                        this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)newValue);
                        continue;
                    }
                    if (owAttribute.getValues().size() <= 1 || artifact.getArtifactType().getMax(attrType) <= 1) continue;
                    if (attrType.isDate()) {
                        throw new OseeArgumentException("Date attributes not supported for multi-value set for OwAttribute %s Exception %s", new Object[]{owAttribute});
                    }
                    LinkedList<String> values = new LinkedList<String>();
                    for (Object obj : owAttribute.getValues()) {
                        values.add(obj.toString());
                    }
                    this.getTransaction().setAttributesFromStrings((ArtifactId)artifact, attrType, values);
                    this.logChange(artifact, attrType, artifact.getAttributeValues(attrType).toString(), ((Object)values).toString());
                }
            }
            catch (Exception ex) {
                throw new OseeWrappedException((Throwable)ex, "Exception processing attributes for [%s]", new Object[]{owArtifact});
            }
        }
    }

    private void logChange(ArtifactReadable artifact, AttributeTypeToken attrType, String currValue, String newValue) {
        this.results.log(String.format("Attribute Updated: Current [%s], New [%s] for attr type [%s] and artifact %s", currValue, newValue, attrType, artifact.toStringWithId()));
    }

    private Integer getInteger(String value) {
        Integer result = null;
        if (Strings.isValid((String)value)) {
            result = Integer.valueOf(value);
        }
        return result;
    }

    private Double getDouble(String value) {
        Double result = null;
        if (Strings.isValid((String)value)) {
            result = Double.valueOf(value);
        }
        return result;
    }

    private Boolean getBoolean(String value) {
        if (Strings.isValid((String)value)) {
            if (value.toLowerCase().equals("true")) {
                return true;
            }
            if (value.toLowerCase().equals("false")) {
                return false;
            }
            if (value.equals("1")) {
                return true;
            }
            if (value.equals("0")) {
                return false;
            }
        }
        return null;
    }

    protected static AttributeTypeToken getAttributeType(OrcsTokenService tokenService, OwAttributeType attributeType) {
        AttributeTypeGeneric attributeTypeToken = AttributeTypeToken.SENTINEL;
        if (attributeType != null && attributeType.isValid()) {
            attributeTypeToken = tokenService.getAttributeTypeOrSentinel(attributeType.getId());
        }
        return attributeTypeToken;
    }

    private void processCreate(XResultData results) {
        for (OwArtifact owArtifact : this.collector.getCreate()) {
            OwArtifactType owArtType = owArtifact.getType();
            ArtifactTypeToken artType = this.orcsApi.tokenService().getArtifactTypeOrCreate(owArtType.getId());
            long artifactId = owArtifact.getId();
            String name = owArtifact.getName();
            ApplicabilityId appId = ApplicabilityId.BASE;
            if (owArtifact.getAppId() != null) {
                try {
                    HashMap tokenMap = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(this.branch);
                    Collection tokens = tokenMap.values();
                    for (ApplicabilityToken applicToken : tokens) {
                        if (!applicToken.getName().equals(owArtifact.getAppId().getValue())) continue;
                        appId = ApplicabilityId.valueOf((Long)applicToken.getId());
                        break;
                    }
                    if (appId == null) {
                        results.warningf("Couldn't find applicability " + owArtifact.getAppId().getValue() + " on branch %s", new Object[]{this.branch.getIdString()});
                        appId = ApplicabilityId.BASE;
                    }
                }
                catch (Exception ex) {
                    throw new OseeWrappedException((Throwable)ex, "Exception processing applicability for [%s]", new Object[]{owArtifact});
                }
            }
            ArtifactToken artifact = artifactId < 1L ? this.getTransaction().createArtifact(artType, name, appId) : this.getTransaction().createArtifact(artType, name, Long.valueOf(artifactId), appId);
            if (this.idToArtifact == null) {
                this.idToArtifact = new HashMap<Long, ArtifactId>();
            }
            this.idToArtifact.put(artifactId, (ArtifactId)artifact);
            try {
                this.createAttributes(owArtifact, artifact, results);
            }
            catch (Exception ex) {
                throw new OseeWrappedException((Throwable)ex, "Exception creating attributes for [%s]", new Object[]{owArtifact});
            }
            try {
                this.createMissingRelations(owArtifact, (ArtifactId)artifact, results);
            }
            catch (Exception ex) {
                throw new OseeWrappedException((Throwable)ex, "Exception creating relations for [%s]", new Object[]{owArtifact});
            }
        }
    }

    private void createMissingRelations(OwArtifact owArtifact, ArtifactId artifact, XResultData results) {
        this.createMissingRelations(owArtifact.getRelations(), artifact, results);
    }

    private void createMissingRelations(List<OwRelation> relations, ArtifactId artifact, XResultData results) {
        OrcsTokenService tokenService = this.orcsApi.tokenService();
        for (OwRelation relation : relations) {
            OwRelationType owRelType = relation.getType();
            RelationTypeToken relType = tokenService.getRelationTypeOrCreate(owRelType.getId());
            ArtifactToken artToken = relation.getArtToken();
            ArtifactReadable otherArtifact = null;
            if (this.idToArtifact.containsKey(artToken.getId())) {
                otherArtifact = (ArtifactReadable)this.idToArtifact.get(artToken.getId());
            } else {
                otherArtifact = (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(this.branch).andUuid(artToken.getId().longValue()).getResults().getExactlyOne();
                this.idToArtifact.put(artToken.getId(), (ArtifactId)otherArtifact);
            }
            RelationTypeSide relTypeSide = RelationTypeSide.create((RelationTypeToken)relType, (RelationSide)RelationSide.valueOf((boolean)relation.getType().isSideA()));
            if (relation.getType().isSideA()) {
                if (otherArtifact.areRelated(relTypeSide, (ArtifactReadable)artifact)) continue;
                this.getTransaction().relate((ArtifactId)otherArtifact, relType, artifact, RelationSorter.USER_DEFINED);
                continue;
            }
            if (otherArtifact.areRelated(relTypeSide, (ArtifactReadable)artifact)) continue;
            this.getTransaction().relate(artifact, relType, (ArtifactId)otherArtifact, RelationSorter.USER_DEFINED);
        }
    }

    private void createAttributes(OwArtifact owArtifact, ArtifactToken artifact, XResultData results) {
        for (OwAttribute owAttribute : owArtifact.getAttributes()) {
            if (!CoreAttributeTypes.Name.notEqual(owAttribute.getType().getId())) continue;
            OwAttributeType owAttrType = owAttribute.getType();
            AttributeTypeToken attrType = OrcsCollectorWriter.getAttributeType(this.orcsApi.tokenService(), owAttrType);
            List values = owAttribute.getValues();
            for (Object value : values) {
                String valueOf = String.valueOf(value);
                if (!Strings.isValid((String)valueOf) || valueOf.equals("null")) continue;
                if (attrType.isDouble()) {
                    this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)Double.valueOf((String)value));
                    continue;
                }
                if (attrType.isInteger()) {
                    this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)Integer.valueOf((String)value));
                    continue;
                }
                if (attrType.isBoolean()) {
                    Boolean set = this.getBoolean((String)value);
                    if (set == null) continue;
                    this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)set);
                    continue;
                }
                if (attrType.isDate()) {
                    Date date = this.getDate(value);
                    if (date != null) {
                        this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, (Object)date);
                        continue;
                    }
                    throw new OseeArgumentException("Unexpected date format [%s]", new Object[]{value});
                }
                if (attrType.equals(CoreAttributeTypes.WordTemplateContent)) {
                    if (!valueOf.contains("<w:p><w:r><w:t>")) {
                        valueOf = "<w:p><w:r><w:t>" + AXml.textToXml((String)valueOf) + "</w:t></w:r></w:p>";
                    }
                    this.getTransaction().createAttribute((ArtifactId)artifact, attrType, (Object)valueOf);
                    continue;
                }
                if (artifact.getArtifactType().getMax(attrType) == 1) {
                    this.getTransaction().setSoleAttributeValue((ArtifactId)artifact, attrType, value);
                    continue;
                }
                this.getTransaction().createAttribute((ArtifactId)artifact, attrType, value);
            }
        }
    }

    private Date getDate(Object value) {
        Date date = null;
        boolean resolved = false;
        if (Strings.isNumeric((String)((String)value))) {
            date = new Date(Long.valueOf((String)value));
        } else {
            try {
                date = DateUtil.getDate((String)"MM/dd/yyyy", (String)((String)value));
                resolved = true;
            }
            catch (Exception exception) {}
            if (date == null) {
                try {
                    date = DateUtil.getDate((String)"MM/dd/yy", (String)((String)value));
                    resolved = true;
                }
                catch (Exception exception) {}
            }
            if (date == null) {
                try {
                    date = DateUtil.getDate((String)"MM/dd/yyyy hh:mm a", (String)((String)value));
                    resolved = true;
                }
                catch (Exception exception) {}
            }
            if (date == null) {
                try {
                    Calendar calendar = DatatypeConverter.parseDateTime((String)((String)value));
                    date = calendar.getTime();
                    resolved = true;
                }
                catch (Exception exception) {}
            }
        }
        if (Strings.isValid((String)((String)value)) && !resolved) {
            throw new OseeArgumentException("Date format [%s] not supported.", new Object[]{value});
        }
        return date;
    }

    public TransactionBuilder getTransaction() {
        if (this.transaction == null) {
            this.transaction = this.orcsApi.getTransactionFactory().createTransaction(this.branch, this.collector.getPersistComment());
        }
        return this.transaction;
    }
}

