/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mail.api;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.core.MediaType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.windows.OutlookCalendarEvent;
import org.eclipse.osee.mail.api.internal.MultiPartDataSource;
import org.eclipse.osee.mail.api.internal.StringDataSource;
import org.eclipse.osee.mail.api.internal.UrlDataSource;

public final class MailUtils {
    private static final String OUTLOOK_CALENDAR_EXTENSION = ".vcs";

    private MailUtils() {
    }

    public static boolean isValidEmail(String email) {
        boolean result = false;
        try {
            InternetAddress[] addresses = InternetAddress.parse((String)email, (boolean)true);
            if (addresses != null && addresses.length > 0) {
                result = true;
            }
        }
        catch (AddressException addressException) {}
        return result;
    }

    public static DataSource createFromString(String name, String message, Object ... args) {
        String data = args.length > 0 ? String.format(message, args) : message;
        StringDataSource dataSource = new StringDataSource(name, data);
        dataSource.setCharset("UTF-8");
        dataSource.setContentType("text/plain");
        return dataSource;
    }

    public static DataSource createFromHtml(String name, String htmlData) {
        String plainText = MailUtils.stripHtmlTags(htmlData);
        return MailUtils.createAlternativeDataSource(name, htmlData, plainText);
    }

    public static DataSource createAlternativeDataSource(String name, String htmlText, String plainText) {
        MimeMultipart content = new MimeMultipart("alternative");
        MimeBodyPart html = new MimeBodyPart();
        MimeBodyPart text = new MimeBodyPart();
        try {
            html.setContent((Object)htmlText, "text/html");
        }
        catch (MessagingException ex) {
            throw new OseeCoreException((Throwable)ex, "Error adding HTML content", new Object[0]);
        }
        try {
            text.setText(plainText, "UTF-8");
        }
        catch (MessagingException ex) {
            throw new OseeCoreException((Throwable)ex, "Error adding Text content", new Object[0]);
        }
        try {
            content.addBodyPart((BodyPart)html);
        }
        catch (MessagingException ex) {
            throw new OseeCoreException((Throwable)ex, "Error adding HTML body part", new Object[0]);
        }
        try {
            content.addBodyPart((BodyPart)text);
        }
        catch (MessagingException ex) {
            throw new OseeCoreException((Throwable)ex, "Error adding test body part", new Object[0]);
        }
        return new MultiPartDataSource(name, content);
    }

    public static DataSource createFromUrl(String name, URL url, MediaType mediaType) {
        return new UrlDataSource(name, url, mediaType.toString());
    }

    public static DataSource createOutlookEvent(String eventName, String location, Date startDate, Date endDate) {
        OutlookCalendarEvent calendarEvent = new OutlookCalendarEvent(location, eventName, startDate, endDate);
        String fileName = MailUtils.toFileName(eventName, OUTLOOK_CALENDAR_EXTENSION);
        StringDataSource dataSource = new StringDataSource(fileName, calendarEvent.getEvent()){

            @Override
            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException("OutputStream is not available for this source");
            }
        };
        dataSource.setCharset("UTF-8");
        dataSource.setContentType("text/plain");
        return dataSource;
    }

    private static String toFileName(String value, String extension) {
        String validName;
        String fileName = value;
        if (fileName.endsWith(OUTLOOK_CALENDAR_EXTENSION)) {
            fileName = Lib.removeExtension((String)fileName);
        }
        try {
            validName = URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new OseeCoreException((Throwable)ex, "Error encoding filename", new Object[0]);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(validName);
        builder.append(OUTLOOK_CALENDAR_EXTENSION);
        return builder.toString();
    }

    private static String stripHtmlTags(String html) {
        String plainText = html.replaceAll("<(.|\n)*?>", "");
        plainText = plainText.replaceAll("\t", " ");
        plainText = plainText.replaceAll("\r\n", "");
        plainText = plainText.replaceAll("  +", " ");
        return plainText;
    }
}

